/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.releve.file;

import ancestris.modules.releve.MainPanelRegister;
import ancestris.modules.releve.file.FileBuffer;
import ancestris.modules.releve.file.ReleveFileAncestrisV1;
import ancestris.modules.releve.file.ReleveFileAncestrisV2;
import ancestris.modules.releve.file.ReleveFileAncestrisV3;
import ancestris.modules.releve.file.ReleveFileAncestrisV4;
import ancestris.modules.releve.file.ReleveFileAncestrisV5;
import ancestris.modules.releve.file.ReleveFileAncestrisV6;
import ancestris.modules.releve.file.ReleveFileAncestrisV7;
import ancestris.modules.releve.file.ReleveFileEgmt;
import ancestris.modules.releve.file.ReleveFileNimegue;
import ancestris.modules.releve.file.ReleveFilePdf;
import ancestris.modules.releve.model.AbstractRecord;
import ancestris.modules.releve.model.DataManager;
import ancestris.modules.releve.model.RecordModelAbstract;
import genj.util.EnvironmentChecker;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.openide.util.NbPreferences;

public class FileManager {
    private static final String FILE_DIRECTORY = "FileDirectory";

    public static File getPreferredDir() {
        String defaultDir = EnvironmentChecker.getProperty((String)"user.home", (String)".", (String)"looking for report dir to let the user choose from");
        String dir = NbPreferences.forModule(FileManager.class).get(FILE_DIRECTORY, defaultDir);
        return new File(dir);
    }

    public static void putPreferredDir(File preferredDir) {
        NbPreferences.forModule(FileManager.class).put(FILE_DIRECTORY, preferredDir.getAbsolutePath());
    }

    public static FileBuffer loadFile(File inputFile) throws Exception {
        BufferedReader br = new BufferedReader(new FileReader(inputFile));
        String strLine = br.readLine();
        if (strLine == null || strLine.isEmpty()) {
            throw new Exception(String.format(ResourceBundle.getBundle("ancestris/modules/releve/file/Bundle").getString("file.EmptyFile"), inputFile.getName()));
        }
        StringBuilder sb = new StringBuilder();
        FileBuffer buffer = null;
        if (ReleveFileAncestrisV7.isValidFile(inputFile, sb.append('\n'))) {
            buffer = ReleveFileAncestrisV7.loadFile(inputFile);
        } else if (ReleveFileAncestrisV6.isValidFile(inputFile, sb.append('\n'))) {
            buffer = ReleveFileAncestrisV6.loadFile(inputFile);
        } else if (ReleveFileAncestrisV5.isValidFile(inputFile, sb.append('\n'))) {
            buffer = ReleveFileAncestrisV5.loadFile(inputFile);
        } else if (ReleveFileAncestrisV4.isValidFile(inputFile, sb.append('\n'))) {
            buffer = ReleveFileAncestrisV4.loadFile(inputFile);
        } else if (ReleveFileEgmt.isValidFile(inputFile, sb.append('\n'))) {
            buffer = ReleveFileEgmt.loadFile(inputFile);
        } else if (ReleveFileNimegue.isValidFile(inputFile, sb.append('\n'))) {
            buffer = ReleveFileNimegue.loadFile(inputFile);
        } else if (ReleveFileAncestrisV3.isValidFile(inputFile, sb.append('\n'))) {
            buffer = ReleveFileAncestrisV3.loadFile(inputFile);
        } else if (ReleveFileAncestrisV2.isValidFile(inputFile, sb.append('\n'))) {
            buffer = ReleveFileAncestrisV2.loadFile(inputFile);
        } else if (ReleveFileAncestrisV1.isValidFile(inputFile, sb.append('\n'))) {
            buffer = ReleveFileAncestrisV1.loadFile(inputFile);
        } else {
            throw new Exception(String.format(ResourceBundle.getBundle("ancestris/modules/releve/file/Bundle").getString("file.UnknownFormat"), inputFile.getName()) + "\n" + sb.toString());
        }
        return buffer;
    }

    public static StringBuilder saveFile(DataManager dataManager, File resultFile, FileFormat fileFormat) {
        return FileManager.saveFile(resultFile, fileFormat, dataManager.getDataModel(), null);
    }

    public static StringBuilder saveFile(File saveFile, FileFormat fileFormat, final RecordModelAbstract recordModel, AbstractRecord.RecordType recordType) {
        StringBuilder sb = new StringBuilder();
        if (saveFile != null) {
            NbPreferences.forModule(MainPanelRegister.class).put(FILE_DIRECTORY, saveFile.getParent());
            RecordModelAbstract fileRecordModel = new RecordModelAbstract(){

                @Override
                public int getRowCount() {
                    return recordModel.getRowCount();
                }

                @Override
                public AbstractRecord getRecord(int index) {
                    return recordModel.getRecord(index);
                }
            };
            switch (fileFormat) {
                default: {
                    sb.append((CharSequence)ReleveFileAncestrisV7.saveFile(fileRecordModel, recordType, saveFile, false));
                    break;
                }
                case FILE_TYPE_EGMT: {
                    sb.append((CharSequence)ReleveFileEgmt.saveFile(fileRecordModel, recordType, saveFile, false));
                    break;
                }
                case FILE_TYPE_NIMEGUE: {
                    sb.append((CharSequence)ReleveFileNimegue.saveFile(fileRecordModel, recordType, saveFile, false));
                    break;
                }
                case FILE_TYPE_HTML: {
                    sb.append((CharSequence)ReleveFilePdf.saveFileHtml(fileRecordModel, recordType, saveFile, false));
                    break;
                }
                case FILE_TYPE_PDF: {
                    sb.append((CharSequence)ReleveFilePdf.saveFile(fileRecordModel, recordType, saveFile, false));
                }
            }
        }
        return sb;
    }

    public static enum FileFormat {
        FILE_TYPE_UNKNOW,
        FILE_TYPE_ANCESTRISV1,
        FILE_TYPE_ANCESTRISV2,
        FILE_TYPE_ANCESTRISV3,
        FILE_TYPE_ANCESTRISV4,
        FILE_TYPE_ANCESTRISV5,
        FILE_TYPE_ANCESTRISV6,
        FILE_TYPE_ANCESTRISV7,
        FILE_TYPE_EGMT,
        FILE_TYPE_NIMEGUE,
        FILE_TYPE_HTML,
        FILE_TYPE_PDF;

    }

    public static class Line {
        StringBuilder line = new StringBuilder();
        char fieldSeparator;
        static char quote = (char)34;

        public Line(char fieldSeparator) {
            this.fieldSeparator = fieldSeparator;
        }

        public StringBuilder appendCsvFn(String value, String ... otherValues) {
            return this.appendCsv(value, otherValues).append(this.fieldSeparator);
        }

        public StringBuilder appendCsv(String value, String ... otherValues) {
            int fieldSize = value.length();
            StringBuilder sb = new StringBuilder();
            boolean separatorFound = false;
            sb.append(value);
            separatorFound |= value.indexOf(this.fieldSeparator) != -1;
            for (String otherValue : otherValues) {
                if (otherValue.isEmpty() || otherValue.equals("0d")) continue;
                separatorFound |= value.indexOf(this.fieldSeparator) != -1;
                if (fieldSize > 0) {
                    sb.append(", ");
                }
                sb.append(otherValue);
                fieldSize += otherValue.length();
            }
            if (separatorFound) {
                this.line.append(quote).append((CharSequence)sb).append(quote);
            } else {
                this.line.append((CharSequence)sb);
            }
            return this.line;
        }

        public static List<String> splitCSV(BufferedReader reader, char fieldSeparator) throws IOException {
            String line;
            ArrayList<String> fields = new ArrayList<String>();
            StringBuilder sb = new StringBuilder(100);
            boolean fieldFound = false;
            boolean quoted = false;
            while ((line = reader.readLine()) != null) {
                fieldFound = true;
                int len = line.length();
                for (int i = 0; i < len; ++i) {
                    char c = line.charAt(i);
                    if (c == quote) {
                        if (quoted && i < len - 1 && line.charAt(i + 1) == quote) {
                            sb.append(c);
                            ++i;
                            continue;
                        }
                        if (quoted) {
                            if (i == len - 1 || line.charAt(i + 1) == fieldSeparator) {
                                quoted = false;
                                continue;
                            }
                        } else if (sb.length() == 0) {
                            quoted = true;
                            continue;
                        }
                        sb.append(c);
                        continue;
                    }
                    if (c == fieldSeparator && !quoted) {
                        fields.add(sb.toString());
                        sb.setLength(0);
                        continue;
                    }
                    sb.append(c);
                }
                if (!quoted) break;
                sb.append('\n');
            }
            if (fieldFound) {
                fields.add(sb.toString());
                return fields;
            }
            return null;
        }

        public StringBuilder appendNimegueFn(String value, String ... otherValues) {
            return this.appendNimegue(value, otherValues).append(this.fieldSeparator);
        }

        public StringBuilder appendNimegue(String value, String ... otherValues) {
            int fieldSize = value.length();
            this.line.append(value.replace(this.fieldSeparator, '.'));
            for (String otherValue : otherValues) {
                if (otherValue.isEmpty()) continue;
                if (fieldSize > 0) {
                    this.line.append(", ");
                }
                this.line.append(otherValue.replace(this.fieldSeparator, '.'));
                fieldSize += otherValue.length();
            }
            return this.line;
        }

        public String toString() {
            return this.line.toString();
        }
    }
}

