/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.releve.editor;

import ancestris.modules.releve.MainPanelInterface;
import ancestris.modules.releve.MainPanelRegister;
import ancestris.modules.releve.MenuCommandProvider;
import ancestris.modules.releve.RelevePanel;
import ancestris.modules.releve.ReleveTopComponent;
import ancestris.modules.releve.editor.Bean;
import ancestris.modules.releve.imageBrowser.BrowserPanel;
import ancestris.modules.releve.model.AbstractRecord;
import ancestris.modules.releve.model.DataManager;
import ancestris.modules.releve.model.RecordInfoPlace;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class MainPanelTranscriber
extends JPanel
implements MainPanelInterface {
    private static final String DOCKED_EDITOR_WIDTH_KEY = "DockedEditorWidth";
    private static final String DOCKED_BROWSER_WIDTH_KEY = "DockedBrowserWidth";
    private static final String DOCKED_EDITOR_SIZE_KEY = "DockedEditorSize";
    private static final String SPLIT_PANE_KEY = "TranscriberSplitPane";
    private boolean isStandalone = false;
    private final Set<PropertyChangeListener> listeners = new HashSet<PropertyChangeListener>();
    private final JLabel fileNameLabel;
    private JButton buttonSave;
    private String recordDescription;
    private BrowserPanel browserPanel1;
    private JSplitPane jSplitPane1;
    private JTabbedPane jTabbedPane1;
    private RelevePanel panelAll;
    private RelevePanel panelBirth;
    private RelevePanel panelDeath;
    private RelevePanel panelMarriage;
    private RelevePanel panelMisc;
    private JSeparator separator1;
    private JSeparator separator2;
    private Box.Filler filler1;

    public MainPanelTranscriber(boolean isStandalone) {
        this.isStandalone = isStandalone;
        this.initComponents();
        this.browserPanel1.setParent(this);
        this.separator1 = new JToolBar.Separator();
        this.separator2 = new JToolBar.Separator();
        this.fileNameLabel = new JLabel("", new ImageIcon(MainPanelRegister.class.getResource("/ancestris/modules/releve/images/Filename.png")), 10);
        this.filler1 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.panelBirth.setTranscriberMode(isStandalone, this);
        this.panelMarriage.setTranscriberMode(isStandalone, this);
        this.panelDeath.setTranscriberMode(isStandalone, this);
        this.panelMisc.setTranscriberMode(isStandalone, this);
        this.panelAll.setTranscriberMode(isStandalone, this);
        this.recordDescription = "";
        if (!isStandalone) {
            this.jSplitPane1.setResizeWeight(1.0);
            int dividerLocation = Integer.parseInt(NbPreferences.forModule(MainPanelTranscriber.class).get(SPLIT_PANE_KEY, "10"));
            if (dividerLocation > 10) {
                this.jSplitPane1.setDividerLocation(dividerLocation);
            }
            String size = NbPreferences.forModule(MainPanelTranscriber.class).get(DOCKED_EDITOR_SIZE_KEY, "300,450,0,0");
            Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
            String[] dimensions = size.split(",");
            if (dimensions.length >= 4) {
                int y;
                int x;
                int height;
                int width = Integer.parseInt(dimensions[0]);
                if (width > screen.width) {
                    width = screen.width - 1;
                }
                if (width < 300) {
                    width = 300;
                }
                if ((height = Integer.parseInt(dimensions[1])) > screen.height) {
                    height = screen.height - 1;
                }
                if (height < 450) {
                    height = 450;
                }
                if ((x = Integer.parseInt(dimensions[2]) - width) + width > screen.width) {
                    x = screen.width - width;
                }
                if (x < 0) {
                    x = (screen.width - width) / 2;
                }
                if ((y = Integer.parseInt(dimensions[3])) + height > screen.height) {
                    y = screen.height - height;
                }
                if (height < 0) {
                    height = (screen.height - height) / 2;
                }
                this.setBounds(x, y, width, height);
                this.validate();
            } else {
                this.setBounds(screen.width / 2 - 100, screen.height / 2 - 100, 300, 450);
                this.validate();
            }
            int editorWidth = Integer.parseInt(NbPreferences.forModule(MainPanelTranscriber.class).get(DOCKED_EDITOR_WIDTH_KEY, "300"));
            int browserWidth = Integer.parseInt(NbPreferences.forModule(MainPanelTranscriber.class).get(DOCKED_BROWSER_WIDTH_KEY, "600"));
            this.jSplitPane1.getRightComponent().setSize(editorWidth, this.jSplitPane1.getRightComponent().getHeight());
            this.jSplitPane1.getLeftComponent().setSize(browserWidth, this.jSplitPane1.getLeftComponent().getHeight());
            int dividerSize = 5;
            int leftx = this.getX() + this.getWidth();
            int externalBorderWidth = 2;
            int width = this.jSplitPane1.getRightComponent().getWidth() + browserWidth + dividerSize + externalBorderWidth;
            int x = leftx - width;
            this.jSplitPane1.getLeftComponent().setVisible(true);
            this.jSplitPane1.setDividerSize(dividerSize);
            this.setBounds(x, this.getY(), width, this.getHeight());
        }
        if (isStandalone) {
            this.jSplitPane1.getLeftComponent().setVisible(false);
            this.jSplitPane1.setDividerSize(0);
        }
        String shortCut = "StandaloneShortcut";
        this.jTabbedPane1.getInputMap(2).put(KeyStroke.getKeyStroke("alt N"), shortCut);
        this.jTabbedPane1.getInputMap(2).put(KeyStroke.getKeyStroke("alt M"), shortCut);
        this.jTabbedPane1.getInputMap(2).put(KeyStroke.getKeyStroke("alt D"), shortCut);
        this.jTabbedPane1.getInputMap(2).put(KeyStroke.getKeyStroke("alt V"), shortCut);
        this.jTabbedPane1.getInputMap(2).put(KeyStroke.getKeyStroke("alt T"), shortCut);
        this.jTabbedPane1.getActionMap().put(shortCut, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand().toUpperCase().equals("N")) {
                    MainPanelTranscriber.this.jTabbedPane1.setSelectedComponent(MainPanelTranscriber.this.panelBirth);
                    MainPanelTranscriber.this.panelBirth.createRecord();
                } else if (actionEvent.getActionCommand().toUpperCase().equals("M")) {
                    MainPanelTranscriber.this.jTabbedPane1.setSelectedComponent(MainPanelTranscriber.this.panelMarriage);
                    MainPanelTranscriber.this.panelMarriage.createRecord();
                } else if (actionEvent.getActionCommand().toUpperCase().equals("D")) {
                    MainPanelTranscriber.this.jTabbedPane1.setSelectedComponent(MainPanelTranscriber.this.panelDeath);
                    MainPanelTranscriber.this.panelDeath.createRecord();
                } else if (actionEvent.getActionCommand().toUpperCase().equals("V")) {
                    MainPanelTranscriber.this.jTabbedPane1.setSelectedComponent(MainPanelTranscriber.this.panelMisc);
                    MainPanelTranscriber.this.panelMisc.createRecord();
                } else if (actionEvent.getActionCommand().toUpperCase().equals("T")) {
                    MainPanelTranscriber.this.jTabbedPane1.setSelectedComponent(MainPanelTranscriber.this.panelAll);
                    MainPanelTranscriber.this.panelAll.createRecord();
                }
            }
        });
    }

    public void setRegister(MainPanelRegister mainPanelRegister) {
        try {
            this.buttonSave = MainPanelRegister.ButtonFactory.create(mainPanelRegister, "save", "saveFile", "SaveFile.png");
            this.buttonSave.setPreferredSize(new Dimension(36, 32));
        }
        catch (NoSuchMethodException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.buttonSave.setEnabled(mainPanelRegister.getDataManager().isDirty());
        mainPanelRegister.getDataManager().getDataModel().addPropertyChangeListener(evt -> this.buttonSave.setEnabled((Boolean)evt.getNewValue()));
    }

    public boolean createRecord(int panelType, Map<AbstractRecord.FieldType, String> fieldValueMap) {
        RelevePanel panel = switch (panelType) {
            case 0 -> this.panelBirth;
            case 1 -> this.panelMarriage;
            case 2 -> this.panelDeath;
            case 3 -> this.panelMisc;
            default -> this.panelAll;
        };
        this.jTabbedPane1.setSelectedComponent(panel);
        AbstractRecord record = panel.createRecord();
        if (record != null) {
            String[] placeBits = fieldValueMap.get((Object)AbstractRecord.FieldType.place).split(",");
            if (placeBits.length > 1) {
                String city = placeBits[0].trim();
                String country = placeBits[1].trim();
                RecordInfoPlace place = new RecordInfoPlace();
                place.setCityName(city);
                place.setCountryName(country);
                panel.updatePlace(place);
            }
            for (AbstractRecord.FieldType fieldType : fieldValueMap.keySet()) {
                Bean bean = panel.getBean(fieldType);
                if (bean == null) continue;
                bean.setFieldValue(fieldValueMap.get((Object)fieldType));
                bean.refresh();
                bean.commitImpl();
            }
            return true;
        }
        return false;
    }

    @Override
    public String getInfoText() {
        return NbBundle.getMessage(ReleveTopComponent.class, (String)"mainPanelTranscriber.info");
    }

    @Override
    public JComponent[] getMenuComponents() {
        ArrayList<JComponent> list = new ArrayList<JComponent>(Arrays.asList(this.browserPanel1.getMenuComponents()));
        list.add(this.separator1);
        list.add(this.buttonSave);
        list.add(this.fileNameLabel);
        list.add(this.filler1);
        list.add(this.separator2);
        RelevePanel panel = (RelevePanel)this.jTabbedPane1.getSelectedComponent();
        list.addAll(Arrays.asList(panel.getMenuComponents()));
        return (JComponent[])list.toArray(JComponent[]::new);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        super.addPropertyChangeListener(l);
        if (l instanceof ReleveTopComponent) {
            this.listeners.add(l);
        }
    }

    @Override
    public void firePropertyChangeEvent(PropertyChangeEvent evt) {
        for (PropertyChangeListener l : this.listeners) {
            l.propertyChange(evt);
        }
    }

    @Override
    public boolean canClose() {
        return true;
    }

    @Override
    public void componentClosed() {
        this.panelBirth.componentClosed();
        this.panelMarriage.componentClosed();
        this.panelDeath.componentClosed();
        this.panelMisc.componentClosed();
        this.panelAll.componentClosed();
        if (!this.isStandalone) {
            String size = String.valueOf(this.getWidth()) + "," + String.valueOf(this.getHeight()) + "," + String.valueOf(this.getX() + this.getWidth()) + "," + String.valueOf(this.getY());
            NbPreferences.forModule(MainPanelTranscriber.class).put(DOCKED_EDITOR_SIZE_KEY, size);
            this.browserPanel1.componentClosed();
        }
    }

    public void setDataManager(DataManager dataManager, MenuCommandProvider menuCommandProvider, int recordBirthIndex, int recordMarriageIndex, int recordDeathIndex, int recordMiscIndex, int recordAllIndex, int selectedPanel) {
        this.panelBirth.setModel(dataManager, RelevePanel.PanelType.birth, menuCommandProvider, this);
        this.panelMarriage.setModel(dataManager, RelevePanel.PanelType.marriage, menuCommandProvider, this);
        this.panelDeath.setModel(dataManager, RelevePanel.PanelType.death, menuCommandProvider, this);
        this.panelMisc.setModel(dataManager, RelevePanel.PanelType.misc, menuCommandProvider, this);
        this.panelAll.setModel(dataManager, RelevePanel.PanelType.all, menuCommandProvider, this);
        this.jTabbedPane1.setSelectedIndex(selectedPanel);
        this.panelBirth.selectRecord(recordBirthIndex);
        this.panelMarriage.selectRecord(recordMarriageIndex);
        this.panelDeath.selectRecord(recordDeathIndex);
        this.panelMisc.selectRecord(recordMiscIndex);
        this.panelAll.selectRecord(recordAllIndex);
    }

    public void selectRecord(DataManager dataManager, int panelIndex, int recordIndex) {
        AbstractRecord record = dataManager.getRecord(recordIndex);
        if (record != null) {
            this.jTabbedPane1.setSelectedIndex(panelIndex);
            switch (panelIndex) {
                case 0: {
                    this.panelBirth.selectRecord(recordIndex);
                    break;
                }
                case 1: {
                    this.panelMarriage.selectRecord(recordIndex);
                    break;
                }
                case 2: {
                    this.panelDeath.selectRecord(recordIndex);
                    break;
                }
                case 3: {
                    this.panelMisc.selectRecord(recordIndex);
                    break;
                }
                default: {
                    this.panelAll.selectRecord(recordIndex);
                }
            }
            this.browserPanel1.showImage(record.getFieldValue(AbstractRecord.FieldType.eventMedia), null, record.getCity(), record.getFieldValue(AbstractRecord.FieldType.notary), record.getFieldValue(AbstractRecord.FieldType.cote), record.getFieldValue(AbstractRecord.FieldType.freeComment));
        }
    }

    public void refreshImageList() {
        this.browserPanel1.refreshImageList();
    }

    @Override
    public void recordSelectionChanged() {
        int recordIndex;
        AbstractRecord record = switch (this.jTabbedPane1.getSelectedIndex()) {
            case 0 -> {
                recordIndex = this.panelBirth.getCurrentRecordIndex();
                yield this.panelBirth.getCurrentRecord();
            }
            case 1 -> {
                recordIndex = this.panelMarriage.getCurrentRecordIndex();
                yield this.panelMarriage.getCurrentRecord();
            }
            case 2 -> {
                recordIndex = this.panelDeath.getCurrentRecordIndex();
                yield this.panelDeath.getCurrentRecord();
            }
            case 3 -> {
                recordIndex = this.panelMisc.getCurrentRecordIndex();
                yield this.panelMisc.getCurrentRecord();
            }
            default -> {
                recordIndex = this.panelAll.getCurrentRecordIndex();
                yield this.panelAll.getCurrentRecord();
            }
        };
        if (record != null) {
            this.browserPanel1.selectImage(record.getFieldValue(AbstractRecord.FieldType.eventMedia), record.getCity(), record.getFieldValue(AbstractRecord.FieldType.notary), record.getFieldValue(AbstractRecord.FieldType.cote), record.getFieldValue(AbstractRecord.FieldType.freeComment));
        }
        if (this.isStandalone) {
            this.setFrameTitle(recordIndex);
        }
    }

    public void setFileName(String name, String tip) {
        this.fileNameLabel.setText(name);
        this.fileNameLabel.setToolTipText(tip);
        if (this.isStandalone) {
            this.getFrame().setTitle(name);
        }
    }

    public void settingsUpdated() {
        this.browserPanel1.settingsUpdated();
    }

    public JFrame getFrame() {
        return (JFrame)SwingUtilities.getWindowAncestor(this);
    }

    private void setFrameTitle(int recordIndex) {
        JLabel label = (JLabel)this.jTabbedPane1.getTabComponentAt(this.jTabbedPane1.getSelectedIndex());
        if (label != null) {
            this.recordDescription = label.getText();
            if (recordIndex > -1) {
                this.recordDescription = this.recordDescription + " / " + (recordIndex + 1);
            }
            this.getFrame().setTitle(this.fileNameLabel.getText() + " / " + this.recordDescription);
        }
    }

    public void setBrowserDirectory(File outputDirectory) {
        this.browserPanel1.setCurrentImageDirectory(outputDirectory);
    }

    @Override
    public String getSelectedFileAbsolutePath() {
        return this.browserPanel1.getSelectedFileAbsolutePath();
    }

    public void extractInformation(String filename) {
        this.browserPanel1.grabFocus();
        if (!filename.isBlank()) {
            this.browserPanel1.selectAndExtract(new File(filename).getName());
        }
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.browserPanel1 = new BrowserPanel();
        this.jTabbedPane1 = new JTabbedPane();
        this.panelBirth = new RelevePanel();
        this.panelMarriage = new RelevePanel();
        this.panelDeath = new RelevePanel();
        this.panelMisc = new RelevePanel();
        this.panelAll = new RelevePanel();
        this.setLayout(new BorderLayout());
        this.jSplitPane1.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                MainPanelTranscriber.this.jSplitPane1PropertyChange(evt);
            }
        });
        this.jSplitPane1.setLeftComponent(this.browserPanel1);
        this.jTabbedPane1.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                MainPanelTranscriber.this.jTabbedPane1StateChanged(evt);
            }
        });
        this.jTabbedPane1.addTab(NbBundle.getMessage(MainPanelTranscriber.class, (String)"StandaloneEditor.birthEditor.TabConstraints.tabTitle"), this.panelBirth);
        this.jTabbedPane1.setTabComponentAt(0, new JLabel(NbBundle.getMessage(MainPanelRegister.class, (String)"MainPanelRegister.panelBirth.TabConstraints.tabTitle"), new ImageIcon(this.getClass().getResource("/ancestris/modules/releve/images/Birth.png")), 2));
        this.jTabbedPane1.addTab(NbBundle.getMessage(MainPanelTranscriber.class, (String)"StandaloneEditor.marriageEditor.TabConstraints.tabTitle"), this.panelMarriage);
        this.jTabbedPane1.setTabComponentAt(1, new JLabel(NbBundle.getMessage(MainPanelRegister.class, (String)"MainPanelRegister.panelMarriage.TabConstraints.tabTitle"), new ImageIcon(this.getClass().getResource("/ancestris/modules/releve/images/Marriage.png")), 2));
        this.jTabbedPane1.addTab(NbBundle.getMessage(MainPanelTranscriber.class, (String)"StandaloneEditor.deathEditor.TabConstraints.tabTitle"), this.panelDeath);
        this.jTabbedPane1.setTabComponentAt(2, new JLabel(NbBundle.getMessage(MainPanelRegister.class, (String)"MainPanelRegister.panelDeath.TabConstraints.tabTitle"), new ImageIcon(this.getClass().getResource("/ancestris/modules/releve/images/Death.png")), 2));
        this.jTabbedPane1.addTab(NbBundle.getMessage(MainPanelTranscriber.class, (String)"StandaloneEditor.miscEditor.TabConstraints.tabTitle"), this.panelMisc);
        this.jTabbedPane1.setTabComponentAt(3, new JLabel(NbBundle.getMessage(MainPanelRegister.class, (String)"MainPanelRegister.panelMisc.TabConstraints.tabTitle"), new ImageIcon(this.getClass().getResource("/ancestris/modules/releve/images/misc.png")), 2));
        this.jTabbedPane1.addTab(NbBundle.getMessage(MainPanelTranscriber.class, (String)"MainPanelTranscriber.panelAll.TabConstraints.tabTitle"), this.panelAll);
        this.jTabbedPane1.setTabComponentAt(4, new JLabel(NbBundle.getMessage(MainPanelRegister.class, (String)"MainPanelRegister.panelAll.TabConstraints.tabTitle"), new ImageIcon(this.getClass().getResource("/ancestris/modules/releve/images/All.png")), 2));
        this.jSplitPane1.setRightComponent(this.jTabbedPane1);
        this.add((Component)this.jSplitPane1, "Center");
    }

    private void jSplitPane1PropertyChange(PropertyChangeEvent evt) {
        int newValue;
        int oldValue;
        if (!this.isStandalone && evt.getPropertyName().equals("dividerLocation") && Math.abs((oldValue = ((Integer)evt.getOldValue()).intValue()) - (newValue = ((Integer)evt.getNewValue()).intValue())) < 20) {
            NbPreferences.forModule(MainPanelTranscriber.class).put(SPLIT_PANE_KEY, String.valueOf(this.jSplitPane1.getDividerLocation()));
            int editorWidth = this.jSplitPane1.getRightComponent().getWidth();
            int browserWidth = this.jSplitPane1.getLeftComponent().getWidth();
            NbPreferences.forModule(MainPanelTranscriber.class).put(DOCKED_EDITOR_WIDTH_KEY, String.valueOf(editorWidth));
            NbPreferences.forModule(MainPanelTranscriber.class).put(DOCKED_BROWSER_WIDTH_KEY, String.valueOf(browserWidth));
        }
    }

    private void jTabbedPane1StateChanged(ChangeEvent evt) {
        this.firePropertyChangeEvent(new PropertyChangeEvent(this, ReleveTopComponent.TAB_CHANGED, this.jTabbedPane1, null));
        this.recordSelectionChanged();
    }
}

