/*
 * Decompiled with CFR 0.152.
 */
package ancestris.report.svgtree;

import ancestris.report.svgtree.FamBox;
import genj.gedcom.Fam;
import genj.gedcom.Indi;
import java.util.logging.Logger;

public class IndiBox {
    private static final Logger LOG = Logger.getLogger("ancestris.report.svgtree", null);
    public static int totalBoxes = 0;
    public static int netTotalBoxes = 0;
    public Indi individual;
    public IndiBox prev = null;
    public IndiBox spouse = null;
    public FamBox family;
    public IndiBox parent = null;
    public IndiBox[] children = null;
    public IndiBox nextMarriage = null;
    public int gen;
    public int x = 0;
    public int y = 0;
    public int width = 10;
    public int height = 10;
    public int wPlus = 0;
    public int wMinus = 0;
    public int hPlus = 0;
    public int hMinus = 0;

    public IndiBox(Indi individual, int generation) {
        LOG.fine("New indibox : " + individual.toString());
        this.individual = individual;
        this.gen = generation;
        ++totalBoxes;
    }

    public IndiBox(Indi individual, IndiBox prev, int generation) {
        LOG.fine("New indibox : " + individual.toString() + " with prev :" + prev.toString());
        this.individual = individual;
        this.prev = prev;
        this.gen = generation;
        ++totalBoxes;
    }

    public Direction getDir() {
        if (this.prev == null) {
            return Direction.NONE;
        }
        if (this == this.prev.spouse) {
            return Direction.SPOUSE;
        }
        if (this == this.prev.parent) {
            return Direction.PARENT;
        }
        if (this == this.prev.nextMarriage) {
            return Direction.NEXTMARRIAGE;
        }
        return Direction.CHILD;
    }

    public boolean hasChildren() {
        return this.children != null && this.children.length > 0;
    }

    public Fam getFamily() {
        if (this.family == null) {
            return null;
        }
        return this.family.family;
    }

    public static void setTotalBoxes(int set) {
        totalBoxes = set;
    }

    public static int getTotalBoxes() {
        return totalBoxes;
    }

    public static int getNetTotalBoxes() {
        return netTotalBoxes;
    }

    public String toString() {
        return "IndiBox for : " + this.individual.toString() + "\nprev=" + (Comparable)((Object)(this.prev == null ? "NULL" : this.prev.individual)) + "\ngen=" + this.gen + "\nx=" + this.x + "\ny=" + this.y + "\nwPlus=" + this.wPlus + "\nwMinus=" + this.wMinus + "\nhPlus=" + this.hPlus + "\nhMinus=" + this.hMinus + "\n";
    }

    public static enum Direction {
        NONE,
        SPOUSE,
        PARENT,
        CHILD,
        NEXTMARRIAGE;

    }
}

