/*
 * Decompiled with CFR 0.152.
 */
package org.geonames;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geonames.Address;
import org.geonames.BoundingBox;
import org.geonames.FeatureClass;
import org.geonames.GeoNamesException;
import org.geonames.Intersection;
import org.geonames.PostalCode;
import org.geonames.PostalCodeSearchCriteria;
import org.geonames.StreetSegment;
import org.geonames.Style;
import org.geonames.Timezone;
import org.geonames.Toponym;
import org.geonames.ToponymSearchCriteria;
import org.geonames.ToponymSearchResult;
import org.geonames.WeatherObservation;
import org.geonames.WikipediaArticle;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class WebService {
    private static Logger logger;
    private static String USER_AGENT;
    private static boolean isAndroid;
    private static String geoNamesServer;
    private static String geoNamesServerFailover;
    private static long timeOfLastFailureMainServer;
    private static long averageConnectTime;
    private static long averageSampleSize;
    private static Style defaultStyle;
    private static int readTimeOut;
    private static int connectTimeOut;
    private static String DATEFMT;
    private static Proxy proxy;
    private static String userName;
    private static String token;
    private static TimeZone utc;

    private static String addUserName(String string) {
        if (userName != null) {
            string = string + "&username=" + userName;
        }
        if (token != null) {
            string = string + "&token=" + token;
        }
        return string;
    }

    private static String addDefaultStyle(String string) {
        if (defaultStyle != Style.MEDIUM) {
            string = string + "&style=" + defaultStyle.name();
        }
        return string;
    }

    private static String getCurrentlyActiveServer() {
        if (timeOfLastFailureMainServer == 0L) {
            return geoNamesServer;
        }
        if (System.currentTimeMillis() - timeOfLastFailureMainServer > 600000L) {
            timeOfLastFailureMainServer = 0L;
            return geoNamesServer;
        }
        if (System.currentTimeMillis() < timeOfLastFailureMainServer) {
            throw new Error("time of last failure cannot be in future.");
        }
        if (geoNamesServerFailover != null) {
            return geoNamesServerFailover;
        }
        return geoNamesServer;
    }

    public static boolean isAndroid() {
        return isAndroid;
    }

    private static InputStream connect(String string) throws IOException {
        int n = 0;
        String string2 = WebService.getCurrentlyActiveServer();
        try {
            long l = System.currentTimeMillis();
            HttpURLConnection httpURLConnection = null;
            httpURLConnection = proxy == null ? (HttpURLConnection)new URL(string2 + string).openConnection() : (HttpURLConnection)new URL(string2 + string).openConnection(proxy);
            httpURLConnection.setConnectTimeout(connectTimeOut);
            httpURLConnection.setReadTimeout(readTimeOut);
            httpURLConnection.setRequestProperty("User-Agent", USER_AGENT);
            InputStream inputStream = httpURLConnection.getInputStream();
            n = httpURLConnection.getResponseCode();
            if (n == 200) {
                long l2 = System.currentTimeMillis() - l;
                averageConnectTime = (averageConnectTime * (averageSampleSize - 1L) + l2) / averageSampleSize;
                if (geoNamesServerFailover != null && averageConnectTime > 5000L && !string2.equals(geoNamesServerFailover)) {
                    timeOfLastFailureMainServer = System.currentTimeMillis();
                }
                return inputStream;
            }
        }
        catch (IOException iOException) {
            return WebService.tryFailoverServer(string, string2, 0, iOException);
        }
        IOException iOException = new IOException("status code " + n + " for " + string);
        return WebService.tryFailoverServer(string, string2, n, iOException);
    }

    private static synchronized InputStream tryFailoverServer(String string, String string2, int n, IOException iOException) throws MalformedURLException, IOException {
        logger.log(Level.WARNING, "problems connecting to geonames server " + string2, iOException);
        if (geoNamesServerFailover == null || string2.equals(geoNamesServerFailover)) {
            if (string2.equals(geoNamesServerFailover)) {
                timeOfLastFailureMainServer = 0L;
            }
            throw iOException;
        }
        timeOfLastFailureMainServer = System.currentTimeMillis();
        logger.info("trying to connect to failover server " + geoNamesServerFailover);
        URLConnection uRLConnection = null;
        uRLConnection = proxy == null ? new URL(geoNamesServerFailover + string).openConnection() : new URL(geoNamesServerFailover + string).openConnection(proxy);
        String string3 = USER_AGENT + " failover from " + geoNamesServer;
        if (n != 0) {
            string3 = string3 + " " + n;
        }
        uRLConnection.setRequestProperty("User-Agent", string3);
        InputStream inputStream = uRLConnection.getInputStream();
        return inputStream;
    }

    private static Element connectAndParse(String string) throws GeoNamesException, IOException, JDOMException {
        SAXBuilder sAXBuilder = new SAXBuilder();
        Document document = sAXBuilder.build(WebService.connect(string));
        try {
            Element element = WebService.rootAndCheckException(document);
            return element;
        }
        catch (GeoNamesException geoNamesException) {
            if (geoNamesException.getExceptionCode() == 13 || geoNamesException.getMessage() != null && geoNamesException.getMessage().indexOf("canceling statement due to statement timeout") > -1) {
                String string2 = WebService.getCurrentlyActiveServer();
                if (geoNamesServerFailover != null && !string2.equals(geoNamesServerFailover)) {
                    timeOfLastFailureMainServer = System.currentTimeMillis();
                    document = sAXBuilder.build(WebService.connect(string));
                    Element element = WebService.rootAndCheckException(document);
                    return element;
                }
            }
            throw geoNamesException;
        }
    }

    private static Element rootAndCheckException(Document document) throws GeoNamesException {
        Element element = document.getRootElement();
        WebService.checkException(element);
        return element;
    }

    private static void checkException(Element element) throws GeoNamesException {
        Element element2 = element.getChild("status");
        if (element2 != null) {
            int n = 0;
            try {
                n = Integer.parseInt(element2.getAttributeValue("value"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            throw new GeoNamesException(n, element2.getAttributeValue("message"));
        }
    }

    private static Toponym getToponymFromElement(Element element) {
        Timezone timezone;
        String string;
        Toponym toponym = new Toponym();
        toponym.setName(element.getChildText("name"));
        toponym.setAlternateNames(element.getChildText("alternateNames"));
        toponym.setLatitude(Double.parseDouble(element.getChildText("lat")));
        toponym.setLongitude(Double.parseDouble(element.getChildText("lng")));
        String string2 = element.getChildText("geonameId");
        if (string2 != null) {
            toponym.setGeoNameId(Integer.parseInt(string2));
        }
        toponym.setContinentCode(element.getChildText("continentCode"));
        toponym.setCountryCode(element.getChildText("countryCode"));
        toponym.setCountryName(element.getChildText("countryName"));
        toponym.setFeatureClass(FeatureClass.fromValue(element.getChildText("fcl")));
        toponym.setFeatureCode(element.getChildText("fcode"));
        toponym.setFeatureClassName(element.getChildText("fclName"));
        toponym.setFeatureCodeName(element.getChildText("fCodeName"));
        String string3 = element.getChildText("population");
        if (string3 != null && !"".equals(string3)) {
            toponym.setPopulation(Long.parseLong(string3));
        }
        if ((string = element.getChildText("elevation")) != null && !"".equals(string)) {
            toponym.setElevation(Integer.parseInt(string));
        }
        toponym.setAdminCode1(element.getChildText("adminCode1"));
        toponym.setAdminName1(element.getChildText("adminName1"));
        toponym.setAdminCode2(element.getChildText("adminCode2"));
        toponym.setAdminName2(element.getChildText("adminName2"));
        toponym.setAdminCode3(element.getChildText("adminCode3"));
        toponym.setAdminName3(element.getChildText("adminName3"));
        toponym.setAdminCode4(element.getChildText("adminCode4"));
        toponym.setAdminName4(element.getChildText("adminName4"));
        toponym.setAdminCode5(element.getChildText("adminCode5"));
        toponym.setAdminName5(element.getChildText("adminName5"));
        Element element2 = element.getChild("timezone");
        if (element2 != null) {
            timezone = new Timezone();
            timezone.setTimezoneId(element2.getValue());
            timezone.setDstOffset(Double.parseDouble(element2.getAttributeValue("dstOffset")));
            timezone.setGmtOffset(Double.parseDouble(element2.getAttributeValue("gmtOffset")));
            toponym.setTimezone(timezone);
        }
        if ((timezone = element.getChild("bbox")) != null) {
            BoundingBox boundingBox = new BoundingBox(Double.parseDouble(timezone.getChildText("west")), Double.parseDouble(timezone.getChildText("east")), Double.parseDouble(timezone.getChildText("south")), Double.parseDouble(timezone.getChildText("north")));
            toponym.setBoundingBox(boundingBox);
        }
        return toponym;
    }

    private static WikipediaArticle getWikipediaArticleFromElement(Element element) {
        String string;
        WikipediaArticle wikipediaArticle = new WikipediaArticle();
        wikipediaArticle.setLanguage(element.getChildText("lang"));
        wikipediaArticle.setTitle(element.getChildText("title"));
        wikipediaArticle.setSummary(element.getChildText("summary"));
        wikipediaArticle.setFeature(element.getChildText("feature"));
        wikipediaArticle.setWikipediaUrl(element.getChildText("wikipediaUrl"));
        wikipediaArticle.setThumbnailImg(element.getChildText("thumbnailImg"));
        wikipediaArticle.setLatitude(Double.parseDouble(element.getChildText("lat")));
        wikipediaArticle.setLongitude(Double.parseDouble(element.getChildText("lng")));
        wikipediaArticle.setRank(Integer.parseInt(element.getChildText("rank")));
        String string2 = element.getChildText("population");
        if (string2 != null && !"".equals(string2)) {
            wikipediaArticle.setPopulation(Integer.parseInt(string2));
        }
        if ((string = element.getChildText("elevation")) != null && !"".equals(string)) {
            wikipediaArticle.setElevation(Integer.parseInt(string));
        }
        return wikipediaArticle;
    }

    private static WeatherObservation getWeatherObservationFromElement(Element element) throws ParseException {
        String string;
        String string2;
        WeatherObservation weatherObservation = new WeatherObservation();
        weatherObservation.setObservation(element.getChildText("observation"));
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATEFMT);
        simpleDateFormat.setTimeZone(utc);
        weatherObservation.setObservationTime(simpleDateFormat.parse(element.getChildText("observationTime")));
        weatherObservation.setStationName(element.getChildText("stationName"));
        weatherObservation.setIcaoCode(element.getChildText("ICAO"));
        weatherObservation.setCountryCode(element.getChildText("countryCode"));
        String string3 = element.getChildText("elevation");
        if (string3 != null && !"".equals(string3)) {
            weatherObservation.setElevation(Integer.parseInt(string3));
        }
        weatherObservation.setLatitude(Double.parseDouble(element.getChildText("lat")));
        weatherObservation.setLongitude(Double.parseDouble(element.getChildText("lng")));
        String string4 = element.getChildText("temperature");
        if (string4 != null && !"".equals(string4)) {
            weatherObservation.setTemperature(Double.parseDouble(string4));
        }
        if ((string2 = element.getChildText("dewPoint")) != null && !"".equals(string2)) {
            weatherObservation.setDewPoint(Double.parseDouble(string2));
        }
        if ((string = element.getChildText("humidity")) != null && !"".equals(string)) {
            weatherObservation.setHumidity(Double.parseDouble(string));
        }
        weatherObservation.setClouds(element.getChildText("clouds"));
        weatherObservation.setWeatherCondition(element.getChildText("weatherCondition"));
        weatherObservation.setWindSpeed(element.getChildText("windSpeed"));
        return weatherObservation;
    }

    public static List<PostalCode> postalCodeSearch(String string, String string2, String string3) throws Exception {
        PostalCodeSearchCriteria postalCodeSearchCriteria = new PostalCodeSearchCriteria();
        postalCodeSearchCriteria.setPostalCode(string);
        postalCodeSearchCriteria.setPlaceName(string2);
        postalCodeSearchCriteria.setCountryCode(string3);
        return WebService.postalCodeSearch(postalCodeSearchCriteria);
    }

    public static List<PostalCode> postalCodeSearch(PostalCodeSearchCriteria postalCodeSearchCriteria) throws Exception {
        ArrayList<PostalCode> arrayList = new ArrayList<PostalCode>();
        String string = "/postalCodeSearch?";
        if (postalCodeSearchCriteria.getPostalCode() != null) {
            string = string + "postalcode=" + URLEncoder.encode(postalCodeSearchCriteria.getPostalCode(), "UTF8");
        }
        if (postalCodeSearchCriteria.getPlaceName() != null) {
            if (!string.endsWith("&")) {
                string = string + "&";
            }
            string = string + "placename=" + URLEncoder.encode(postalCodeSearchCriteria.getPlaceName(), "UTF8");
        }
        if (postalCodeSearchCriteria.getAdminCode1() != null) {
            string = string + "&adminCode1=" + URLEncoder.encode(postalCodeSearchCriteria.getAdminCode1(), "UTF8");
        }
        if (postalCodeSearchCriteria.getCountryCode() != null) {
            if (!string.endsWith("&")) {
                string = string + "&";
            }
            string = string + "country=" + postalCodeSearchCriteria.getCountryCode();
        }
        if (postalCodeSearchCriteria.getCountryBias() != null) {
            if (!string.endsWith("&")) {
                string = string + "&";
            }
            string = string + "countryBias=" + postalCodeSearchCriteria.getCountryBias();
        }
        if (postalCodeSearchCriteria.getMaxRows() > 0) {
            string = string + "&maxRows=" + postalCodeSearchCriteria.getMaxRows();
        }
        if (postalCodeSearchCriteria.getStartRow() > 0) {
            string = string + "&startRow=" + postalCodeSearchCriteria.getStartRow();
        }
        if (postalCodeSearchCriteria.isOROperator()) {
            string = string + "&operator=OR";
        }
        if (postalCodeSearchCriteria.isReduced() != null) {
            string = string + "&isReduced=" + postalCodeSearchCriteria.isReduced().toString();
        }
        if (postalCodeSearchCriteria.getBoundingBox() != null) {
            string = string + "&east=" + postalCodeSearchCriteria.getBoundingBox().getEast();
            string = string + "&west=" + postalCodeSearchCriteria.getBoundingBox().getWest();
            string = string + "&north=" + postalCodeSearchCriteria.getBoundingBox().getNorth();
            string = string + "&south=" + postalCodeSearchCriteria.getBoundingBox().getSouth();
        }
        string = WebService.addUserName(string);
        Element element = WebService.connectAndParse(string);
        for (Object e : element.getChildren("code")) {
            Element element2 = (Element)e;
            PostalCode postalCode = WebService.getPostalCodeFromElement(element2);
            arrayList.add(postalCode);
        }
        return arrayList;
    }

    public static List<PostalCode> findNearbyPostalCodes(PostalCodeSearchCriteria postalCodeSearchCriteria) throws Exception {
        ArrayList<PostalCode> arrayList = new ArrayList<PostalCode>();
        String string = "/findNearbyPostalCodes?";
        if (postalCodeSearchCriteria.getPostalCode() != null) {
            string = string + "&postalcode=" + URLEncoder.encode(postalCodeSearchCriteria.getPostalCode(), "UTF8");
        }
        if (postalCodeSearchCriteria.getPlaceName() != null) {
            string = string + "&placename=" + URLEncoder.encode(postalCodeSearchCriteria.getPlaceName(), "UTF8");
        }
        if (postalCodeSearchCriteria.getCountryCode() != null) {
            string = string + "&country=" + postalCodeSearchCriteria.getCountryCode();
        }
        if (postalCodeSearchCriteria.getLatitude() != null) {
            string = string + "&lat=" + postalCodeSearchCriteria.getLatitude();
        }
        if (postalCodeSearchCriteria.getLongitude() != null) {
            string = string + "&lng=" + postalCodeSearchCriteria.getLongitude();
        }
        if (postalCodeSearchCriteria.getStyle() != null) {
            string = string + "&style=" + (Object)((Object)postalCodeSearchCriteria.getStyle());
        }
        if (postalCodeSearchCriteria.getMaxRows() > 0) {
            string = string + "&maxRows=" + postalCodeSearchCriteria.getMaxRows();
        }
        if (postalCodeSearchCriteria.getRadius() > 0.0) {
            string = string + "&radius=" + postalCodeSearchCriteria.getRadius();
        }
        string = WebService.addUserName(string);
        Element element = WebService.connectAndParse(string);
        for (Object e : element.getChildren("code")) {
            Element element2 = (Element)e;
            PostalCode postalCode = WebService.getPostalCodeFromElement(element2);
            if (element2.getChildText("distance") != null) {
                postalCode.setDistance(Double.parseDouble(element2.getChildText("distance")));
            }
            arrayList.add(postalCode);
        }
        return arrayList;
    }

    private static PostalCode getPostalCodeFromElement(Element element) throws ParseException {
        PostalCode postalCode = new PostalCode();
        postalCode.setPostalCode(element.getChildText("postalcode"));
        postalCode.setPlaceName(element.getChildText("name"));
        postalCode.setCountryCode(element.getChildText("countryCode"));
        postalCode.setLatitude(Double.parseDouble(element.getChildText("lat")));
        postalCode.setLongitude(Double.parseDouble(element.getChildText("lng")));
        postalCode.setAdminName1(element.getChildText("adminName1"));
        postalCode.setAdminCode1(element.getChildText("adminCode1"));
        postalCode.setAdminName2(element.getChildText("adminName2"));
        postalCode.setAdminCode2(element.getChildText("adminCode2"));
        postalCode.setAdminName3(element.getChildText("adminName3"));
        postalCode.setAdminCode3(element.getChildText("adminCode3"));
        return postalCode;
    }

    public static List<Toponym> findNearbyPlaceName(double d, double d2) throws IOException, Exception {
        return WebService.findNearbyPlaceName(d, d2, 0.0, 0);
    }

    public static List<Toponym> findNearbyPlaceName(double d, double d2, double d3, int n) throws IOException, Exception {
        ArrayList<Toponym> arrayList = new ArrayList<Toponym>();
        String string = "/findNearbyPlaceName?";
        string = string + "&lat=" + d;
        string = string + "&lng=" + d2;
        if (d3 > 0.0) {
            string = string + "&radius=" + d3;
        }
        if (n > 0) {
            string = string + "&maxRows=" + n;
        }
        string = WebService.addUserName(string);
        string = WebService.addDefaultStyle(string);
        Element element = WebService.connectAndParse(string);
        for (Object e : element.getChildren("geoname")) {
            Element element2 = (Element)e;
            Toponym toponym = WebService.getToponymFromElement(element2);
            arrayList.add(toponym);
        }
        return arrayList;
    }

    public static List<Toponym> findNearby(double d, double d2, FeatureClass featureClass, String[] stringArray) throws IOException, Exception {
        return WebService.findNearby(d, d2, 0.0, featureClass, stringArray, null, 0);
    }

    public static List<Toponym> findNearby(double d, double d2, double d3, FeatureClass featureClass, String[] element, String string, int n) throws IOException, Exception {
        ArrayList<Toponym> arrayList = new ArrayList<Toponym>();
        String string2 = "/findNearby?";
        string2 = string2 + "&lat=" + d;
        string2 = string2 + "&lng=" + d2;
        if (d3 > 0.0) {
            string2 = string2 + "&radius=" + d3;
        }
        if (n > 0) {
            string2 = string2 + "&maxRows=" + n;
        }
        if (string != null) {
            string2 = string2 + "&lang=" + string;
        }
        if (featureClass != null) {
            string2 = string2 + "&featureClass=" + (Object)((Object)featureClass);
        }
        if (element != null && ((String[])element).length > 0) {
            for (Element element2 : element) {
                string2 = string2 + "&featureCode=" + (String)element2;
            }
        }
        string2 = WebService.addUserName(string2);
        string2 = WebService.addDefaultStyle(string2);
        Element element3 = WebService.connectAndParse(string2);
        for (Object e : element3.getChildren("geoname")) {
            Element element2;
            element2 = (Element)e;
            Toponym toponym = WebService.getToponymFromElement(element2);
            arrayList.add(toponym);
        }
        return arrayList;
    }

    public static Toponym get(int n, String string, String string2) throws IOException, Exception {
        String string3 = "/get?";
        string3 = string3 + "geonameId=" + n;
        if (string != null) {
            string3 = string3 + "&lang=" + string;
        }
        string3 = string2 != null ? string3 + "&style=" + string2 : WebService.addDefaultStyle(string3);
        string3 = WebService.addUserName(string3);
        Element element = WebService.connectAndParse(string3);
        Toponym toponym = WebService.getToponymFromElement(element);
        return toponym;
    }

    public static Address findNearestAddress(double d, double d2) throws IOException, Exception {
        String string = "/findNearestAddress?";
        string = string + "&lat=" + d;
        string = string + "&lng=" + d2;
        Element element = WebService.connectAndParse(string = WebService.addUserName(string));
        Iterator iterator = element.getChildren("address").iterator();
        if (iterator.hasNext()) {
            Object e = iterator.next();
            Element element2 = (Element)e;
            Address address = new Address();
            address.setStreet(element2.getChildText("street"));
            address.setStreetNumber(element2.getChildText("streetNumber"));
            address.setMtfcc(element2.getChildText("mtfcc"));
            address.setPostalCode(element2.getChildText("postalcode"));
            address.setPlaceName(element2.getChildText("placename"));
            address.setCountryCode(element2.getChildText("countryCode"));
            address.setLatitude(Double.parseDouble(element2.getChildText("lat")));
            address.setLongitude(Double.parseDouble(element2.getChildText("lng")));
            address.setAdminName1(element2.getChildText("adminName1"));
            address.setAdminCode1(element2.getChildText("adminCode1"));
            address.setAdminName2(element2.getChildText("adminName2"));
            address.setAdminCode2(element2.getChildText("adminCode2"));
            address.setDistance(Double.parseDouble(element2.getChildText("distance")));
            return address;
        }
        return null;
    }

    public static Intersection findNearestIntersection(double d, double d2) throws Exception {
        return WebService.findNearestIntersection(d, d2, 0.0);
    }

    public static Intersection findNearestIntersection(double d, double d2, double d3) throws Exception {
        Element element;
        Iterator iterator;
        String string = "/findNearestIntersection?";
        string = string + "&lat=" + d;
        string = string + "&lng=" + d2;
        if (d3 > 0.0) {
            string = string + "&radius=" + d3;
        }
        if ((iterator = (element = WebService.connectAndParse(string = WebService.addUserName(string))).getChildren("intersection").iterator()).hasNext()) {
            Object e = iterator.next();
            Element element2 = (Element)e;
            Intersection intersection = new Intersection();
            intersection.setStreet1(element2.getChildText("street1"));
            intersection.setStreet2(element2.getChildText("street2"));
            intersection.setLatitude(Double.parseDouble(element2.getChildText("lat")));
            intersection.setLongitude(Double.parseDouble(element2.getChildText("lng")));
            intersection.setDistance(Double.parseDouble(element2.getChildText("distance")));
            intersection.setPostalCode(element2.getChildText("postalcode"));
            intersection.setPlaceName(element2.getChildText("placename"));
            intersection.setCountryCode(element2.getChildText("countryCode"));
            intersection.setAdminName2(element2.getChildText("adminName2"));
            intersection.setAdminCode1(element2.getChildText("adminCode1"));
            intersection.setAdminName1(element2.getChildText("adminName1"));
            return intersection;
        }
        return null;
    }

    public static List<StreetSegment> findNearbyStreets(double d, double d2, double d3) throws Exception {
        String string = "/findNearbyStreets?";
        string = string + "&lat=" + d;
        string = string + "&lng=" + d2;
        if (d3 > 0.0) {
            string = string + "&radius=" + d3;
        }
        string = WebService.addUserName(string);
        ArrayList<StreetSegment> arrayList = new ArrayList<StreetSegment>();
        Element element = WebService.connectAndParse(string);
        for (Object e : element.getChildren("streetSegment")) {
            Element element2 = (Element)e;
            StreetSegment streetSegment = new StreetSegment();
            String string2 = element2.getChildText("line");
            String[] stringArray = string2.split(",");
            double[] dArray = new double[stringArray.length];
            double[] dArray2 = new double[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                String[] stringArray2 = stringArray[i].split(" ");
                dArray2[i] = Double.parseDouble(stringArray2[0]);
                dArray[i] = Double.parseDouble(stringArray2[1]);
            }
            streetSegment.setCfcc(element2.getChildText("cfcc"));
            streetSegment.setName(element2.getChildText("name"));
            streetSegment.setFraddl(element2.getChildText("fraddl"));
            streetSegment.setFraddr(element2.getChildText("fraddr"));
            streetSegment.setToaddl(element2.getChildText("toaddl"));
            streetSegment.setToaddr(element2.getChildText("toaddr"));
            streetSegment.setPostalCode(element2.getChildText("postalcode"));
            streetSegment.setPlaceName(element2.getChildText("placename"));
            streetSegment.setCountryCode(element2.getChildText("countryCode"));
            streetSegment.setAdminName2(element2.getChildText("adminName2"));
            streetSegment.setAdminCode1(element2.getChildText("adminCode1"));
            streetSegment.setAdminName1(element2.getChildText("adminName1"));
            arrayList.add(streetSegment);
        }
        return arrayList;
    }

    public static List<StreetSegment> findNearbyStreetsOSM(double d, double d2, double d3) throws Exception {
        String string = "/findNearbyStreetsOSM?";
        string = string + "&lat=" + d;
        string = string + "&lng=" + d2;
        if (d3 > 0.0) {
            string = string + "&radius=" + d3;
        }
        string = WebService.addUserName(string);
        ArrayList<StreetSegment> arrayList = new ArrayList<StreetSegment>();
        Element element = WebService.connectAndParse(string);
        for (Object e : element.getChildren("streetSegment")) {
            Element element2 = (Element)e;
            StreetSegment streetSegment = new StreetSegment();
            String string2 = element2.getChildText("line");
            String[] stringArray = string2.split(",");
            double[] dArray = new double[stringArray.length];
            double[] dArray2 = new double[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                String[] stringArray2 = stringArray[i].split(" ");
                dArray2[i] = Double.parseDouble(stringArray2[0]);
                dArray[i] = Double.parseDouble(stringArray2[1]);
            }
            streetSegment.setName(element2.getChildText("name"));
            arrayList.add(streetSegment);
        }
        return arrayList;
    }

    public static ToponymSearchResult search(String string, String string2, String string3, String[] stringArray, int n) throws Exception {
        return WebService.search(string, string2, string3, stringArray, n, null, null, null);
    }

    public static ToponymSearchResult search(String string, String string2, String string3, String[] stringArray, int n, String string4, Style style, String string5) throws Exception {
        ToponymSearchCriteria toponymSearchCriteria = new ToponymSearchCriteria();
        toponymSearchCriteria.setQ(string);
        toponymSearchCriteria.setCountryCode(string2);
        toponymSearchCriteria.setName(string3);
        toponymSearchCriteria.setFeatureCodes(stringArray);
        toponymSearchCriteria.setStartRow(n);
        toponymSearchCriteria.setLanguage(string4);
        toponymSearchCriteria.setStyle(style);
        toponymSearchCriteria.setNameEquals(string5);
        return WebService.search(toponymSearchCriteria);
    }

    public static ToponymSearchResult search(ToponymSearchCriteria toponymSearchCriteria) throws Exception {
        ToponymSearchResult toponymSearchResult = new ToponymSearchResult();
        String string = "/search?";
        if (toponymSearchCriteria.getQ() != null) {
            string = string + "q=" + URLEncoder.encode(toponymSearchCriteria.getQ(), "UTF8");
        }
        if (toponymSearchCriteria.getNameEquals() != null) {
            string = string + "&name_equals=" + URLEncoder.encode(toponymSearchCriteria.getNameEquals(), "UTF8");
        }
        if (toponymSearchCriteria.getNameStartsWith() != null) {
            string = string + "&name_startsWith=" + URLEncoder.encode(toponymSearchCriteria.getNameStartsWith(), "UTF8");
        }
        if (toponymSearchCriteria.getName() != null) {
            string = string + "&name=" + URLEncoder.encode(toponymSearchCriteria.getName(), "UTF8");
        }
        if (toponymSearchCriteria.getTag() != null) {
            string = string + "&tag=" + URLEncoder.encode(toponymSearchCriteria.getTag(), "UTF8");
        }
        if (toponymSearchCriteria.getCountryCode() != null) {
            string = string + "&country=" + toponymSearchCriteria.getCountryCode();
        }
        if (toponymSearchCriteria.getCountryCodes() != null) {
            for (String string2 : toponymSearchCriteria.getCountryCodes()) {
                string = string + "&country=" + string2;
            }
        }
        if (toponymSearchCriteria.getCountryBias() != null) {
            if (!string.endsWith("&")) {
                string = string + "&";
            }
            string = string + "countryBias=" + toponymSearchCriteria.getCountryBias();
        }
        if (toponymSearchCriteria.getContinentCode() != null) {
            string = string + "&continentCode=" + toponymSearchCriteria.getContinentCode();
        }
        if (toponymSearchCriteria.getAdminCode1() != null) {
            string = string + "&adminCode1=" + URLEncoder.encode(toponymSearchCriteria.getAdminCode1(), "UTF8");
        }
        if (toponymSearchCriteria.getAdminCode2() != null) {
            string = string + "&adminCode2=" + URLEncoder.encode(toponymSearchCriteria.getAdminCode2(), "UTF8");
        }
        if (toponymSearchCriteria.getAdminCode3() != null) {
            string = string + "&adminCode3=" + URLEncoder.encode(toponymSearchCriteria.getAdminCode3(), "UTF8");
        }
        if (toponymSearchCriteria.getAdminCode4() != null) {
            string = string + "&adminCode4=" + URLEncoder.encode(toponymSearchCriteria.getAdminCode4(), "UTF8");
        }
        if (toponymSearchCriteria.getLanguage() != null) {
            string = string + "&lang=" + toponymSearchCriteria.getLanguage();
        }
        if (toponymSearchCriteria.getFeatureClass() != null) {
            string = string + "&featureClass=" + (Object)((Object)toponymSearchCriteria.getFeatureClass());
        }
        if (toponymSearchCriteria.getFeatureCodes() != null) {
            for (String string3 : toponymSearchCriteria.getFeatureCodes()) {
                string = string + "&fcode=" + string3;
            }
        }
        if (toponymSearchCriteria.getMaxRows() > 0) {
            string = string + "&maxRows=" + toponymSearchCriteria.getMaxRows();
        }
        if (toponymSearchCriteria.getStartRow() > 0) {
            string = string + "&startRow=" + toponymSearchCriteria.getStartRow();
        }
        if (toponymSearchCriteria.getBoundingBox() != null) {
            string = string + "&east=" + toponymSearchCriteria.getBoundingBox().getEast();
            string = string + "&west=" + toponymSearchCriteria.getBoundingBox().getWest();
            string = string + "&north=" + toponymSearchCriteria.getBoundingBox().getNorth();
            string = string + "&south=" + toponymSearchCriteria.getBoundingBox().getSouth();
        }
        string = toponymSearchCriteria.getStyle() != null ? string + "&style=" + (Object)((Object)toponymSearchCriteria.getStyle()) : WebService.addDefaultStyle(string);
        string = WebService.addUserName(string);
        Element element = WebService.connectAndParse(string);
        toponymSearchResult.totalResultsCount = Integer.parseInt(element.getChildText("totalResultsCount"));
        toponymSearchResult.setStyle(Style.valueOf(element.getAttributeValue("style")));
        for (Object e : element.getChildren("geoname")) {
            String string3;
            string3 = (Element)e;
            Toponym toponym = WebService.getToponymFromElement((Element)string3);
            toponym.setStyle(toponymSearchResult.getStyle());
            toponymSearchResult.toponyms.add(toponym);
        }
        return toponymSearchResult;
    }

    public static ToponymSearchResult children(int n, String string, Style style) throws Exception {
        ToponymSearchResult toponymSearchResult = new ToponymSearchResult();
        String string2 = "/children?";
        string2 = string2 + "geonameId=" + n;
        if (string != null) {
            string2 = string2 + "&lang=" + string;
        }
        string2 = style != null ? string2 + "&style=" + (Object)((Object)style) : WebService.addDefaultStyle(string2);
        string2 = WebService.addUserName(string2);
        Element element = WebService.connectAndParse(string2);
        toponymSearchResult.totalResultsCount = Integer.parseInt(element.getChildText("totalResultsCount"));
        toponymSearchResult.setStyle(Style.valueOf(element.getAttributeValue("style")));
        for (Object e : element.getChildren("geoname")) {
            Element element2 = (Element)e;
            Toponym toponym = WebService.getToponymFromElement(element2);
            toponymSearchResult.toponyms.add(toponym);
        }
        return toponymSearchResult;
    }

    public static ToponymSearchResult neighbours(int n, String string, Style style) throws Exception {
        ToponymSearchResult toponymSearchResult = new ToponymSearchResult();
        String string2 = "/neighbours?";
        string2 = string2 + "geonameId=" + n;
        if (string != null) {
            string2 = string2 + "&lang=" + string;
        }
        string2 = style != null ? string2 + "&style=" + (Object)((Object)style) : WebService.addDefaultStyle(string2);
        string2 = WebService.addUserName(string2);
        Element element = WebService.connectAndParse(string2);
        toponymSearchResult.totalResultsCount = Integer.parseInt(element.getChildText("totalResultsCount"));
        toponymSearchResult.setStyle(Style.valueOf(element.getAttributeValue("style")));
        for (Object e : element.getChildren("geoname")) {
            Element element2 = (Element)e;
            Toponym toponym = WebService.getToponymFromElement(element2);
            toponymSearchResult.toponyms.add(toponym);
        }
        return toponymSearchResult;
    }

    public static List<Toponym> hierarchy(int n, String string, Style style) throws Exception {
        String string2 = "/hierarchy?";
        string2 = string2 + "geonameId=" + n;
        if (string != null) {
            string2 = string2 + "&lang=" + string;
        }
        string2 = style != null ? string2 + "&style=" + (Object)((Object)style) : WebService.addDefaultStyle(string2);
        string2 = WebService.addUserName(string2);
        Element element = WebService.connectAndParse(string2);
        ArrayList<Toponym> arrayList = new ArrayList<Toponym>();
        for (Object e : element.getChildren("geoname")) {
            Element element2 = (Element)e;
            Toponym toponym = WebService.getToponymFromElement(element2);
            arrayList.add(toponym);
        }
        return arrayList;
    }

    public static void saveTags(String[] element, Toponym toponym, String string, String string2) throws Exception {
        if (toponym.getGeoNameId() == 0) {
            throw new Error("no geonameid specified");
        }
        String string3 = "/servlet/geonames?srv=61";
        string3 = string3 + "&geonameId=" + toponym.getGeoNameId();
        string3 = WebService.addUserName(string3);
        StringBuilder stringBuilder = new StringBuilder();
        for (String string4 : element) {
            stringBuilder.append(string4 + ",");
        }
        string3 = string3 + "&tag=" + stringBuilder;
        Element element2 = WebService.connectAndParse(string3);
    }

    public static List<WikipediaArticle> wikipediaSearch(String string, String string2) throws Exception {
        ArrayList<WikipediaArticle> arrayList = new ArrayList<WikipediaArticle>();
        String string3 = "/wikipediaSearch?";
        string3 = string3 + "q=" + URLEncoder.encode(string, "UTF8");
        if (string2 != null) {
            string3 = string3 + "&lang=" + string2;
        }
        string3 = WebService.addUserName(string3);
        Element element = WebService.connectAndParse(string3);
        for (Object e : element.getChildren("entry")) {
            Element element2 = (Element)e;
            WikipediaArticle wikipediaArticle = WebService.getWikipediaArticleFromElement(element2);
            arrayList.add(wikipediaArticle);
        }
        return arrayList;
    }

    public static List<WikipediaArticle> wikipediaSearchForTitle(String string, String string2) throws Exception {
        ArrayList<WikipediaArticle> arrayList = new ArrayList<WikipediaArticle>();
        String string3 = "/wikipediaSearch?";
        string3 = string3 + "title=" + URLEncoder.encode(string, "UTF8");
        if (string2 != null) {
            string3 = string3 + "&lang=" + string2;
        }
        string3 = WebService.addUserName(string3);
        Element element = WebService.connectAndParse(string3);
        for (Object e : element.getChildren("entry")) {
            Element element2 = (Element)e;
            WikipediaArticle wikipediaArticle = WebService.getWikipediaArticleFromElement(element2);
            arrayList.add(wikipediaArticle);
        }
        return arrayList;
    }

    public static List<WikipediaArticle> findNearbyWikipedia(double d, double d2, String string) throws Exception {
        return WebService.findNearbyWikipedia(d, d2, 0.0, string, 0);
    }

    public static List<WikipediaArticle> findNearbyWikipedia(double d, double d2, double d3, String string, int n) throws Exception {
        ArrayList<WikipediaArticle> arrayList = new ArrayList<WikipediaArticle>();
        String string2 = "/findNearbyWikipedia?";
        string2 = string2 + "lat=" + d;
        string2 = string2 + "&lng=" + d2;
        if (d3 > 0.0) {
            string2 = string2 + "&radius=" + d3;
        }
        if (n > 0) {
            string2 = string2 + "&maxRows=" + n;
        }
        if (string != null) {
            string2 = string2 + "&lang=" + string;
        }
        string2 = WebService.addUserName(string2);
        Element element = WebService.connectAndParse(string2);
        for (Object e : element.getChildren("entry")) {
            Element element2 = (Element)e;
            WikipediaArticle wikipediaArticle = WebService.getWikipediaArticleFromElement(element2);
            arrayList.add(wikipediaArticle);
        }
        return arrayList;
    }

    public static int gtopo30(double d, double d2) throws IOException {
        String string = "/gtopo30?lat=" + d + "&lng=" + d2;
        string = WebService.addUserName(string);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(WebService.connect(string)));
        String string2 = bufferedReader.readLine();
        bufferedReader.close();
        return Integer.parseInt(string2);
    }

    public static int srtm3(double d, double d2) throws IOException {
        String string = "/srtm3?lat=" + d + "&lng=" + d2;
        string = WebService.addUserName(string);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(WebService.connect(string)));
        String string2 = bufferedReader.readLine();
        bufferedReader.close();
        return Integer.parseInt(string2);
    }

    public static int[] srtm3(double[] dArray, double[] dArray2) throws IOException {
        if (dArray.length != dArray2.length) {
            throw new Error("number of lats and longs must be equal");
        }
        int[] nArray = new int[dArray.length];
        String string = "";
        String string2 = "";
        for (int i = 0; i < nArray.length; ++i) {
            string = string + dArray[i] + ",";
            string2 = string2 + dArray2[i] + ",";
        }
        String string3 = "/srtm3?lats=" + string + "&lngs=" + string2;
        string3 = WebService.addUserName(string3);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(WebService.connect(string3)));
        for (int i = 0; i < nArray.length; ++i) {
            String string4 = bufferedReader.readLine();
            nArray[i] = Integer.parseInt(string4);
        }
        bufferedReader.close();
        return nArray;
    }

    public static int astergdem(double d, double d2) throws IOException {
        String string = "/astergdem?lat=" + d + "&lng=" + d2;
        string = WebService.addUserName(string);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(WebService.connect(string)));
        String string2 = bufferedReader.readLine();
        bufferedReader.close();
        return Integer.parseInt(string2);
    }

    public static int[] astergdem(double[] dArray, double[] dArray2) throws IOException {
        if (dArray.length != dArray2.length) {
            throw new Error("number of lats and longs must be equal");
        }
        int[] nArray = new int[dArray.length];
        String string = "";
        String string2 = "";
        for (int i = 0; i < nArray.length; ++i) {
            string = string + dArray[i] + ",";
            string2 = string2 + dArray2[i] + ",";
        }
        String string3 = "/astergdem?lats=" + string + "&lngs=" + string2;
        string3 = WebService.addUserName(string3);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(WebService.connect(string3)));
        for (int i = 0; i < nArray.length; ++i) {
            String string4 = bufferedReader.readLine();
            nArray[i] = Integer.parseInt(string4);
        }
        bufferedReader.close();
        return nArray;
    }

    public static String countryCode(double d, double d2) throws IOException {
        return WebService.countryCode(d, d2, 0.0);
    }

    public static String countryCode(double d, double d2, double d3) throws IOException {
        String string = "/countryCode?lat=" + d + "&lng=" + d2;
        if (d3 != 0.0) {
            string = string + "&radius=" + d3;
        }
        string = WebService.addUserName(string);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(WebService.connect(string)));
        String string2 = bufferedReader.readLine();
        bufferedReader.close();
        if (string2 != null && string2.length() == 2) {
            return string2;
        }
        return null;
    }

    public static Timezone timezone(double d, double d2) throws IOException, Exception {
        Element element;
        Iterator iterator;
        String string = "/timezone?";
        double d3 = 0.0;
        string = string + "&lat=" + d;
        string = string + "&lng=" + d2;
        if (d3 > 0.0) {
            string = string + "&radius=" + d3;
        }
        if ((iterator = (element = WebService.connectAndParse(string = WebService.addUserName(string))).getChildren("timezone").iterator()).hasNext()) {
            Object e = iterator.next();
            Element element2 = (Element)e;
            Timezone timezone = new Timezone();
            timezone.setTimezoneId(element2.getChildText("timezoneId"));
            timezone.setCountryCode(element2.getChildText("countryCode"));
            if (element2.getChildText("time") != null) {
                String string2 = "yyyy-MM-dd HH:mm";
                SimpleDateFormat simpleDateFormat = null;
                simpleDateFormat = element2.getChildText("time").length() == string2.length() ? new SimpleDateFormat(string2) : new SimpleDateFormat(DATEFMT);
                timezone.setTime(simpleDateFormat.parse(element2.getChildText("time")));
                if (element2.getChildText("sunrise") != null) {
                    timezone.setSunrise(simpleDateFormat.parse(element2.getChildText("sunrise")));
                }
                if (element2.getChildText("sunset") != null) {
                    timezone.setSunset(simpleDateFormat.parse(element2.getChildText("sunset")));
                }
                timezone.setGmtOffset(Double.parseDouble(element2.getChildText("gmtOffset")));
                timezone.setDstOffset(Double.parseDouble(element2.getChildText("dstOffset")));
            }
            return timezone;
        }
        return null;
    }

    public static WeatherObservation findNearByWeather(double d, double d2) throws IOException, Exception {
        String string = "/findNearByWeatherXML?";
        string = string + "&lat=" + d;
        string = string + "&lng=" + d2;
        Element element = WebService.connectAndParse(string = WebService.addUserName(string));
        Iterator iterator = element.getChildren("observation").iterator();
        if (iterator.hasNext()) {
            Object e = iterator.next();
            Element element2 = (Element)e;
            WeatherObservation weatherObservation = WebService.getWeatherObservationFromElement(element2);
            return weatherObservation;
        }
        return null;
    }

    public static WeatherObservation weatherIcao(String string) throws IOException, Exception {
        String string2 = "/weatherIcaoXML?";
        string2 = string2 + "&ICAO=" + string;
        Element element = WebService.connectAndParse(string2 = WebService.addUserName(string2));
        Iterator iterator = element.getChildren("observation").iterator();
        if (iterator.hasNext()) {
            Object e = iterator.next();
            Element element2 = (Element)e;
            WeatherObservation weatherObservation = WebService.getWeatherObservationFromElement(element2);
            return weatherObservation;
        }
        return null;
    }

    public static String getGeoNamesServer() {
        return geoNamesServer;
    }

    public static String getGeoNamesServerFailover() {
        return geoNamesServerFailover;
    }

    public static void setGeoNamesServer(String string) {
        if (string == null) {
            throw new Error();
        }
        if (!(string = string.trim().toLowerCase()).startsWith("http://") && !string.startsWith("https://")) {
            string = "http://" + string;
        }
        geoNamesServer = string;
    }

    public static void setGeoNamesServerFailover(String string) {
        if (string != null && !(string = string.trim().toLowerCase()).startsWith("http://") && !string.startsWith("https://")) {
            string = "http://" + string;
        }
        geoNamesServerFailover = string;
    }

    public static Proxy getProxy() {
        return proxy;
    }

    public static void setProxy(Proxy proxy) {
        WebService.proxy = proxy;
    }

    public static String getUserName() {
        return userName;
    }

    public static void setUserName(String string) {
        userName = string;
    }

    public static String getToken() {
        return token;
    }

    public static void setToken(String string) {
        token = string;
    }

    public static Style getDefaultStyle() {
        return defaultStyle;
    }

    public static void setDefaultStyle(Style style) {
        defaultStyle = style;
    }

    public static int getReadTimeOut() {
        return readTimeOut;
    }

    public static void setReadTimeOut(int n) {
        readTimeOut = n;
    }

    public static int getConnectTimeOut() {
        return connectTimeOut;
    }

    public static void setConnectTimeOut(int n) {
        connectTimeOut = n;
    }

    static {
        String string;
        logger = Logger.getLogger("org.geonames");
        USER_AGENT = "gnwsc/1.1.11";
        isAndroid = false;
        geoNamesServer = "http://api.geonames.org";
        geoNamesServerFailover = "http://api.geonames.org";
        averageSampleSize = 20L;
        defaultStyle = Style.MEDIUM;
        readTimeOut = 120000;
        connectTimeOut = 10000;
        DATEFMT = "yyyy-MM-dd HH:mm:ss";
        USER_AGENT = USER_AGENT + " (";
        String string2 = System.getProperty("os.name");
        if (string2 != null) {
            USER_AGENT = USER_AGENT + string2 + ",";
        }
        if ((string = System.getProperty("os.version")) != null) {
            USER_AGENT = USER_AGENT + string;
        }
        USER_AGENT = USER_AGENT + ")";
        try {
            Class<?> clazz = Class.forName("android.os.Build");
            if (clazz != null) {
                isAndroid = true;
                Field[] fieldArray = clazz.getFields();
                if (fieldArray != null) {
                    for (Field field : fieldArray) {
                        if (!"MODEL".equalsIgnoreCase(field.getName())) continue;
                        USER_AGENT = USER_AGENT + "(" + field.get(clazz) + ", ";
                    }
                }
                if ((clazz = Class.forName("android.os.Build$VERSION")) != null && (fieldArray = clazz.getFields()) != null) {
                    for (Field field : fieldArray) {
                        if (!"RELEASE".equalsIgnoreCase(field.getName())) continue;
                        USER_AGENT = USER_AGENT + field.get(clazz);
                    }
                }
                USER_AGENT = USER_AGENT + ")";
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        utc = TimeZone.getTimeZone("UTC");
    }
}

