/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.aries.models;

import ancestris.modules.editors.aries.utilities.PropertyTag2Name;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyPlace;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.openide.util.NbBundle;

public class SourceRecordedEventsTableModel
extends AbstractTableModel {
    List<Property> mEventTypesList = new ArrayList<Property>();
    String[] columnsName = new String[]{NbBundle.getMessage(SourceRecordedEventsTableModel.class, (String)"EventsTableModel.column.ID.eventType"), NbBundle.getMessage(SourceRecordedEventsTableModel.class, (String)"EventsTableModel.column.ID.date"), NbBundle.getMessage(SourceRecordedEventsTableModel.class, (String)"EventsTableModel.column.ID.place")};

    @Override
    public int getRowCount() {
        return this.mEventTypesList.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnsName.length;
    }

    @Override
    public Class<?> getColumnClass(int column) {
        return switch (column) {
            case 0 -> String.class;
            case 1 -> PropertyDate.class;
            case 2 -> String.class;
            default -> String.class;
        };
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (row < this.mEventTypesList.size()) {
            Property eventType = this.mEventTypesList.get(row);
            switch (column) {
                case 0: {
                    Object result = "";
                    for (String tag : eventType.getValue().replaceAll(" ", "").split(",")) {
                        result = ((String)result).isEmpty() ? (String)result + PropertyTag2Name.getTagName(tag) : (String)result + ", " + PropertyTag2Name.getTagName(tag);
                    }
                    return result;
                }
                case 1: {
                    return (PropertyDate)eventType.getProperty("DATE");
                }
                case 2: {
                    PropertyPlace place = (PropertyPlace)eventType.getProperty("PLAC");
                    if (place != null) {
                        return place.format("all");
                    }
                    return "";
                }
            }
            return "";
        }
        return "";
    }

    @Override
    public String getColumnName(int col) {
        return this.columnsName[col];
    }

    public String[] getColumnsName() {
        return this.columnsName;
    }

    public void addAll(List<Property> eventTypesList) {
        this.mEventTypesList.addAll(eventTypesList);
        this.fireTableDataChanged();
    }

    public void add(Property eventType) {
        this.mEventTypesList.add(eventType);
        this.fireTableDataChanged();
    }

    public Property getValueAt(int row) {
        return this.mEventTypesList.get(row);
    }

    public String getDisplayValueAt(int row) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.columnsName.length; ++i) {
            Object value = this.getValueAt(row, i);
            if (value == null) continue;
            result.append(value);
            result.append(' ');
        }
        return result.toString();
    }

    public Property remove(int row) {
        Property event = this.mEventTypesList.remove(row);
        this.fireTableDataChanged();
        return event;
    }

    public void clear() {
        this.mEventTypesList.clear();
    }
}

