/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.aries.models;

import ancestris.modules.editors.aries.models.SexComboBoxModel;
import genj.gedcom.Indi;
import genj.gedcom.PropertyDate;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.openide.util.NbBundle;

public class IndividualsTableModel
extends AbstractTableModel {
    private final List<Indi> individualsList = new ArrayList<Indi>();
    private final String[] columnsName = new String[]{NbBundle.getMessage(IndividualsTableModel.class, (String)"IndividualsTableModel.column.ID.title"), NbBundle.getMessage(IndividualsTableModel.class, (String)"IndividualsTableModel.column.Name.title"), NbBundle.getMessage(IndividualsTableModel.class, (String)"IndividualsTableModel.column.Sex.title"), NbBundle.getMessage(IndividualsTableModel.class, (String)"IndividualsTableModel.column.BirthDate.title"), NbBundle.getMessage(IndividualsTableModel.class, (String)"IndividualsTableModel.column.DeathDate.title")};
    private final String[] sex = new String[]{NbBundle.getMessage(SexComboBoxModel.class, (String)"SexComboBoxModel.SexType.UNKNOWN"), NbBundle.getMessage(SexComboBoxModel.class, (String)"SexComboBoxModel.SexType.MALE"), NbBundle.getMessage(SexComboBoxModel.class, (String)"SexComboBoxModel.SexType.FEMALE")};

    @Override
    public int getRowCount() {
        return this.individualsList.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnsName.length;
    }

    @Override
    public Class<?> getColumnClass(int column) {
        return switch (column) {
            case 0 -> String.class;
            case 1 -> String.class;
            case 2 -> String.class;
            case 3 -> PropertyDate.class;
            case 4 -> PropertyDate.class;
            default -> String.class;
        };
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (row < this.individualsList.size()) {
            Indi individual = this.individualsList.get(row);
            return switch (column) {
                case 0 -> individual.getId();
                case 1 -> individual.getName();
                case 2 -> this.sex[individual.getSex()];
                case 3 -> individual.getBirthDate();
                case 4 -> individual.getDeathDate();
                default -> "";
            };
        }
        return "";
    }

    @Override
    public String getColumnName(int col) {
        return this.columnsName[col];
    }

    public String[] getColumnsName() {
        return this.columnsName;
    }

    public void add(Indi individual) {
        this.individualsList.add(individual);
        this.fireTableDataChanged();
    }

    public void addAll(List<Indi> individualsList) {
        this.individualsList.addAll(individualsList);
        this.fireTableDataChanged();
    }

    public void clear(List<Indi> individualsList) {
        this.individualsList.clear();
    }

    public Indi getValueAt(int row) {
        return this.individualsList.get(row);
    }
}

