/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.aries.beans;

import ancestris.util.swing.FileChooserBuilder;
import genj.io.InputSource;
import genj.io.input.URLInput;
import genj.renderer.MediaRenderer;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import org.openide.util.NbBundle;

public class ImageBean
extends JPanel {
    private static final Logger LOG = Logger.getLogger("ancestris.app");
    public static BufferedImage IMG_INVALID_PHOTO = null;
    public static BufferedImage IMG_VIDEO = null;
    public static BufferedImage IMG_SOUND = null;
    public static BufferedImage IMG_PDF = null;
    public static BufferedImage IMG_WEB_LINK = null;
    private String[] genders = new String[]{"unknown", "male", "female"};
    private boolean isDefault = true;
    private Image loadImage = null;
    private Image scaledImage = null;

    public ImageBean() {
        try {
            this.loadImage = ImageIO.read(ImageBean.class.getResourceAsStream("/ancestris/modules/editors/aries/resources/profile_" + this.genders[0] + ".png"));
            this.isDefault = true;
        }
        catch (IOException ex) {
            LOG.log(Level.INFO, "Unable to load default image.", ex);
        }
        this.initComponents();
    }

    private void initComponents() {
        this.setBorder(null);
        this.setToolTipText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/aries/beans/Bundle").getString("ImageBean.toolTipText"), new Object[0]));
        this.setMinimumSize(new Dimension(150, 200));
        this.setName(NbBundle.getMessage(ImageBean.class, (String)"ImageBean.name"));
        this.setPreferredSize(new Dimension(150, 200));
        this.setRequestFocusEnabled(false);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                ImageBean.this.formComponentResized(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 150, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 200, Short.MAX_VALUE));
    }

    private void formComponentResized(ComponentEvent evt) {
        if (this.loadImage != null) {
            this.scaledImage = this.getWidth() < this.getHeight() ? this.loadImage.getScaledInstance(this.getWidth(), -1, 1) : this.loadImage.getScaledInstance(-1, this.getHeight(), 1);
            this.repaint();
        }
    }

    public boolean setImage(InputSource is, int defaultGender) {
        boolean ret;
        block11: {
            ret = true;
            Optional obi = MediaRenderer.getImage((InputSource)is);
            if (obi.isPresent()) {
                this.loadImage = (Image)obi.get();
                try {
                    if (this.loadImage == null) {
                        this.loadImage = ImageIO.read(ImageBean.class.getResourceAsStream("/ancestris/modules/editors/aries/resources/invalid_photo.png"));
                        this.isDefault = true;
                        ret = false;
                        break block11;
                    }
                    if (this.getWidth() > 0 && this.getWidth() < this.getHeight()) {
                        this.scaledImage = this.loadImage.getScaledInstance(this.getWidth(), -1, 1);
                    } else if (this.getHeight() > 0) {
                        this.scaledImage = this.loadImage.getScaledInstance(-1, this.getHeight(), 1);
                    }
                    this.isDefault = false;
                }
                catch (IOException ex) {
                    LOG.log(Level.INFO, "Unable to load default image.", ex);
                    ret = false;
                }
            } else {
                this.loadImage = is == null ? this.getImageFromType(null, false, defaultGender) : this.getImageFromType(is.getExtension(), is instanceof URLInput, defaultGender);
                if (this.getWidth() > 0 && this.getWidth() < this.getHeight()) {
                    this.scaledImage = this.loadImage.getScaledInstance(this.getWidth(), -1, 1);
                } else if (this.getHeight() > 0) {
                    this.scaledImage = this.loadImage.getScaledInstance(-1, this.getHeight(), 1);
                }
                this.isDefault = true;
            }
        }
        this.repaint();
        return ret;
    }

    private Image getImageFromType(String extension, boolean isUrl, int defautGender) {
        BufferedImage retour;
        if (Arrays.asList(FileChooserBuilder.vidExtensions).contains(extension)) {
            retour = IMG_VIDEO;
        } else if (Arrays.asList(FileChooserBuilder.sndExtensions).contains(extension)) {
            retour = IMG_SOUND;
        } else if (Arrays.asList(FileChooserBuilder.pdfExtensions).contains(extension)) {
            retour = IMG_PDF;
        } else if (isUrl) {
            retour = IMG_WEB_LINK;
        } else {
            try {
                retour = ImageIO.read(ImageBean.class.getResourceAsStream("/ancestris/modules/editors/aries/resources/profile_" + this.genders[defautGender] + ".png"));
            }
            catch (IOException e) {
                retour = IMG_INVALID_PHOTO;
            }
        }
        return retour;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.scaledImage != null) {
            ((Graphics2D)g).drawImage(this.scaledImage, 0 + (this.getWidth() - this.scaledImage.getWidth(this)) / 2, (this.getHeight() - this.scaledImage.getHeight(this)) / 2, null);
        }
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    static {
        try {
            IMG_INVALID_PHOTO = ImageIO.read(ImageBean.class.getResourceAsStream("/ancestris/modules/editors/aries/resources/invalid_photo.png"));
            IMG_VIDEO = ImageIO.read(ImageBean.class.getResourceAsStream("/ancestris/modules/editors/aries/resources/video.png"));
            IMG_SOUND = ImageIO.read(ImageBean.class.getResourceAsStream("/ancestris/modules/editors/aries/resources/sound.png"));
            IMG_PDF = ImageIO.read(ImageBean.class.getResourceAsStream("/ancestris/modules/editors/aries/resources/pdf.png"));
            IMG_WEB_LINK = ImageIO.read(ImageBean.class.getResourceAsStream("/ancestris/modules/editors/aries/resources/weblink.png"));
        }
        catch (IOException ex) {
            LOG.log(Level.INFO, "Unable to initialize default images", ex);
        }
    }
}

