/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.stream;

import org.graphstream.stream.AttributePredicate;
import org.graphstream.stream.PipeBase;

public class AttributePipe
extends PipeBase {
    protected AttributePredicate globalPredicate = new FalsePredicate();
    protected AttributePredicate graphPredicate = new FalsePredicate();
    protected AttributePredicate nodePredicate = new FalsePredicate();
    protected AttributePredicate edgePredicate = new FalsePredicate();

    public void setGlobalAttributeFilter(AttributePredicate filter) {
        this.globalPredicate = filter == null ? new FalsePredicate() : filter;
    }

    public void setGraphAttributeFilter(AttributePredicate filter) {
        this.graphPredicate = filter == null ? new FalsePredicate() : filter;
    }

    public void setNodeAttributeFilter(AttributePredicate filter) {
        this.nodePredicate = filter == null ? new FalsePredicate() : filter;
    }

    public void setEdgeAttributeFilter(AttributePredicate filter) {
        this.edgePredicate = filter == null ? new FalsePredicate() : filter;
    }

    public AttributePredicate getGlobalAttributeFilter() {
        return this.globalPredicate;
    }

    public AttributePredicate getGraphAttributeFilter() {
        return this.graphPredicate;
    }

    public AttributePredicate getNodeAttributeFilter() {
        return this.nodePredicate;
    }

    public AttributePredicate getEdgeAttributeFilter() {
        return this.edgePredicate;
    }

    @Override
    public void edgeAttributeAdded(String graphId, long timeId, String edgeId, String attribute, Object value) {
        if (!this.edgePredicate.matches(attribute, value) && !this.globalPredicate.matches(attribute, value)) {
            this.sendEdgeAttributeAdded(graphId, timeId, edgeId, attribute, value);
        }
    }

    @Override
    public void edgeAttributeChanged(String graphId, long timeId, String edgeId, String attribute, Object oldValue, Object newValue) {
        if (!this.edgePredicate.matches(attribute, newValue) && !this.globalPredicate.matches(attribute, newValue)) {
            this.sendEdgeAttributeChanged(graphId, timeId, edgeId, attribute, oldValue, newValue);
        }
    }

    @Override
    public void edgeAttributeRemoved(String graphId, long timeId, String edgeId, String attribute) {
        if (!this.edgePredicate.matches(attribute, null) && !this.globalPredicate.matches(attribute, null)) {
            this.sendEdgeAttributeRemoved(graphId, timeId, edgeId, attribute);
        }
    }

    @Override
    public void graphAttributeAdded(String graphId, long timeId, String attribute, Object value) {
        if (!this.graphPredicate.matches(attribute, value) && !this.globalPredicate.matches(attribute, value)) {
            this.sendGraphAttributeAdded(graphId, timeId, attribute, value);
        }
    }

    @Override
    public void graphAttributeChanged(String graphId, long timeId, String attribute, Object oldValue, Object newValue) {
        if (!this.graphPredicate.matches(attribute, newValue) && !this.globalPredicate.matches(attribute, newValue)) {
            this.sendGraphAttributeChanged(graphId, timeId, attribute, oldValue, newValue);
        }
    }

    @Override
    public void graphAttributeRemoved(String graphId, long timeId, String attribute) {
        if (!this.graphPredicate.matches(attribute, null) && !this.globalPredicate.matches(attribute, null)) {
            this.sendGraphAttributeRemoved(graphId, timeId, attribute);
        }
    }

    @Override
    public void nodeAttributeAdded(String graphId, long timeId, String nodeId, String attribute, Object value) {
        if (!this.nodePredicate.matches(attribute, value) && !this.globalPredicate.matches(attribute, value)) {
            this.sendNodeAttributeAdded(graphId, timeId, nodeId, attribute, value);
        }
    }

    @Override
    public void nodeAttributeChanged(String graphId, long timeId, String nodeId, String attribute, Object oldValue, Object newValue) {
        if (!this.nodePredicate.matches(attribute, newValue) && !this.globalPredicate.matches(attribute, newValue)) {
            this.sendNodeAttributeChanged(graphId, timeId, nodeId, attribute, oldValue, newValue);
        }
    }

    @Override
    public void nodeAttributeRemoved(String graphId, long timeId, String nodeId, String attribute) {
        if (!this.nodePredicate.matches(attribute, null) && !this.globalPredicate.matches(attribute, null)) {
            this.sendNodeAttributeRemoved(graphId, timeId, nodeId, attribute);
        }
    }

    protected class FalsePredicate
    implements AttributePredicate {
        protected FalsePredicate() {
        }

        @Override
        public boolean matches(String attributeName, Object attributeValue) {
            return false;
        }
    }
}

