/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.graph.implementations;

import java.util.HashMap;
import org.graphstream.graph.Edge;
import org.graphstream.graph.Node;
import org.graphstream.graph.implementations.AbstractEdge;
import org.graphstream.graph.implementations.AbstractGraph;
import org.graphstream.graph.implementations.AbstractNode;
import org.graphstream.graph.implementations.AdjacencyListNode;

public class SingleNode
extends AdjacencyListNode {
    protected HashMap<AbstractNode, TwoEdges> neighborMap = new HashMap(4 * INITIAL_EDGE_CAPACITY / 3 + 1);

    protected SingleNode(AbstractGraph graph, String id) {
        super(graph, id);
    }

    @Override
    protected <T extends Edge> T locateEdge(Node opposite, char type) {
        TwoEdges ee = this.neighborMap.get(opposite);
        if (ee == null) {
            return null;
        }
        if (type == '\u0001') {
            return (T)(ee.in == null ? ee.out : ee.in);
        }
        return (T)(type == '\u0000' ? ee.in : ee.out);
    }

    @Override
    protected void removeEdge(int i) {
        AbstractNode opposite = (AbstractNode)this.edges[i].getOpposite(this);
        TwoEdges ee = this.neighborMap.get(opposite);
        char type = this.edgeType(this.edges[i]);
        if (type != '\u0002') {
            ee.in = null;
        }
        if (type != '\u0000') {
            ee.out = null;
        }
        if (ee.in == null && ee.out == null) {
            this.neighborMap.remove(opposite);
        }
        super.removeEdge(i);
    }

    @Override
    protected boolean addEdgeCallback(AbstractEdge edge) {
        char type;
        AbstractNode opposite = (AbstractNode)edge.getOpposite(this);
        TwoEdges ee = this.neighborMap.get(opposite);
        if (ee == null) {
            ee = new TwoEdges();
        }
        if ((type = this.edgeType(edge)) != '\u0002') {
            if (ee.in != null) {
                return false;
            }
            ee.in = edge;
        }
        if (type != '\u0000') {
            if (ee.out != null) {
                return false;
            }
            ee.out = edge;
        }
        this.neighborMap.put(opposite, ee);
        return super.addEdgeCallback(edge);
    }

    @Override
    protected void clearCallback() {
        this.neighborMap.clear();
        super.clearCallback();
    }

    protected static class TwoEdges {
        protected AbstractEdge in;
        protected AbstractEdge out;

        protected TwoEdges() {
        }
    }
}

