/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports.phonetics;

import ancestris.reports.FilterOptions;
import ancestris.reports.FormattingOptions;
import ancestris.reports.ScopeIndiOptions;
import ancestris.reports.SimpleColorsOptions;
import ancestris.reports.phonetics.DoubleMetaphone;
import ancestris.reports.phonetics.Metaphone;
import ancestris.reports.phonetics.Nysiis;
import ancestris.reports.phonetics.Phonetics;
import ancestris.reports.phonetics.Phonex;
import ancestris.reports.phonetics.Soundex;
import genj.fo.Document;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.report.Report;
import genj.util.ReferenceSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;

public class ReportPhonetics
extends Report {
    public MyFormattingOptions formattingOptions = new MyFormattingOptions();
    public ScopeIndiOptions scope = new ScopeIndiOptions();
    public boolean reportFirstNames = true;
    public FilterOptions filterOptions = new FilterOptions();
    public SimpleColorsOptions colors = new SimpleColorsOptions();
    private static final String SPAN_ALL = "number-columns-spanned=2";
    private Document doc;

    public boolean isReadOnly() {
        return true;
    }

    public String accepts(Object context) {
        return context instanceof Indi || context instanceof Gedcom ? this.getName() : null;
    }

    public Document start(Gedcom gedcom) {
        List<Indi> indis = this.scope.getScope(gedcom, this);
        return indis != null ? this.printPhonetic(gedcom, indis, MyFormattingOptions.outputFormats[this.formattingOptions.outputFormat]) : null;
    }

    public Document start(Indi indi) {
        Phonetics phonetic = (Phonetics)this.getValueFromUser(this.translate("select"), MyFormattingOptions.outputFormats, MyFormattingOptions.outputFormats[this.formattingOptions.outputFormat]);
        if (phonetic == null) {
            return null;
        }
        ArrayList<Indi> indis = new ArrayList<Indi>();
        indis.add(indi);
        return this.printPhonetic(indi.getGedcom(), indis, phonetic);
    }

    private Document printPhonetic(Gedcom gedcom, List<Indi> indis, Phonetics phonetics) {
        String headerRow = this.colors.getHeaderRowColor();
        String evenRow = this.colors.getEvenRowColor();
        String oddRow = this.colors.getOddRowColor();
        String textColor = this.colors.getTextColor();
        String backColor = this.colors.getBackgroundColor();
        ReferenceSet names = new ReferenceSet();
        for (Indi indi : indis) {
            Record record;
            String name;
            if (!this.filterOptions.matchRecord((Property)indi, name = (record = new Record(indi, phonetics)).getName(), record.toString()) || !this.reportFirstNames && !names.getReferences((Object)name).isEmpty()) continue;
            names.add((Object)name, (Object)record);
        }
        String title = this.translate("title", new Object[]{phonetics.toString(), gedcom.getDisplayName()});
        this.doc = this.formattingOptions.common.createDocument(this.translate("name"), textColor, backColor);
        this.doc.startSection(title, "title", 1, false, false, "font-size=" + this.formattingOptions.common.getTitleSize() + ",text-align=center, space-before=0cm, space-after=1cm");
        if (this.formattingOptions.common.includeTOC) {
            this.doc.addTOC(2, false, true);
            this.doc.nextParagraph("space-before=1cm");
        }
        this.doc.addText(this.scope.getMainMessage(), "font-weight=bold");
        for (String[] scopeLine : this.scope.getMessages()) {
            this.doc.nextParagraph();
            this.doc.addText("\u2219  " + scopeLine[0]);
            if (scopeLine[1].isBlank()) continue;
            this.doc.addText(" : " + scopeLine[1], "font-weight=bold");
        }
        this.doc.nextParagraph("space-before=1cm");
        if (this.filterOptions.isFilterOn()) {
            this.doc.addText(this.filterOptions.getMainMessage(), "font-weight=bold");
            for (String[] filterLine : this.filterOptions.getMessages()) {
                this.doc.nextParagraph();
                this.doc.addText("\u2219  " + filterLine[0]);
                if (filterLine[1].isBlank()) continue;
                this.doc.addText(" : " + filterLine[1], "font-weight=bold");
            }
            this.doc.nextParagraph("space-before=1cm");
        }
        this.doc.startTable("genj:csv=true, border-style=none, border=0, space-before=1cm, border-color=" + textColor);
        boolean bl = false;
        String key = "";
        for (String name : names.getKeys((Comparator)gedcom.getCollator())) {
            ArrayList records = new ArrayList(names.getReferences((Object)name));
            Collections.sort(records);
            for (Record record : records) {
                boolean bl2;
                String newKey = record.getKey();
                if (!newKey.equals(key)) {
                    key = newKey;
                    this.doc.nextTableRow();
                    this.doc.nextTableCell("number-columns-spanned=2, height=48, border-style=none, border-color=" + textColor);
                    this.doc.nextParagraph();
                    this.doc.addText("\u00a0");
                    if (this.formattingOptions.common.includeTOC) {
                        this.doc.addTOCEntry(key, 2);
                        this.doc.nextParagraph();
                        this.doc.addLink("^^^", "title");
                    }
                    this.doc.nextTableRow("font-size=" + this.formattingOptions.common.getTextSize() + ", text-align=center, font-weight=bold, background-color=" + headerRow);
                    this.doc.nextTableCell(SPAN_ALL);
                    this.doc.addText(key);
                    this.doc.nextTableRow("font-size=" + (this.formattingOptions.common.getTextSize() - 1) + ", text-align=center, background-color=" + headerRow);
                    this.doc.addText(Gedcom.getName((String)"NAME"), "font-weight=bold");
                    this.doc.nextTableCell();
                    this.doc.addText(this.translate("phoneticCode", new Object[]{phonetics.toString()}), "font-weight=bold");
                    bl2 = false;
                }
                String bgColor = bl2 % 2 == false ? evenRow : oddRow;
                bl2 += 1;
                this.doc.nextTableRow("font-size=" + this.formattingOptions.common.getTextSize() + ", background-color=" + bgColor);
                if (this.reportFirstNames) {
                    this.displayRow(this.doc, record.fullname, record.id, record.indiAnchor, record.code);
                    continue;
                }
                this.displayRow(this.doc, record.name, null, null, record.code);
            }
        }
        this.doc.endTable();
        return this.doc;
    }

    private void displayRow(Document doc, String name, String id, String link, String code) {
        doc.nextTableRow();
        doc.addText(name);
        if (id != null) {
            doc.addText(" (");
            doc.addLink(id, link);
            doc.addText(")");
        }
        doc.nextTableCell();
        doc.addText(code);
    }

    private String encode(String input, Phonetics phonetics) {
        String result = phonetics.encode(input);
        return result == null ? "\u00a0" : result;
    }

    public class MyFormattingOptions {
        public FormattingOptions common = new FormattingOptions();
        public int outputFormat = 0;
        public static Phonetics[] outputFormats = new Phonetics[]{new Soundex(), new Metaphone(), new DoubleMetaphone(), new Nysiis(), new Phonex()};
    }

    private class Record
    implements Comparable<Record> {
        private final Indi indi;
        private String name;
        private final String fullname;
        private final String id;
        private final String indiAnchor;
        private final String code;

        public Record(Indi indi, Phonetics phonetics) {
            this.indi = indi;
            this.name = indi.getLastName();
            if (!this.getKey().matches("[A-Z]")) {
                this.name = "?";
            }
            this.fullname = indi.getLastName() + " " + indi.getFirstName();
            this.id = indi.getId();
            this.indiAnchor = indi.getLinkAnchor();
            this.code = ReportPhonetics.this.encode(indi.getLastName(), phonetics);
        }

        private String getKey() {
            return this.name.isBlank() ? "?" : this.name.substring(0, 1).toUpperCase(Locale.getDefault());
        }

        public String getName() {
            return this.name;
        }

        @Override
        public int compareTo(Record record) {
            return this.fullname.compareTo(record.fullname);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.name);
            sb.append(" ");
            sb.append(this.code);
            sb.append(" ");
            sb.append(this.indi.toString());
            return sb.toString();
        }
    }
}

