/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports.datecalculator;

import ancestris.core.TextOptions;
import genj.gedcom.GedcomException;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.time.Calendar;
import genj.gedcom.time.Delta;
import genj.gedcom.time.PointInTime;
import genj.report.Report;

public class ReportDateCalculator
extends Report {
    public String accepts(Object context) {
        if (context != null && context instanceof PropertyDate) {
            PropertyDate pDate = (PropertyDate)context;
            String tag = pDate.getParent().getTag();
            if ("BIRT".equals(tag) || "CHR".equals(tag) && TextOptions.getInstance().isUseChr()) {
                return this.translate("xname.evt");
            }
            return this.translate("xname.birt");
        }
        return null;
    }

    public void start(PropertyDate date) {
        String dashes = "-".repeat(99);
        this.println(dashes);
        this.println(this.translate("name"));
        this.println(this.translate("selected.entity", new Object[]{date.getEntity().getDisplayTitle(true)}));
        this.println(dashes);
        PointInTime pit = date.getStart();
        String result = "";
        if (pit == null) {
            result = this.translate("date.undef");
        } else {
            String ageStr;
            try {
                pit = PointInTime.getPointInTime((long)pit.getTimeMillis());
            }
            catch (GedcomException gedcomException) {
                // empty catch block
            }
            Property parent = date.getParent();
            String tag = parent.getTag();
            boolean isChr = TextOptions.getInstance().isUseChr();
            boolean isBirth = "BIRT".equals(tag) || "CHR".equals(tag) && isChr;
            String title = this.translate(isBirth ? "date.title.birth" : "date.title.event");
            if (parent.getProperty("AGE") != null) {
                ageStr = parent.getProperty("AGE").getValue();
            } else {
                ageStr = this.getValueFromUser(title, this.translate(isBirth ? "age.msg.birth" : "age.msg.event"), new String[0]);
                if (ageStr == null) {
                    this.println("Cancelled");
                    return;
                }
            }
            Delta age = new Delta(0, 0, 0);
            if (age.setValue(ageStr) || age.setValue(ageStr + "y")) {
                if (isBirth) {
                    this.println("");
                    this.println(this.translate("selected.birth", new Object[]{date.getDisplayValue()}));
                    this.println(this.translate("age.birth", new Object[]{ageStr}));
                    this.println("");
                    PointInTime calcDate = ReportDateCalculator.getDateFromDateAndAge(pit, age, 1);
                    this.println(this.translate("date.evt.label", new Object[]{calcDate.toString()}));
                } else {
                    this.println("");
                    this.println(this.translate("selected.event", new Object[]{parent.getPropertyName(), date.getDisplayValue()}));
                    this.println(this.translate("age.event", new Object[]{ageStr}));
                    this.println("");
                    PointInTime calcDate = ReportDateCalculator.getDateFromDateAndAge(pit, age, -1);
                    this.println(this.translate("date.birth.label", new Object[]{calcDate.toString()}));
                }
                this.println("");
                this.println("");
                this.println("");
                this.println(dashes);
                if (isChr) {
                    this.println(this.translate("noteCHR"));
                }
            } else {
                result = this.translate("age.invalid");
            }
        }
        this.println(result);
    }

    private static PointInTime getDateFromDateAndAge(PointInTime date, Delta age, int op) {
        if (date == null || age == null) {
            return null;
        }
        if (!date.isValid()) {
            return null;
        }
        Calendar calendar = date.getCalendar();
        if (calendar != age.getCalendar()) {
            return null;
        }
        if (date.getYear() == Integer.MAX_VALUE) {
            return null;
        }
        int year = date.getYear() + op * age.getYears();
        int month = date.getMonth();
        int day = date.getDay();
        if (date.getMonth() != Integer.MAX_VALUE) {
            month += op * age.getMonths();
            if (day != Integer.MAX_VALUE) {
                day += op * age.getDays();
            }
        }
        return ReportDateCalculator.normalize(new PointInTime(day, month, year, calendar));
    }

    private static PointInTime normalize(PointInTime pit) {
        int year = pit.getYear();
        int month = pit.getMonth();
        int day = pit.getDay();
        Calendar cal = pit.getCalendar();
        if (month == Integer.MAX_VALUE) {
            return pit;
        }
        if (month > cal.getMonths() - 1) {
            return ReportDateCalculator.normalize(new PointInTime(day, month - cal.getMonths(), year + 1, cal));
        }
        if (month < 0) {
            return ReportDateCalculator.normalize(new PointInTime(day, month + cal.getMonths(), year - 1, cal));
        }
        if (day == Integer.MAX_VALUE) {
            return pit;
        }
        if (day > cal.getDays(month, year) - 1) {
            return ReportDateCalculator.normalize(new PointInTime(day - cal.getDays(month, year), month + 1, year, cal));
        }
        if (day < 0) {
            return ReportDateCalculator.normalize(new PointInTime(day + cal.getDays(month, year), month - 1, year, cal));
        }
        return pit;
    }
}

