/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports;

import ancestris.core.TextOptions;
import ancestris.reports.utils.PropUtils;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyAge;
import genj.gedcom.PropertyDate;
import genj.gedcom.time.Delta;

public class FormatAgeOptions {
    public boolean reportAgeOnlyYears = false;
    private static String MARR_SYMBOL = " " + TextOptions.getInstance().getMarriageSymbol() + " ";

    public String getAge(Property propEvent) {
        Entity entity = propEvent.getEntity();
        if (entity instanceof Indi) {
            return PropUtils.getAgeValue(propEvent.getProperty("AGE"), this.reportAgeOnlyYears);
        }
        if (entity instanceof Fam) {
            Property propHusbAge = propEvent.getPropertyByPath(".:HUSB:AGE");
            Property propWifeAge = propEvent.getPropertyByPath(".:WIFE:AGE");
            String ret = PropUtils.getAgeValue(propHusbAge, this.reportAgeOnlyYears) + MARR_SYMBOL + PropUtils.getAgeValue(propWifeAge, this.reportAgeOnlyYears);
            return ret.replaceAll(MARR_SYMBOL, "").isBlank() ? "" : ret;
        }
        return "";
    }

    public Delta getDoubleAge(Property propEvent) {
        Entity entity = propEvent.getEntity();
        if (entity instanceof Indi) {
            Property property = propEvent.getProperty("AGE");
            if (property instanceof PropertyAge) {
                PropertyAge age = (PropertyAge)property;
                return age.getAge();
            }
        } else if (entity instanceof Fam) {
            Property propHusbAge = propEvent.getPropertyByPath(".:HUSB:AGE");
            Property propWifeAge = propEvent.getPropertyByPath(".:WIFE:AGE");
            if (propHusbAge instanceof PropertyAge) {
                PropertyAge age = (PropertyAge)propHusbAge;
                return age.getAge();
            }
            if (propWifeAge instanceof PropertyAge) {
                PropertyAge age = (PropertyAge)propWifeAge;
                return age.getAge();
            }
        }
        return new Delta(0, 0, 0);
    }

    public String getCalculatedAge(Indi indi, PropertyDate date) {
        Delta delta = this.getCalculatedDoubleAge(indi, date);
        if (this.reportAgeOnlyYears) {
            return String.valueOf(delta.getYears());
        }
        return delta != null ? delta.toReportString() : "";
    }

    public Delta getCalculatedDoubleAge(Indi indi, PropertyDate date) {
        return date != null ? indi.getAge(date.getStart()) : new Delta(0, 0, 0);
    }
}

