/*
 * Decompiled with CFR 0.152.
 */
package ancestris.welcome.ui;

import ancestris.welcome.content.ActionButton;
import ancestris.welcome.content.BundleSupport;
import ancestris.welcome.content.Constants;
import ancestris.welcome.content.Utils;
import ancestris.welcome.ui.LinkAction;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openide.cookies.InstanceCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.ImageUtilities;

class GetStarted
extends JPanel
implements Constants {
    private int row;

    public GetStarted(String rootName) {
        super(new GridBagLayout());
        this.setOpaque(false);
        this.buildContent(rootName);
    }

    private void buildContent(String str) {
        String rootName = str;
        FileObject root = FileUtil.getConfigFile((String)rootName);
        if (null == root) {
            Logger.getLogger(GetStarted.class.getName()).log(Level.INFO, "Start page content not found: FileObject: " + rootName);
            return;
        }
        DataFolder folder = DataFolder.findFolder((FileObject)root);
        if (null == folder) {
            Logger.getLogger(GetStarted.class.getName()).log(Level.INFO, "Start page content not found: DataFolder: " + rootName);
            return;
        }
        DataObject[] children = folder.getChildren();
        if (null == children) {
            Logger.getLogger(GetStarted.class.getName()).log(Level.INFO, "Start page content not found: DataObject: " + rootName);
            return;
        }
        for (int i = 0; i < children.length; ++i) {
            if (children[i].getPrimaryFile().isFolder()) {
                String headerText = children[i].getNodeDelegate().getDisplayName();
                JLabel lblTitle = new JLabel(headerText);
                lblTitle.setFont(BUTTON_FONT);
                lblTitle.setHorizontalAlignment(2);
                lblTitle.setOpaque(true);
                lblTitle.setBorder(HEADER_TEXT_BORDER);
                this.add((Component)lblTitle, new GridBagConstraints(0, this.row++, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
                DataFolder subFolder = DataFolder.findFolder((FileObject)children[i].getPrimaryFile());
                DataObject[] subFolderChildren = subFolder.getChildren();
                for (int j = 0; j < subFolderChildren.length; ++j) {
                    this.row = this.addLink(this.row, subFolderChildren[j]);
                }
                continue;
            }
            this.row = this.addLink(this.row, children[i]);
        }
    }

    private int addLink(int row, DataObject dob) {
        Action action = this.extractAction(dob);
        if (null != action) {
            ActionButton lb = new ActionButton(action, Utils.getUrlString(dob), Utils.getColor("HeaderForegroundColor"), true, dob.getPrimaryFile().getPath());
            lb.setFont(GET_STARTED_FONT);
            lb.getAccessibleContext().setAccessibleName(lb.getText());
            lb.getAccessibleContext().setAccessibleDescription(BundleSupport.getAccessibilityDescription("GettingStarted", lb.getText()));
            ImageIcon icon = this.extractIcon(dob);
            if (icon != null) {
                lb.setIcon(icon);
            }
            this.add(lb);
            this.add(Box.createRigidArea(new Dimension(0, 5)));
        }
        return row;
    }

    private Action extractAction(DataObject dob) {
        OpenCookie oc = (OpenCookie)dob.getCookie(OpenCookie.class);
        if (null != oc) {
            return new LinkAction(dob);
        }
        InstanceCookie.Of instCookie = (InstanceCookie.Of)dob.getCookie(InstanceCookie.Of.class);
        if (null != instCookie && instCookie.instanceOf(Action.class)) {
            try {
                Action res = (Action)instCookie.instanceCreate();
                if (null != res) {
                    res.putValue("Name", dob.getNodeDelegate().getDisplayName());
                }
                return res;
            }
            catch (Exception e) {
                Logger.getLogger(GetStarted.class.getName()).log(Level.INFO, null, e);
            }
        }
        return null;
    }

    private ImageIcon extractIcon(DataObject dob) {
        String str = (String)dob.getPrimaryFile().getAttribute("iconBase");
        if (str != null && !str.isEmpty()) {
            return new ImageIcon(ImageUtilities.loadImage((String)str));
        }
        return null;
    }
}

