/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.network.proxy.pac.datetime;

import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.netbeans.core.network.proxy.pac.datetime.DateRange;
import org.netbeans.core.network.proxy.pac.datetime.TimeRange;

public class PacUtilsDateTime {
    public static final List<String> WEEKDAY_NAMES = Collections.unmodifiableList(Arrays.asList("SUN", "MON", "TUE", "WED", "THU", "FRI", "SAT"));
    public static final List<String> MONTH_NAMES = Collections.unmodifiableList(Arrays.asList("JAN", "FEB", "MAR", "APR", "MAY", "JUN", "JUL", "AUG", "SEP", "OCT", "NOV", "DEC"));
    private static final TimeZone UTC_TIME = TimeZone.getTimeZone("UTC");

    public static boolean isInWeekdayRange(Date now, Object ... args) throws PacDateTimeInputException {
        int wdNumMax;
        int wdNumMin;
        int params = PacUtilsDateTime.getNoOfParams(args);
        boolean gmt = PacUtilsDateTime.usesGMT(args);
        Calendar cal = PacUtilsDateTime.getCalendar(now, gmt);
        if (gmt) {
            --params;
        }
        if (params < 1 || params > 2) {
            throw new PacDateTimeInputException("invalid number of arguments");
        }
        if (params == 1) {
            wdNumMax = wdNumMin = PacUtilsDateTime.getWeekday(args[0].toString());
        } else {
            wdNumMin = PacUtilsDateTime.getWeekday(args[0].toString());
            wdNumMax = PacUtilsDateTime.getWeekday(args[1].toString());
        }
        int wdNum = cal.get(7);
        if (wdNumMin <= wdNumMax) {
            return wdNum >= wdNumMin && wdNum <= wdNumMax;
        }
        return wdNum >= wdNumMin || wdNum <= wdNumMax;
    }

    public static boolean isInTimeRange(Date now, Object ... args) throws PacDateTimeInputException {
        int params = PacUtilsDateTime.getNoOfParams(args);
        boolean gmt = PacUtilsDateTime.usesGMT(args);
        Calendar cal = PacUtilsDateTime.getCalendar(now, gmt);
        if (gmt) {
            --params;
        }
        if (params < 1 || params > 6 || params == 5 || params == 3) {
            throw new PacDateTimeInputException("invalid number of arguments");
        }
        TimeRange.TimeRangeBuilder trBld = TimeRange.getBuilder();
        if (params == 1) {
            trBld.setHourMinMax(PacUtilsDateTime.getHour(args[0]), PacUtilsDateTime.getHour(args[0]));
        }
        if (params == 2) {
            trBld.setHourMinMax(PacUtilsDateTime.getHour(args[0]), PacUtilsDateTime.getHour(args[1]));
            if (PacUtilsDateTime.getHour(args[0]) != PacUtilsDateTime.getHour(args[1])) {
                trBld.setMinuteMinMax(0, 0);
            }
        }
        if (params == 4) {
            trBld.setHourMinMax(PacUtilsDateTime.getHour(args[0]), PacUtilsDateTime.getHour(args[2])).setMinuteMinMax(PacUtilsDateTime.getMinute(args[1]), PacUtilsDateTime.getMinute(args[3])).setSecondMinMax(0, 0);
        }
        if (params == 6) {
            trBld.setHourMinMax(PacUtilsDateTime.getHour(args[0]), PacUtilsDateTime.getHour(args[3])).setMinuteMinMax(PacUtilsDateTime.getMinute(args[1]), PacUtilsDateTime.getMinute(args[4])).setSecondMinMax(PacUtilsDateTime.getSecond(args[2]), PacUtilsDateTime.getSecond(args[5]));
        }
        TimeRange timeRange = trBld.createTimeRange();
        return timeRange.isInRange(cal);
    }

    public static boolean isInDateRange(Date now, Object ... args) throws PacDateTimeInputException {
        int params = PacUtilsDateTime.getNoOfParams(args);
        boolean gmt = PacUtilsDateTime.usesGMT(args);
        Calendar cal = PacUtilsDateTime.getCalendar(now, gmt);
        if (gmt) {
            --params;
        }
        if (params < 1 || params > 6 || params == 5 || params == 3) {
            throw new PacDateTimeInputException("invalid number of arguments");
        }
        DateRange.DateRangeBuilder drBld = DateRange.getBuilder();
        if (params == 1) {
            if (PacUtilsDateTime.isYear(args[0])) {
                int y = PacUtilsDateTime.getYear(args[0]);
                drBld.setYear(y, y);
            } else if (PacUtilsDateTime.isMonth(args[0])) {
                int m = PacUtilsDateTime.getMonth(args[0].toString());
                drBld.setMonth(m, m);
            } else if (PacUtilsDateTime.isDate(args[0])) {
                int d = PacUtilsDateTime.getDate(args[0]);
                drBld.setDate(d, d);
            } else {
                throw new PacDateTimeInputException("invalid argument : " + args[0].toString());
            }
        }
        if (params == 2) {
            if (PacUtilsDateTime.isYear(args[0])) {
                drBld.setYear(PacUtilsDateTime.getYear(args[0]), PacUtilsDateTime.getYear(args[1]));
            } else if (PacUtilsDateTime.isMonth(args[0])) {
                drBld.setMonth(PacUtilsDateTime.getMonth(args[0].toString()), PacUtilsDateTime.getMonth(args[1].toString()));
            } else if (PacUtilsDateTime.isDate(args[0])) {
                drBld.setDate(PacUtilsDateTime.getDate(args[0]), PacUtilsDateTime.getDate(args[1]));
            } else {
                throw new PacDateTimeInputException("invalid argument : " + args[0].toString());
            }
        }
        if (params == 4) {
            if (PacUtilsDateTime.isMonth(args[0])) {
                drBld.setYear(PacUtilsDateTime.getYear(args[1]), PacUtilsDateTime.getYear(args[3])).setMonth(PacUtilsDateTime.getMonth(args[0].toString()), PacUtilsDateTime.getMonth(args[2].toString()));
            } else if (PacUtilsDateTime.isDate(args[0])) {
                drBld.setMonth(PacUtilsDateTime.getMonth(args[1].toString()), PacUtilsDateTime.getMonth(args[3].toString())).setDate(PacUtilsDateTime.getDate(args[0]), PacUtilsDateTime.getDate(args[2]));
            } else {
                throw new PacDateTimeInputException("invalid argument : " + args[0].toString());
            }
        }
        if (params == 6) {
            drBld.setYear(PacUtilsDateTime.getYear(args[2]), PacUtilsDateTime.getYear(args[5])).setMonth(PacUtilsDateTime.getMonth(args[1].toString()), PacUtilsDateTime.getMonth(args[4].toString())).setDate(PacUtilsDateTime.getDate(args[0]), PacUtilsDateTime.getDate(args[3]));
        }
        DateRange dateRange = drBld.createDateRange();
        return dateRange.isInRange(cal);
    }

    private static boolean isMonth(Object obj) {
        return obj instanceof CharSequence;
    }

    private static boolean isYear(Object obj) {
        try {
            int val = PacUtilsDateTime.getInteger(obj);
            return val >= 1000;
        }
        catch (PacDateTimeInputException ex) {
            return false;
        }
    }

    private static boolean isDate(Object obj) {
        try {
            int val = PacUtilsDateTime.getInteger(obj);
            return val >= 1 && val <= 31;
        }
        catch (PacDateTimeInputException ex) {
            return false;
        }
    }

    private static int getDate(Object obj) throws PacDateTimeInputException {
        if (!PacUtilsDateTime.isDate(obj)) {
            throw new PacDateTimeInputException("value " + obj.toString() + " is not a valid day of month");
        }
        return PacUtilsDateTime.getInteger(obj);
    }

    private static int getYear(Object obj) throws PacDateTimeInputException {
        if (!PacUtilsDateTime.isYear(obj)) {
            throw new PacDateTimeInputException("value " + obj.toString() + " is not a valid year");
        }
        return PacUtilsDateTime.getInteger(obj);
    }

    private static int getWeekday(String wd) throws PacDateTimeInputException {
        int indexOf = WEEKDAY_NAMES.indexOf(wd);
        if (indexOf == -1) {
            throw new PacDateTimeInputException("Unknown weekday name : \"" + wd + "\"");
        }
        return indexOf + 1;
    }

    private static int getMonth(String month) throws PacDateTimeInputException {
        int indexOf = MONTH_NAMES.indexOf(month);
        if (indexOf == -1) {
            throw new PacDateTimeInputException("Unknown month name : \"" + month + "\"");
        }
        return indexOf;
    }

    private static int getInteger(Object obj) throws PacDateTimeInputException {
        if (obj instanceof Integer || obj instanceof Long) {
            return ((Number)obj).intValue();
        }
        if (obj instanceof String) {
            try {
                return Integer.parseInt((String)obj);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new PacDateTimeInputException("value is " + obj + " is not an integer");
    }

    private static int getHour(Object obj) throws PacDateTimeInputException {
        int hour = PacUtilsDateTime.getInteger(obj);
        if (hour < 0 || hour > 23) {
            throw new PacDateTimeInputException("value is " + hour + " is not a valid hour of day (0-23)");
        }
        return hour;
    }

    private static int getMinute(Object obj) throws PacDateTimeInputException {
        int min = PacUtilsDateTime.getInteger(obj);
        if (min < 0 || min > 59) {
            throw new PacDateTimeInputException("value is " + min + " is not a valid minute (0-59)");
        }
        return min;
    }

    private static int getSecond(Object obj) throws PacDateTimeInputException {
        int sec = PacUtilsDateTime.getInteger(obj);
        if (sec < 0 || sec > 59) {
            throw new PacDateTimeInputException("value is " + sec + " is not a valid second (0-59)");
        }
        return sec;
    }

    private static Calendar getCalendar(Date now, boolean useGMT) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(now);
        if (useGMT) {
            cal.setTimeZone(UTC_TIME);
        }
        return cal;
    }

    public static int getNoOfParams(Object ... objs) {
        int params = 0;
        for (Object obj : objs) {
            if (obj == null || !(obj instanceof Number) && !(obj instanceof CharSequence)) continue;
            ++params;
        }
        return params;
    }

    public static boolean usesGMT(Object ... args) {
        String p;
        int params = PacUtilsDateTime.getNoOfParams(args);
        return args[params - 1] instanceof CharSequence && (p = args[params - 1].toString()).equals("GMT");
    }

    public static class PacDateTimeInputException
    extends Exception {
        public PacDateTimeInputException(String msg) {
            super(msg);
        }
    }
}

