/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.ext.javatime.ser;

import com.fasterxml.jackson.annotation.JsonFormat;
import java.time.MonthDay;
import java.time.format.DateTimeFormatter;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.JsonToken;
import tools.jackson.core.type.WritableTypeId;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.ext.javatime.ser.JSR310FormattedSerializerBase;
import tools.jackson.databind.jsontype.TypeSerializer;

public class MonthDaySerializer
extends JSR310FormattedSerializerBase<MonthDay> {
    public static final MonthDaySerializer INSTANCE = new MonthDaySerializer();

    protected MonthDaySerializer() {
        this((DateTimeFormatter)null);
    }

    public MonthDaySerializer(DateTimeFormatter formatter) {
        super(MonthDay.class, formatter);
    }

    private MonthDaySerializer(MonthDaySerializer base, DateTimeFormatter dtf, Boolean useTimestamp) {
        super(base, dtf, useTimestamp, null, null);
    }

    protected MonthDaySerializer withFormat(DateTimeFormatter dtf, Boolean useTimestamp, JsonFormat.Shape shape) {
        return new MonthDaySerializer(this, dtf, useTimestamp);
    }

    @Override
    public void serialize(MonthDay value, JsonGenerator g, SerializationContext ctxt) throws JacksonException {
        if (this._useTimestampExplicitOnly(ctxt)) {
            g.writeStartArray();
            this._serializeAsArrayContents(value, g, ctxt);
            g.writeEndArray();
        } else {
            g.writeString(this._formatter == null ? value.toString() : value.format(this._formatter));
        }
    }

    @Override
    public void serializeWithType(MonthDay value, JsonGenerator g, SerializationContext ctxt, TypeSerializer typeSer) throws JacksonException {
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(g, ctxt, typeSer.typeId(value, this.serializationShape(ctxt)));
        if (typeIdDef != null && typeIdDef.valueShape == JsonToken.START_ARRAY) {
            this._serializeAsArrayContents(value, g, ctxt);
        } else {
            g.writeString(this._formatter == null ? value.toString() : value.format(this._formatter));
        }
        typeSer.writeTypeSuffix(g, ctxt, typeIdDef);
    }

    protected void _serializeAsArrayContents(MonthDay value, JsonGenerator g, SerializationContext ctxt) throws JacksonException {
        g.writeNumber(value.getMonthValue());
        g.writeNumber(value.getDayOfMonth());
    }

    @Override
    protected JsonToken serializationShape(SerializationContext ctxt) {
        return this._useTimestampExplicitOnly(ctxt) ? JsonToken.START_ARRAY : JsonToken.VALUE_STRING;
    }
}

