import { Interfaces } from '@oclif/core';
import { BuildConfig as TarballConfig } from './tarballs/config';
export declare function commitAWSDir(version: string, sha: string, s3Config: TarballConfig['s3Config']): string;
export declare function channelAWSDir(channel: string, s3Config: TarballConfig['s3Config']): string;
type TemplateOptions = Interfaces.Config.s3Key.Options | {
    arch?: DebArch | Interfaces.ArchTypes;
    bin?: string;
    ext?: '.tar.gz' | '.tar.xz';
    sha?: string;
    version?: string;
    versionShaRevision?: string;
};
export declare function templateShortKey(type: 'deb' | 'macos' | 'win32' | keyof Interfaces.S3Templates, options?: TemplateOptions): string;
export type DebArch = 'amd64' | 'arm64' | 'armel' | 'i386';
export declare function debArch(arch: Interfaces.ArchTypes): DebArch;
export declare function debVersion(buildConfig: TarballConfig): string;
export {};
