/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core.search;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.json.UnionDeserializer;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.TaggedUnion;
import org.opensearch.client.util.TaggedUnionUtils;

@JsonpDeserializable
public class SourceConfigParam
implements TaggedUnion<Kind, Object>,
PlainJsonSerializable {
    private final Kind _kind;
    private final Object _value;
    public static final JsonpDeserializer<SourceConfigParam> _DESERIALIZER = JsonpDeserializer.lazy(SourceConfigParam::buildSourceConfigParamDeserializer);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    private SourceConfigParam(Kind kind, Object value) {
        this._kind = kind;
        this._value = value;
    }

    private SourceConfigParam(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static SourceConfigParam of(Function<Builder, ObjectBuilder<SourceConfigParam>> fn) {
        return fn.apply(new Builder()).build();
    }

    public String _toJsonString() {
        switch (this._kind.ordinal()) {
            case 0: {
                return String.valueOf(this.fetch());
            }
            case 1: {
                return String.join((CharSequence)",", this.fields());
            }
        }
        throw new IllegalStateException("Unknown kind " + (Object)((Object)this._kind));
    }

    public boolean isFetch() {
        return this._kind == Kind.Fetch;
    }

    public Boolean fetch() {
        return (Boolean)TaggedUnionUtils.get(this, Kind.Fetch);
    }

    public boolean isFields() {
        return this._kind == Kind.Fields;
    }

    public List<String> fields() {
        return (List)TaggedUnionUtils.get(this, Kind.Fields);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        } else {
            switch (this._kind.ordinal()) {
                case 0: {
                    generator.write(((Boolean)this._value).booleanValue());
                    break;
                }
                case 1: {
                    generator.writeStartArray();
                    for (String item0 : (List)this._value) {
                        generator.write(item0);
                    }
                    generator.writeEnd();
                }
            }
        }
    }

    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    private static JsonpDeserializer<SourceConfigParam> buildSourceConfigParamDeserializer() {
        return new UnionDeserializer.Builder<SourceConfigParam, Kind, Object>(SourceConfigParam::new, false).addMember(Kind.Fetch, JsonpDeserializer.booleanDeserializer()).addMember(Kind.Fields, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer())).build();
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode((Object)this._kind);
        result = 31 * result + Objects.hashCode(this._value);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SourceConfigParam other = (SourceConfigParam)o;
        return Objects.equals((Object)this._kind, (Object)other._kind) && Objects.equals(this._value, other._value);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<SourceConfigParam> {
        private Kind _kind;
        private Object _value;

        public Builder() {
        }

        private Builder(SourceConfigParam o) {
            this._kind = o._kind;
            this._value = o._value;
        }

        public ObjectBuilder<SourceConfigParam> fetch(Boolean v) {
            this._kind = Kind.Fetch;
            this._value = v;
            return this;
        }

        public ObjectBuilder<SourceConfigParam> fields(List<String> v) {
            this._kind = Kind.Fields;
            this._value = v;
            return this;
        }

        @Override
        public SourceConfigParam build() {
            this._checkSingleUse();
            return new SourceConfigParam(this);
        }
    }

    public static enum Kind {
        Fetch,
        Fields;

    }
}

