/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import org.apache.lucene.search.TotalHits;
import org.jetbrains.annotations.NotNull;
import org.opensearch.ExceptionsHelper;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.search.ShardSearchFailure;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.indexmanagement.rollup.action.get.GetRollupsResponse;
import org.opensearch.indexmanagement.rollup.model.Rollup;
import org.opensearch.indexmanagement.transform.action.get.GetTransformsResponse;
import org.opensearch.indexmanagement.transform.model.Transform;
import org.opensearch.indexmanagement.util.ScheduledJobUtilsKt;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.transport.client.Client;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000^\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0002\u001aQ\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2#\b\u0002\u0010\u000b\u001a\u001d\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0010\u0012\u0004\u0012\u00020\u00110\f\u001a.\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\n2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002\u001a.\u0010\u001b\u001a \u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u00160\u001c2\u0006\u0010\u0013\u001a\u00020\nH\u0002\u001a\u0010\u0010\u000b\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\rH\u0002\u00a8\u0006\u001f"}, d2={"getJobs", "", "client", "Lorg/opensearch/transport/client/Client;", "searchSourceBuilder", "Lorg/opensearch/search/builder/SearchSourceBuilder;", "listener", "Lorg/opensearch/core/action/ActionListener;", "Lorg/opensearch/core/action/ActionResponse;", "scheduledJobType", "", "contentParser", "Lkotlin/Function1;", "Lorg/opensearch/core/common/bytes/BytesReference;", "Lkotlin/ParameterName;", "name", "b", "Lorg/opensearch/core/xcontent/XContentParser;", "populateResponse", "jobType", "jobs", "", "", "status", "Lorg/opensearch/core/rest/RestStatus;", "totalJobs", "", "getParser", "Lkotlin/Function4;", "", "bytesReference", "opensearch-index-management"})
public final class ScheduledJobUtilsKt {
    public static final void getJobs(@NotNull Client client, @NotNull SearchSourceBuilder searchSourceBuilder, @NotNull ActionListener<ActionResponse> listener, @NotNull String scheduledJobType, @NotNull Function1<? super BytesReference, ? extends XContentParser> contentParser) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)searchSourceBuilder, (String)"searchSourceBuilder");
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)scheduledJobType, (String)"scheduledJobType");
        Intrinsics.checkNotNullParameter(contentParser, (String)"contentParser");
        String[] stringArray = new String[]{".opendistro-ism-config"};
        SearchRequest searchRequest = new SearchRequest(stringArray).source(searchSourceBuilder);
        client.search(searchRequest, (ActionListener)new ActionListener<SearchResponse>(listener, scheduledJobType, contentParser){
            final /* synthetic */ ActionListener<ActionResponse> $listener;
            final /* synthetic */ String $scheduledJobType;
            final /* synthetic */ Function1<BytesReference, XContentParser> $contentParser;
            {
                this.$listener = $listener;
                this.$scheduledJobType = $scheduledJobType;
                this.$contentParser = $contentParser;
            }

            /*
             * WARNING - void declaration
             */
            public void onResponse(SearchResponse response2) {
                Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                TotalHits totalHits = response2.getHits().getTotalHits();
                long totalJobs = totalHits != null ? totalHits.value() : 0L;
                ShardSearchFailure[] shardSearchFailureArray = response2.getShardFailures();
                Intrinsics.checkNotNullExpressionValue((Object)shardSearchFailureArray, (String)"getShardFailures(...)");
                if (!(((Object[])shardSearchFailureArray).length == 0)) {
                    ShardSearchFailure[] shardSearchFailureArray2 = response2.getShardFailures();
                    Intrinsics.checkNotNullExpressionValue((Object)shardSearchFailureArray2, (String)"getShardFailures(...)");
                    Object[] $this$reduce$iv = shardSearchFailureArray2;
                    boolean $i$f$reduce = false;
                    if ($this$reduce$iv.length == 0) {
                        throw new UnsupportedOperationException("Empty array can't be reduced.");
                    }
                    Object accumulator$iv = $this$reduce$iv[0];
                    int index$iv = 1;
                    int n = ArraysKt.getLastIndex((Object[])$this$reduce$iv);
                    if (index$iv <= n) {
                        while (true) {
                            void s2;
                            ShardSearchFailure shardSearchFailure = (ShardSearchFailure)$this$reduce$iv[index$iv];
                            ShardSearchFailure s1 = (ShardSearchFailure)accumulator$iv;
                            boolean bl = false;
                            Object object = accumulator$iv = s1.status().getStatus() > s2.status().getStatus() ? s1 : s2;
                            if (index$iv == n) break;
                            ++index$iv;
                        }
                    }
                    ShardSearchFailure failure = (ShardSearchFailure)accumulator$iv;
                    this.$listener.onFailure((Exception)((Object)new OpenSearchStatusException("Get " + this.$scheduledJobType + " failed on some shards", failure.status(), failure.getCause(), new Object[0])));
                } else {
                    try {
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        SearchHit[] searchHitArray = response2.getHits().getHits();
                        Intrinsics.checkNotNullExpressionValue((Object)searchHitArray, (String)"getHits(...)");
                        Object[] $this$reduce$iv = searchHitArray;
                        Function1<BytesReference, XContentParser> function1 = this.$contentParser;
                        String string = this.$scheduledJobType;
                        boolean $i$f$map = false;
                        void var9_12 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(((void)$this$map$iv).length);
                        boolean $i$f$mapTo = false;
                        for (void item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            SearchHit searchHit = (SearchHit)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl = false;
                            BytesReference bytesReference = it.getSourceRef();
                            Intrinsics.checkNotNullExpressionValue((Object)bytesReference, (String)"getSourceRef(...)");
                            XContentParser xContentParser = (XContentParser)function1.invoke((Object)bytesReference);
                            String string2 = it.getId();
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getId(...)");
                            collection.add(OpenSearchExtensionsKt.parseWithType(xContentParser, string2, it.getSeqNo(), it.getPrimaryTerm(), ScheduledJobUtilsKt.access$getParser(string)));
                        }
                        List jobs = (List)destination$iv$iv;
                        this.$listener.onResponse((Object)ScheduledJobUtilsKt.access$populateResponse(this.$scheduledJobType, jobs, RestStatus.OK, (int)totalJobs));
                    }
                    catch (Exception e) {
                        this.$listener.onFailure((Exception)((Object)new OpenSearchStatusException("Failed to parse " + this.$scheduledJobType, RestStatus.INTERNAL_SERVER_ERROR, ExceptionsHelper.unwrapCause((Throwable)e), new Object[0])));
                    }
                }
            }

            public void onFailure(Exception e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$listener.onFailure(e);
            }
        });
    }

    public static /* synthetic */ void getJobs$default(Client client, SearchSourceBuilder searchSourceBuilder, ActionListener actionListener, String string, Function1 function1, int n, Object object) {
        if ((n & 0x10) != 0) {
            function1 = getJobs.1.INSTANCE;
        }
        ScheduledJobUtilsKt.getJobs(client, searchSourceBuilder, (ActionListener<ActionResponse>)actionListener, string, (Function1<? super BytesReference, ? extends XContentParser>)function1);
    }

    private static final ActionResponse populateResponse(String jobType, List<? extends Object> jobs, RestStatus status, int totalJobs) {
        ActionResponse actionResponse;
        String string = jobType;
        if (Intrinsics.areEqual((Object)string, (Object)"rollup")) {
            Intrinsics.checkNotNull(jobs, (String)"null cannot be cast to non-null type kotlin.collections.List<org.opensearch.indexmanagement.rollup.model.Rollup>");
            actionResponse = new GetRollupsResponse(jobs, totalJobs, status);
        } else if (Intrinsics.areEqual((Object)string, (Object)"transform")) {
            Intrinsics.checkNotNull(jobs, (String)"null cannot be cast to non-null type kotlin.collections.List<org.opensearch.indexmanagement.transform.model.Transform>");
            actionResponse = new GetTransformsResponse(jobs, totalJobs, status);
        } else {
            throw new OpenSearchStatusException("Unknown scheduled job type", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]);
        }
        return actionResponse;
    }

    private static final Function4<XContentParser, String, Long, Long, Object> getParser(String jobType) {
        Function4 function4;
        String string = jobType;
        if (Intrinsics.areEqual((Object)string, (Object)"transform")) {
            function4 = (Function4)new Function4<XContentParser, String, Long, Long, Transform>((Object)Transform.Companion){

                public final Transform invoke(XContentParser p0, String p1, long p2, long p3) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                    return ((Transform.Companion)this.receiver).parse(p0, p1, p2, p3);
                }
            };
        } else if (Intrinsics.areEqual((Object)string, (Object)"rollup")) {
            function4 = (Function4)new Function4<XContentParser, String, Long, Long, Rollup>((Object)Rollup.Companion){

                public final Rollup invoke(XContentParser p0, String p1, long p2, long p3) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                    return ((Rollup.Companion)this.receiver).parse(p0, p1, p2, p3);
                }
            };
        } else {
            throw new OpenSearchStatusException("Unknown scheduled job type", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]);
        }
        return function4;
    }

    private static final XContentParser contentParser(BytesReference bytesReference) {
        XContentParser xContentParser = XContentHelper.createParser((NamedXContentRegistry)NamedXContentRegistry.EMPTY, (DeprecationHandler)((DeprecationHandler)LoggingDeprecationHandler.INSTANCE), (BytesReference)bytesReference, (MediaType)((MediaType)XContentType.JSON));
        Intrinsics.checkNotNullExpressionValue((Object)xContentParser, (String)"createParser(...)");
        return xContentParser;
    }

    public static final /* synthetic */ ActionResponse access$populateResponse(String jobType, List jobs, RestStatus status, int totalJobs) {
        return ScheduledJobUtilsKt.populateResponse(jobType, jobs, status, totalJobs);
    }

    public static final /* synthetic */ Function4 access$getParser(String jobType) {
        return ScheduledJobUtilsKt.getParser(jobType);
    }

    public static final /* synthetic */ XContentParser access$contentParser(BytesReference bytesReference) {
        return ScheduledJobUtilsKt.contentParser(bytesReference);
    }
}

