/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.indexstatemanagement.step.rollover;

import java.lang.invoke.LambdaMetafactory;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.ExceptionsHelper;
import org.opensearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.opensearch.action.admin.indices.rollover.RolloverRequest;
import org.opensearch.action.admin.indices.rollover.RolloverResponse;
import org.opensearch.action.admin.indices.stats.IndicesStatsRequest;
import org.opensearch.action.admin.indices.stats.IndicesStatsResponse;
import org.opensearch.action.admin.indices.stats.ShardStats;
import org.opensearch.action.support.clustermanager.AcknowledgedResponse;
import org.opensearch.cluster.metadata.AliasMetadata;
import org.opensearch.cluster.metadata.IndexAbstraction;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.metadata.Metadata;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.action.support.DefaultShardOperationFailedException;
import org.opensearch.core.common.unit.ByteSizeValue;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.indexmanagement.indexstatemanagement.action.RolloverAction;
import org.opensearch.indexmanagement.indexstatemanagement.step.rollover.AttemptRolloverStep;
import org.opensearch.indexmanagement.indexstatemanagement.util.ManagedIndexUtils;
import org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.indexmanagement.spi.indexstatemanagement.Step;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.ManagedIndexMetaData;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.StepContext;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.StepMetaData;
import org.opensearch.transport.RemoteTransportException;
import org.opensearch.transport.client.Client;
import org.opensearch.transport.client.IndicesAdminClient;
import org.opensearch.transport.client.OpenSearchClient;

@kotlin.Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 32\u00020\u0001:\u00013B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0010\u001a\u00020\u0001H\u0096@\u00a2\u0006\u0002\u0010\u0011J\u001e\u0010\u0012\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\r\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\rH\u0002J\u0018\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0015\u001a\u00020\u0016H\u0082@\u00a2\u0006\u0002\u0010\u001bJH\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020\u00142 \u0010 \u001a\u001c\u0012\u0004\u0012\u00020\r\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\f0\fH\u0082@\u00a2\u0006\u0002\u0010!J6\u0010\"\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\r2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u001e\u001a\u00020\r2\u0006\u0010(\u001a\u00020)H\u0082@\u00a2\u0006\u0002\u0010*J\u0010\u0010+\u001a\u00020)2\u0006\u0010,\u001a\u00020)H\u0016J2\u0010-\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020\r2\n\u0010.\u001a\u00060/j\u0002`02\b\b\u0002\u00101\u001a\u00020\r2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010\u000eH\u0002J\b\u00102\u001a\u00020\u0014H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/step/rollover/AttemptRolloverStep;", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/Step;", "action", "Lorg/opensearch/indexmanagement/indexstatemanagement/action/RolloverAction;", "<init>", "(Lorg/opensearch/indexmanagement/indexstatemanagement/action/RolloverAction;)V", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "stepStatus", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/Step$StepStatus;", "info", "", "", "", "newIndex", "execute", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getRolloverTargetOrUpdateInfo", "Lkotlin/Pair;", "", "context", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/model/StepContext;", "preCheckIndexAlias", "alias", "getIndexStatsOrUpdateInfo", "Lorg/opensearch/action/admin/indices/stats/IndicesStatsResponse;", "(Lorg/opensearch/indexmanagement/spi/indexstatemanagement/model/StepContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "executeRollover", "", "rolloverTarget", "isDataStream", "conditions", "(Lorg/opensearch/indexmanagement/spi/indexstatemanagement/model/StepContext;Ljava/lang/String;ZLjava/util/Map;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "copyAlias", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "indexName", "client", "Lorg/opensearch/transport/client/Client;", "metadata", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/model/ManagedIndexMetaData;", "(Lorg/opensearch/cluster/service/ClusterService;Ljava/lang/String;Lorg/opensearch/transport/client/Client;Ljava/lang/String;Lorg/opensearch/indexmanagement/spi/indexstatemanagement/model/ManagedIndexMetaData;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getUpdatedManagedIndexMetadata", "currentMetadata", "handleException", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "message", "isIdempotent", "Companion", "opensearch-index-management"})
@SourceDebugExtension(value={"SMAP\nAttemptRolloverStep.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AttemptRolloverStep.kt\norg/opensearch/indexmanagement/indexstatemanagement/step/rollover/AttemptRolloverStep\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,431:1\n14151#2,14:432\n11228#2:450\n11563#2,3:451\n1563#3:446\n1634#3,3:447\n1869#3,2:454\n*S KotlinDebug\n*F\n+ 1 AttemptRolloverStep.kt\norg/opensearch/indexmanagement/indexstatemanagement/step/rollover/AttemptRolloverStep\n*L\n89#1:432,14\n212#1:450\n212#1:451,3\n184#1:446\n184#1:447,3\n334#1:454,2\n*E\n"})
public final class AttemptRolloverStep
extends Step {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RolloverAction action;
    private final Logger logger;
    @NotNull
    private Step.StepStatus stepStatus;
    @Nullable
    private Map<String, ? extends Object> info;
    @Nullable
    private String newIndex;
    @NotNull
    public static final String name = "attempt_rollover";

    public AttemptRolloverStep(@NotNull RolloverAction action) {
        Intrinsics.checkNotNullParameter((Object)((Object)action), (String)"action");
        super(name, false, 2, null);
        this.action = action;
        this.logger = LogManager.getLogger(((Object)((Object)this)).getClass());
        this.stepStatus = Step.StepStatus.STARTING;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public Object execute(@NotNull Continuation<? super Step> $completion) {
        block35: {
            if (!($completion instanceof execute.1)) ** GOTO lbl-1000
            var32_2 = $completion;
            if ((var32_2.label & -2147483648) != 0) {
                var32_2.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    Object L$4;
                    Object L$5;
                    Object L$6;
                    Object L$7;
                    Object L$8;
                    Object L$9;
                    boolean Z$0;
                    boolean Z$1;
                    long J$0;
                    long J$1;
                    /* synthetic */ Object result;
                    final /* synthetic */ AttemptRolloverStep this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.execute((Continuation<? super Step>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var33_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = this.getContext();
                    if (v0 == null) {
                        return this;
                    }
                    context = v0;
                    indexName = context.getMetadata().getIndex();
                    clusterService = context.getClusterService();
                    v1 = clusterService.state().getMetadata().index(indexName);
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"index(...)");
                    skipRollover = org.opensearch.indexmanagement.indexstatemanagement.opensearchapi.OpenSearchExtensionsKt.getRolloverSkip(v1);
                    if (skipRollover) {
                        this.stepStatus = Step.StepStatus.COMPLETED;
                        this.info = MapsKt.mapOf((Pair)TuplesKt.to((Object)"message", (Object)AttemptRolloverStep.Companion.getSkipRolloverMessage(indexName)));
                        return this;
                    }
                    var6_17 = this.getRolloverTargetOrUpdateInfo(context);
                    rolloverTarget = (String)var6_17.component1();
                    isDataStream = (Boolean)var6_17.component2();
                    if (rolloverTarget == null) {
                        return this;
                    }
                    if (!clusterService.state().getMetadata().index(indexName).getRolloverInfos().containsKey(rolloverTarget)) break;
                    this.stepStatus = Step.StepStatus.COMPLETED;
                    this.info = MapsKt.mapOf((Pair)TuplesKt.to((Object)"message", (Object)AttemptRolloverStep.Companion.getAlreadyRolledOverMessage(indexName, rolloverTarget)));
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)context);
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)indexName);
                    $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)clusterService);
                    $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)rolloverTarget);
                    $continuation.Z$0 = skipRollover;
                    $continuation.Z$1 = isDataStream;
                    $continuation.label = 1;
                    v2 = this.copyAlias(clusterService, indexName, context.getClient(), rolloverTarget, context.getMetadata(), (Continuation<? super Unit>)$continuation);
                    if (v2 == var33_4) {
                        return var33_4;
                    }
                    ** GOTO lbl53
                }
                case 1: {
                    isDataStream = $continuation.Z$1;
                    skipRollover = $continuation.Z$0;
                    rolloverTarget = (String)$continuation.L$3;
                    clusterService = (ClusterService)$continuation.L$2;
                    indexName = (String)$continuation.L$1;
                    context = (StepContext)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl53:
                    // 2 sources

                    return this;
                }
            }
            if (!isDataStream && !this.preCheckIndexAlias(context, rolloverTarget)) {
                this.stepStatus = Step.StepStatus.FAILED;
                this.info = MapsKt.mapOf((Pair)TuplesKt.to((Object)"message", (Object)AttemptRolloverStep.Companion.getFailedPreCheckMessage(indexName)));
                return this;
            }
            $continuation.L$0 = context;
            $continuation.L$1 = indexName;
            $continuation.L$2 = clusterService;
            $continuation.L$3 = rolloverTarget;
            $continuation.Z$0 = skipRollover;
            $continuation.Z$1 = isDataStream;
            $continuation.label = 2;
            v3 = this.getIndexStatsOrUpdateInfo(context, (Continuation<? super IndicesStatsResponse>)$continuation);
            if (v3 == var33_4) {
                return var33_4;
            }
            ** GOTO lbl78
            {
                case 2: {
                    isDataStream = $continuation.Z$1;
                    skipRollover = $continuation.Z$0;
                    rolloverTarget = (String)$continuation.L$3;
                    clusterService = (ClusterService)$continuation.L$2;
                    indexName = (String)$continuation.L$1;
                    context = (StepContext)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v3 = $result;
lbl78:
                    // 2 sources

                    if ((statsResponse = (IndicesStatsResponse)v3) == null) {
                        return this;
                    }
                    indexCreationDate = clusterService.state().metadata().index(indexName).getCreationDate();
                    if (indexCreationDate == -1L) {
                        this.logger.warn(indexName + " had an indexCreationDate=-1L, cannot use for comparison");
                        v4 = TimeValue.timeValueMillis((long)0L);
                    } else {
                        v4 = TimeValue.timeValueMillis((long)(Instant.now().toEpochMilli() - indexCreationDate));
                    }
                    indexAgeTimeValue = v4;
                    v5 = statsResponse.getPrimaries().docs;
                    numDocs = v5 != null ? v5.getCount() : 0L;
                    v6 = statsResponse.getPrimaries().docs;
                    indexSize = new ByteSizeValue(v6 != null ? v6.getTotalSizeInBytes() : 0L);
                    v7 = statsResponse.getShards();
                    Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"getShards(...)");
                    $this$maxByOrNull$iv = v7;
                    $i$f$maxByOrNull = false;
                    if ($this$maxByOrNull$iv.length == 0) {
                        v8 = null;
                    } else {
                        maxElem$iv = $this$maxByOrNull$iv[0];
                        lastIndex$iv = ArraysKt.getLastIndex((Object[])$this$maxByOrNull$iv);
                        if (lastIndex$iv == 0) {
                            v8 = maxElem$iv;
                        } else {
                            it = (ShardStats)maxElem$iv;
                            $i$a$-maxByOrNull-AttemptRolloverStep$execute$largestPrimaryShard$1 = false;
                            v9 = it.getStats().docs;
                            maxValue$iv = v9 != null ? v9.getTotalSizeInBytes() : 0L;
                            i$iv = 1;
                            if (i$iv <= lastIndex$iv) {
                                while (true) {
                                    e$iv = $this$maxByOrNull$iv[i$iv];
                                    it = (ShardStats)e$iv;
                                    $i$a$-maxByOrNull-AttemptRolloverStep$execute$largestPrimaryShard$1 = false;
                                    v10 = it.getStats().docs;
                                    v11 = v$iv = v10 != null ? v10.getTotalSizeInBytes() : 0L;
                                    if (maxValue$iv < v$iv) {
                                        maxElem$iv = e$iv;
                                        maxValue$iv = v$iv;
                                    }
                                    if (i$iv == lastIndex$iv) break;
                                    ++i$iv;
                                }
                            }
                            v8 = maxElem$iv;
                        }
                    }
                    largestPrimaryShardSize = new ByteSizeValue((v12 = (largestPrimaryShard = (ShardStats)v8)) != null && (v12 = v12.getStats()) != null && (v12 = v12.docs) != null ? v12.getTotalSizeInBytes() : 0L);
                    v13 = var19_39 = new Pair[4];
                    v14 = 0;
                    v15 = this.action.getMinAge();
                    if (v15 != null) {
                        i$iv = v15;
                        var29_62 = v14;
                        var28_63 = v13;
                        $i$a$-let-AttemptRolloverStep$execute$conditions$1 = false;
                        v$iv = new Pair[]{TuplesKt.to((Object)"condition", (Object)it.toString()), TuplesKt.to((Object)"current", (Object)indexAgeTimeValue.toString()), TuplesKt.to((Object)"creationDate", (Object)Boxing.boxLong((long)indexCreationDate))};
                        var30_64 = TuplesKt.to((Object)"min_index_age", (Object)MapsKt.mapOf((Pair[])v$iv));
                        v13 = var28_63;
                        v14 = var29_62;
                        v16 = var30_64;
                    } else {
                        v16 = null;
                    }
                    v13[v14] = v16;
                    v17 = var19_39;
                    v18 = 1;
                    v19 = this.action.getMinDocs();
                    if (v19 != null) {
                        it = ((Number)v19).longValue();
                        var29_62 = v18;
                        var28_63 = v17;
                        $i$a$-let-AttemptRolloverStep$execute$conditions$2 = false;
                        var27_59 = new Pair[]{TuplesKt.to((Object)"condition", (Object)Boxing.boxLong((long)it)), TuplesKt.to((Object)"current", (Object)Boxing.boxLong((long)numDocs))};
                        var30_64 = TuplesKt.to((Object)"min_doc_count", (Object)MapsKt.mapOf((Pair[])var27_59));
                        v17 = var28_63;
                        v18 = var29_62;
                        v20 = var30_64;
                    } else {
                        v20 = null;
                    }
                    v17[v18] = v20;
                    v21 = var19_39;
                    v22 = 2;
                    v23 = this.action.getMinSize();
                    if (v23 != null) {
                        it = v23;
                        var29_62 = v22;
                        var28_63 = v21;
                        $i$a$-let-AttemptRolloverStep$execute$conditions$3 = false;
                        var25_56 = new Pair[]{TuplesKt.to((Object)"condition", (Object)it.toString()), TuplesKt.to((Object)"current", (Object)indexSize.toString())};
                        var30_64 = TuplesKt.to((Object)"min_size", (Object)MapsKt.mapOf((Pair[])var25_56));
                        v21 = var28_63;
                        v22 = var29_62;
                        v24 = var30_64;
                    } else {
                        v24 = null;
                    }
                    v21[v22] = v24;
                    v25 = var19_39;
                    v26 = 3;
                    v27 = this.action.getMinPrimaryShardSize();
                    if (v27 != null) {
                        it = v27;
                        var29_62 = v26;
                        var28_63 = v25;
                        $i$a$-let-AttemptRolloverStep$execute$conditions$4 = false;
                        var25_57 = new Pair[]{TuplesKt.to((Object)"condition", (Object)it.toString()), TuplesKt.to((Object)"current", (Object)largestPrimaryShardSize.toString()), TuplesKt.to((Object)"shard", (v28 = largestPrimaryShard) != null && (v28 = v28.getShardRouting()) != null ? Boxing.boxInt((int)v28.id()) : null)};
                        var30_64 = TuplesKt.to((Object)"min_primary_shard_size", (Object)MapsKt.mapOf((Pair[])var25_57));
                        v25 = var28_63;
                        v26 = var29_62;
                        v29 = var30_64;
                    } else {
                        v29 = null;
                    }
                    v25[v26] = v29;
                    conditions = MapsKt.toMap((Iterable)CollectionsKt.listOfNotNull((Object[])var19_39));
                    Intrinsics.checkNotNull((Object)indexAgeTimeValue);
                    if (!ManagedIndexUtils.evaluateConditions(this.action, indexAgeTimeValue, numDocs, indexSize, largestPrimaryShardSize)) break;
                    this.logger.info(indexName + " rollover conditions evaluated to true [indexCreationDate=" + indexCreationDate + ", numDocs=" + numDocs + ", indexSize=" + indexSize.getBytes() + ", primaryShardSize=" + largestPrimaryShardSize.getBytes() + "]");
                    $continuation.L$0 = context;
                    $continuation.L$1 = indexName;
                    $continuation.L$2 = clusterService;
                    $continuation.L$3 = rolloverTarget;
                    $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)statsResponse);
                    $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)indexAgeTimeValue);
                    $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)indexSize);
                    $continuation.L$7 = SpillingKt.nullOutSpilledVariable((Object)largestPrimaryShard);
                    $continuation.L$8 = SpillingKt.nullOutSpilledVariable((Object)largestPrimaryShardSize);
                    $continuation.L$9 = SpillingKt.nullOutSpilledVariable((Object)conditions);
                    $continuation.Z$0 = skipRollover;
                    $continuation.Z$1 = isDataStream;
                    $continuation.J$0 = indexCreationDate;
                    $continuation.J$1 = numDocs;
                    $continuation.label = 3;
                    v30 = this.executeRollover(context, rolloverTarget, isDataStream != false, conditions, (Continuation<? super Unit>)$continuation);
                    if (v30 == var33_4) {
                        return var33_4;
                    }
                    ** GOTO lbl231
                }
                case 3: {
                    numDocs = $continuation.J$1;
                    indexCreationDate = $continuation.J$0;
                    isDataStream = $continuation.Z$1;
                    skipRollover = $continuation.Z$0;
                    conditions = (Map)$continuation.L$9;
                    largestPrimaryShardSize = (ByteSizeValue)$continuation.L$8;
                    largestPrimaryShard = (ShardStats)$continuation.L$7;
                    indexSize = (ByteSizeValue)$continuation.L$6;
                    indexAgeTimeValue = (TimeValue)$continuation.L$5;
                    statsResponse = (IndicesStatsResponse)$continuation.L$4;
                    rolloverTarget = (String)$continuation.L$3;
                    clusterService = (ClusterService)$continuation.L$2;
                    indexName = (String)$continuation.L$1;
                    context = (StepContext)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v30 = $result;
lbl231:
                    // 2 sources

                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)context);
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)indexName);
                    $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)clusterService);
                    $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)rolloverTarget);
                    $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)statsResponse);
                    $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)indexAgeTimeValue);
                    $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)indexSize);
                    $continuation.L$7 = SpillingKt.nullOutSpilledVariable((Object)largestPrimaryShard);
                    $continuation.L$8 = SpillingKt.nullOutSpilledVariable((Object)largestPrimaryShardSize);
                    $continuation.L$9 = SpillingKt.nullOutSpilledVariable((Object)conditions);
                    $continuation.Z$0 = skipRollover;
                    $continuation.Z$1 = isDataStream;
                    $continuation.J$0 = indexCreationDate;
                    $continuation.J$1 = numDocs;
                    $continuation.label = 4;
                    v31 = this.copyAlias(clusterService, indexName, context.getClient(), rolloverTarget, context.getMetadata(), (Continuation<? super Unit>)$continuation);
                    if (v31 == var33_4) {
                        return var33_4;
                    }
                    break block35;
                }
                case 4: {
                    numDocs = $continuation.J$1;
                    indexCreationDate = $continuation.J$0;
                    isDataStream = $continuation.Z$1;
                    skipRollover = $continuation.Z$0;
                    conditions = (Map)$continuation.L$9;
                    largestPrimaryShardSize = (ByteSizeValue)$continuation.L$8;
                    largestPrimaryShard = (ShardStats)$continuation.L$7;
                    indexSize = (ByteSizeValue)$continuation.L$6;
                    indexAgeTimeValue = (TimeValue)$continuation.L$5;
                    statsResponse = (IndicesStatsResponse)$continuation.L$4;
                    rolloverTarget = (String)$continuation.L$3;
                    clusterService = (ClusterService)$continuation.L$2;
                    indexName = (String)$continuation.L$1;
                    context = (StepContext)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v31 = $result;
                    break block35;
                }
            }
            this.stepStatus = Step.StepStatus.CONDITION_NOT_MET;
            var19_39 = new Pair[]{TuplesKt.to((Object)"message", (Object)AttemptRolloverStep.Companion.getPendingMessage(indexName)), TuplesKt.to((Object)"conditions", (Object)conditions)};
            this.info = MapsKt.mapOf((Pair[])var19_39);
        }
        return this;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Pair<String, Boolean> getRolloverTargetOrUpdateInfo(StepContext context) {
        String rolloverTarget;
        IndexAbstraction indexAbstraction;
        String indexName = context.getMetadata().getIndex();
        Metadata metadata2 = context.getClusterService().state().metadata();
        IndexAbstraction indexAbstraction2 = indexAbstraction = (IndexAbstraction)metadata2.getIndicesLookup().get(indexName);
        boolean isDataStreamIndex = (indexAbstraction2 != null ? indexAbstraction2.getParentDataStream() : null) != null;
        if (isDataStreamIndex) {
            IndexAbstraction indexAbstraction3 = indexAbstraction;
            v2 = indexAbstraction3 != null && (indexAbstraction3 = indexAbstraction3.getParentDataStream()) != null ? indexAbstraction3.getName() : null;
        } else {
            IndexMetadata indexMetadata = metadata2.index(indexName);
            Intrinsics.checkNotNullExpressionValue((Object)indexMetadata, (String)"index(...)");
            v2 = rolloverTarget = org.opensearch.indexmanagement.indexstatemanagement.opensearchapi.OpenSearchExtensionsKt.getRolloverAlias(indexMetadata);
        }
        if (rolloverTarget == null) {
            String message = Companion.getFailedNoValidAliasMessage(indexName);
            this.logger.warn(message);
            this.stepStatus = Step.StepStatus.FAILED;
            this.info = MapsKt.mapOf((Pair)TuplesKt.to((Object)"message", (Object)message));
        }
        return TuplesKt.to((Object)rolloverTarget, (Object)isDataStreamIndex);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean preCheckIndexAlias(StepContext context, String alias) {
        String indexName = context.getMetadata().getIndex();
        Metadata metadata2 = context.getClusterService().state().getMetadata();
        Object object = metadata2.index(indexName);
        AliasMetadata indexAlias = object != null && (object = object.getAliases()) != null ? (AliasMetadata)object.get(alias) : null;
        this.logger.debug("Index {} has aliases {}", (Object)indexName, (Object)indexAlias);
        if (indexAlias == null) {
            return false;
        }
        Boolean isWriteIndex = indexAlias.writeIndex();
        if (!Intrinsics.areEqual((Object)isWriteIndex, (Object)true)) {
            List list;
            Object object2 = (IndexAbstraction)metadata2.getIndicesLookup().get(alias);
            if (object2 != null && (object2 = object2.getIndices()) != null) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = (Iterable)object2;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    IndexMetadata indexMetadata = (IndexMetadata)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getIndex());
                }
                list = (List)destination$iv$iv;
            } else {
                list = null;
            }
            List aliasIndices = list;
            this.logger.debug("Alias {} contains indices {}", (Object)alias, aliasIndices);
            if (aliasIndices != null && aliasIndices.size() > 1) {
                return false;
            }
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private final Object getIndexStatsOrUpdateInfo(StepContext context, Continuation<? super IndicesStatsResponse> $completion) {
        if (!($completion instanceof getIndexStatsOrUpdateInfo.1)) ** GOTO lbl-1000
        var24_3 = $completion;
        if ((var24_3.label & -2147483648) != 0) {
            var24_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ AttemptRolloverStep this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return AttemptRolloverStep.access$getIndexStatsOrUpdateInfo(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var25_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                indexName = context.getMetadata().getIndex();
                var5_7 = new String[]{indexName};
                statsRequest = ((IndicesStatsRequest)new IndicesStatsRequest().indices(var5_7)).clear().docs(true);
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)context);
                $continuation.L$1 = indexName;
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)statsRequest);
                $continuation.label = 1;
                v0 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)context.getClient().admin().indices(), (Function2)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, getIndexStatsOrUpdateInfo$lambda$6(org.opensearch.action.admin.indices.stats.IndicesStatsRequest org.opensearch.transport.client.IndicesAdminClient org.opensearch.core.action.ActionListener ), (Lorg/opensearch/transport/client/IndicesAdminClient;Lorg/opensearch/core/action/ActionListener;)Lkotlin/Unit;)((IndicesStatsRequest)statsRequest), $continuation);
                ** if (v0 != var25_5) goto lbl24
lbl23:
                // 1 sources

                return var25_5;
lbl24:
                // 1 sources

                ** GOTO lbl33
            }
            case 1: {
                statsRequest = (IndicesStatsRequest)$continuation.L$2;
                indexName = (String)$continuation.L$1;
                context = (StepContext)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl33:
                    // 2 sources

                    if ((statsResponse = (IndicesStatsResponse)v0).getStatus() == RestStatus.OK) {
                        return statsResponse;
                    }
                    message = AttemptRolloverStep.Companion.getFailedEvaluateMessage(indexName);
                    this.logger.warn(message + " - " + statsResponse.getStatus());
                    this.stepStatus = Step.StepStatus.FAILED;
                    var7_12 = new Pair[2];
                    var7_12[0] = TuplesKt.to((Object)"message", (Object)message);
                    v1 = statsResponse.getShardFailures();
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getShardFailures(...)");
                    var8_13 = v1;
                    var21_14 = "shard_failures";
                    var20_15 = 1;
                    var19_16 = var7_12;
                    var18_17 = this;
                    $i$f$map = false;
                    var10_19 = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(((void)$this$map$iv).length);
                    $i$f$mapTo = false;
                    for (void item$iv$iv : $this$mapTo$iv$iv) {
                        var16_25 = (DefaultShardOperationFailedException)item$iv$iv;
                        var22_27 = destination$iv$iv;
                        $i$a$-map-AttemptRolloverStep$getIndexStatsOrUpdateInfo$2 = false;
                        Intrinsics.checkNotNull((Object)it);
                        var22_27.add(OpenSearchExtensionsKt.getUsefulCauseString((DefaultShardOperationFailedException)it));
                    }
                    var22_27 = (List)destination$iv$iv;
                    var19_16[var20_15] = TuplesKt.to((Object)var21_14, (Object)var22_27);
                    var18_17.info = MapsKt.mapOf((Pair[])var7_12);
                }
                catch (RemoteTransportException e) {
                    v2 = ExceptionsHelper.unwrapCause((Throwable)e);
                    Intrinsics.checkNotNull((Object)v2, (String)"null cannot be cast to non-null type java.lang.Exception");
                    AttemptRolloverStep.handleException$default(this, indexName, (Exception)v2, null, null, 12, null);
                }
                catch (Exception e) {
                    AttemptRolloverStep.handleException$default(this, indexName, e, AttemptRolloverStep.Companion.getFailedEvaluateMessage(indexName), null, 8, null);
                }
                return null;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object executeRollover(StepContext context, String rolloverTarget, boolean isDataStream, Map<String, ? extends Map<String, ? extends Object>> conditions, Continuation<? super Unit> $completion) {
        if (!($completion instanceof executeRollover.1)) ** GOTO lbl-1000
        var12_6 = $completion;
        if ((var12_6.label & -2147483648) != 0) {
            var12_6.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                boolean Z$0;
                /* synthetic */ Object result;
                final /* synthetic */ AttemptRolloverStep this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return AttemptRolloverStep.access$executeRollover(this.this$0, null, null, false, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var13_8 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                indexName = context.getMetadata().getIndex();
                request = new RolloverRequest(rolloverTarget, null);
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)context);
                $continuation.L$1 = rolloverTarget;
                $continuation.L$2 = conditions;
                $continuation.L$3 = indexName;
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)request);
                $continuation.Z$0 = isDataStream;
                $continuation.label = 1;
                v0 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)context.getClient().admin().indices(), (Function2)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, executeRollover$lambda$8(org.opensearch.action.admin.indices.rollover.RolloverRequest org.opensearch.transport.client.IndicesAdminClient org.opensearch.core.action.ActionListener ), (Lorg/opensearch/transport/client/IndicesAdminClient;Lorg/opensearch/core/action/ActionListener;)Lkotlin/Unit;)((RolloverRequest)request), $continuation);
                ** if (v0 != var13_8) goto lbl26
lbl25:
                // 1 sources

                return var13_8;
lbl26:
                // 1 sources

                ** GOTO lbl38
            }
            case 1: {
                isDataStream = $continuation.Z$0;
                request = (RolloverRequest)$continuation.L$4;
                indexName = (String)$continuation.L$3;
                conditions = (Map)$continuation.L$2;
                rolloverTarget = (String)$continuation.L$1;
                context = (StepContext)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl38:
                    // 2 sources

                    if ((response = (RolloverResponse)v0).isAcknowledged()) {
                        message = isDataStream != false ? AttemptRolloverStep.Companion.getSuccessDataStreamRolloverMessage(rolloverTarget, indexName) : AttemptRolloverStep.Companion.getSuccessMessage(indexName);
                        this.newIndex = response.getNewIndex();
                        this.stepStatus = Step.StepStatus.COMPLETED;
                        var10_17 = new Pair[]{TuplesKt.to((Object)"message", (Object)message), conditions.isEmpty() != false ? null : TuplesKt.to((Object)"conditions", (Object)conditions)};
                        this.info = MapsKt.toMap((Iterable)CollectionsKt.listOfNotNull((Object[])var10_17));
                    } else {
                        if (isDataStream) {
                            v1 = AttemptRolloverStep.Companion.getFailedDataStreamRolloverMessage(rolloverTarget);
                        } else {
                            v2 = response.getNewIndex();
                            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getNewIndex(...)");
                            v1 = AttemptRolloverStep.Companion.getFailedAliasUpdateMessage(indexName, v2);
                        }
                        message = v1;
                        this.logger.warn(message);
                        this.stepStatus = Step.StepStatus.FAILED;
                        var10_18 = new Pair[]{TuplesKt.to((Object)"message", (Object)message), conditions.isEmpty() != false ? null : TuplesKt.to((Object)"conditions", (Object)conditions)};
                        this.info = MapsKt.toMap((Iterable)CollectionsKt.listOfNotNull((Object[])var10_18));
                    }
                }
                catch (RemoteTransportException e) {
                    v3 = ExceptionsHelper.unwrapCause((Throwable)e);
                    Intrinsics.checkNotNull((Object)v3, (String)"null cannot be cast to non-null type java.lang.Exception");
                    AttemptRolloverStep.handleException$default(this, indexName, (Exception)v3, null, null, 12, null);
                }
                catch (Exception e) {
                    AttemptRolloverStep.handleException$default(this, indexName, e, null, null, 12, null);
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object copyAlias(ClusterService clusterService, String indexName, Client client, String rolloverTarget, ManagedIndexMetaData metadata, Continuation<? super Unit> $completion) {
        if (!($completion instanceof copyAlias.1)) ** GOTO lbl-1000
        var19_7 = $completion;
        if ((var19_7.label & -2147483648) != 0) {
            var19_7.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                Object L$7;
                Object L$8;
                Object L$9;
                /* synthetic */ Object result;
                final /* synthetic */ AttemptRolloverStep this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return AttemptRolloverStep.access$copyAlias(this.this$0, null, null, null, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var20_9 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (!this.action.getCopyAlias()) {
                    return Unit.INSTANCE;
                }
                v0 = this.info;
                if (v0 == null || (v0 = v0.get("conditions")) == null) {
                    v1 = this.getContext();
                    v0 = conditions = v1 != null && (v1 = v1.getMetadata()) != null && (v1 = v1.getInfo()) != null ? v1.get("conditions") : null;
                }
                if ((v2 = this.newIndex) == null) {
                    v2 = metadata.getRolledOverIndexName();
                }
                if ((rolledOverIndexName = v2) == null) {
                    this.logger.error(indexName + " rolled over but cannot find the rolledOverIndexName to copy aliases to");
                    this.stepStatus = Step.StepStatus.COMPLETED;
                    var9_12 = new Pair[]{TuplesKt.to((Object)"message", (Object)AttemptRolloverStep.Companion.getCopyAliasRolledOverIndexNotFoundMessage(indexName)), conditions != null ? TuplesKt.to((Object)"conditions", (Object)conditions) : null};
                    this.info = MapsKt.toMap((Iterable)CollectionsKt.listOfNotNull((Object[])var9_12));
                    return Unit.INSTANCE;
                }
                aliasActions = new ArrayList<E>();
                aliases = clusterService.state().metadata().index(indexName).getAliases();
                Intrinsics.checkNotNull((Object)aliases);
                for (Map.Entry<K, V> alias : aliases.entrySet()) {
                    aliasName = (String)alias.getKey();
                    if (Intrinsics.areEqual((Object)aliasName, (Object)rolloverTarget)) continue;
                    aliasMetadata = (AliasMetadata)alias.getValue();
                    v3 = aliasMetadata.getFilter();
                    aliasAction = new IndicesAliasesRequest.AliasActions(IndicesAliasesRequest.AliasActions.Type.ADD).index(rolledOverIndexName).alias(aliasMetadata.getAlias()).filter(v3 != null ? v3.toString() : null).searchRouting(aliasMetadata.getSearchRouting()).indexRouting(aliasMetadata.getIndexRouting()).isHidden(aliasMetadata.isHidden());
                    Intrinsics.checkNotNull((Object)aliasAction);
                    aliasActions.add(aliasAction);
                }
                aliasReq = new IndicesAliasesRequest();
                $this$forEach$iv = aliasActions;
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    it = (IndicesAliasesRequest.AliasActions)element$iv;
                    $i$a$-forEach-AttemptRolloverStep$copyAlias$2 = false;
                    aliasReq.addAliasAction(it);
                }
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)clusterService);
                $continuation.L$1 = indexName;
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)client);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)rolloverTarget);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)metadata);
                $continuation.L$5 = conditions;
                $continuation.L$6 = rolledOverIndexName;
                $continuation.L$7 = SpillingKt.nullOutSpilledVariable((Object)aliasActions);
                $continuation.L$8 = SpillingKt.nullOutSpilledVariable((Object)aliases);
                $continuation.L$9 = SpillingKt.nullOutSpilledVariable((Object)aliasReq);
                $continuation.label = 1;
                v4 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)client.admin().indices(), (Function2)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, copyAlias$lambda$10(org.opensearch.action.admin.indices.alias.IndicesAliasesRequest org.opensearch.transport.client.IndicesAdminClient org.opensearch.core.action.ActionListener ), (Lorg/opensearch/transport/client/IndicesAdminClient;Lorg/opensearch/core/action/ActionListener;)Lkotlin/Unit;)((IndicesAliasesRequest)aliasReq), $continuation);
                ** if (v4 != var20_9) goto lbl64
lbl63:
                // 1 sources

                return var20_9;
lbl64:
                // 1 sources

                ** GOTO lbl80
            }
            case 1: {
                aliasReq = (IndicesAliasesRequest)$continuation.L$9;
                aliases = (Map)$continuation.L$8;
                aliasActions = (List)$continuation.L$7;
                rolledOverIndexName = (String)$continuation.L$6;
                conditions = $continuation.L$5;
                metadata = (ManagedIndexMetaData)$continuation.L$4;
                rolloverTarget = (String)$continuation.L$3;
                client = (Client)$continuation.L$2;
                indexName = (String)$continuation.L$1;
                clusterService = (ClusterService)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v4 = $result;
lbl80:
                    // 2 sources

                    if ((aliasRes = (AcknowledgedResponse)v4).isAcknowledged()) {
                        this.stepStatus = Step.StepStatus.COMPLETED;
                        var13_24 = new Pair[]{TuplesKt.to((Object)"message", (Object)AttemptRolloverStep.Companion.getSuccessCopyAliasMessage(indexName, rolledOverIndexName)), conditions != null ? TuplesKt.to((Object)"conditions", (Object)conditions) : null};
                        this.info = MapsKt.toMap((Iterable)CollectionsKt.listOfNotNull((Object[])var13_24));
                    } else {
                        this.stepStatus = Step.StepStatus.FAILED;
                        var13_25 = new Pair[]{TuplesKt.to((Object)"message", (Object)AttemptRolloverStep.Companion.getCopyAliasNotAckMessage(indexName, rolledOverIndexName)), conditions != null ? TuplesKt.to((Object)"conditions", (Object)conditions) : null};
                        this.info = MapsKt.toMap((Iterable)CollectionsKt.listOfNotNull((Object[])var13_25));
                    }
                }
                catch (IndexNotFoundException e) {
                    this.logger.error("Index not found while copying alias from " + indexName + " to " + rolledOverIndexName, (Throwable)e);
                    this.stepStatus = Step.StepStatus.FAILED;
                    var13_26 = new Pair[]{TuplesKt.to((Object)"message", (Object)AttemptRolloverStep.Companion.getCopyAliasIndexNotFoundMessage(rolledOverIndexName)), conditions != null ? TuplesKt.to((Object)"conditions", (Object)conditions) : null};
                    this.info = MapsKt.toMap((Iterable)CollectionsKt.listOfNotNull((Object[])var13_26));
                }
                catch (Exception e) {
                    this.handleException(indexName, e, AttemptRolloverStep.Companion.getFailedCopyAliasMessage(indexName, rolledOverIndexName), conditions);
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @NotNull
    public ManagedIndexMetaData getUpdatedManagedIndexMetadata(@NotNull ManagedIndexMetaData currentMetadata) {
        Intrinsics.checkNotNullParameter((Object)currentMetadata, (String)"currentMetadata");
        StepMetaData stepMetaData = new StepMetaData(this.getName(), this.getStepStartTime(currentMetadata).toEpochMilli(), this.stepStatus);
        boolean bl = Intrinsics.areEqual((Object)currentMetadata.getRolledOver(), (Object)true) ? true : this.stepStatus == Step.StepStatus.COMPLETED;
        String string = currentMetadata.getRolledOverIndexName() != null ? currentMetadata.getRolledOverIndexName() : this.newIndex;
        Map<String, ? extends Object> map = this.info;
        return ManagedIndexMetaData.copy$default((ManagedIndexMetaData)currentMetadata, null, null, null, null, null, null, (Boolean)bl, null, null, null, null, (StepMetaData)stepMetaData, null, map, null, (long)0L, (long)0L, (String)string, (int)120511, null);
    }

    private final void handleException(String indexName, Exception e, String message, Object conditions) {
        this.logger.error(message, (Throwable)e);
        this.stepStatus = Step.StepStatus.FAILED;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"message", (Object)message)};
        Map mutableInfo = MapsKt.mutableMapOf((Pair[])pairArray);
        String errorMessage = e.getMessage();
        if (errorMessage != null) {
            mutableInfo.put("cause", errorMessage);
        }
        if (conditions != null) {
            mutableInfo.put("conditions", conditions);
        }
        this.info = MapsKt.toMap((Map)mutableInfo);
    }

    static /* synthetic */ void handleException$default(AttemptRolloverStep attemptRolloverStep, String string, Exception exception, String string2, Object object, int n, Object object2) {
        if ((n & 4) != 0) {
            string2 = Companion.getFailedMessage(string);
        }
        if ((n & 8) != 0) {
            object = null;
        }
        attemptRolloverStep.handleException(string, exception, string2, object);
    }

    public boolean isIdempotent() {
        return true;
    }

    private static final Unit getIndexStatsOrUpdateInfo$lambda$6(IndicesStatsRequest $statsRequest, IndicesAdminClient $this$suspendUntil, ActionListener it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $this$suspendUntil.stats($statsRequest, it);
        return Unit.INSTANCE;
    }

    private static final Unit executeRollover$lambda$8(RolloverRequest $request, IndicesAdminClient $this$suspendUntil, ActionListener it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $this$suspendUntil.rolloverIndex($request, it);
        return Unit.INSTANCE;
    }

    private static final Unit copyAlias$lambda$10(IndicesAliasesRequest $aliasReq, IndicesAdminClient $this$suspendUntil, ActionListener it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $this$suspendUntil.aliases($aliasReq, it);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Object access$getIndexStatsOrUpdateInfo(AttemptRolloverStep $this, StepContext context, Continuation $completion) {
        return $this.getIndexStatsOrUpdateInfo(context, (Continuation<? super IndicesStatsResponse>)$completion);
    }

    public static final /* synthetic */ Object access$executeRollover(AttemptRolloverStep $this, StepContext context, String rolloverTarget, boolean isDataStream, Map conditions, Continuation $completion) {
        return $this.executeRollover(context, rolloverTarget, isDataStream, conditions, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$copyAlias(AttemptRolloverStep $this, ClusterService clusterService, String indexName, Client client, String rolloverTarget, ManagedIndexMetaData metadata2, Continuation $completion) {
        return $this.copyAlias(clusterService, indexName, client, rolloverTarget, metadata2, (Continuation<? super Unit>)$completion);
    }

    @kotlin.Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0015\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005J\u0016\u0010\b\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005J\u000e\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005J\u000e\u0010\f\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005J\u000e\u0010\r\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005J\u000e\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005J\u000e\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005J\u0016\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005J\u000e\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005J\u000e\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005J\u0016\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0005J\u0016\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005J\u0016\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005J\u0016\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005J\u0010\u0010\u0018\u001a\u00020\u00052\b\u0010\t\u001a\u0004\u0018\u00010\u0005J\u0010\u0010\u0019\u001a\u00020\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/step/rollover/AttemptRolloverStep$Companion;", "", "<init>", "()V", "name", "", "getFailedMessage", "index", "getFailedAliasUpdateMessage", "newIndex", "getFailedDataStreamRolloverMessage", "dataStream", "getFailedNoValidAliasMessage", "getFailedEvaluateMessage", "getPendingMessage", "getSuccessMessage", "getSuccessDataStreamRolloverMessage", "getFailedPreCheckMessage", "getSkipRolloverMessage", "getAlreadyRolledOverMessage", "alias", "getSuccessCopyAliasMessage", "getFailedCopyAliasMessage", "getCopyAliasNotAckMessage", "getCopyAliasIndexNotFoundMessage", "getCopyAliasRolledOverIndexNotFoundMessage", "opensearch-index-management"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getFailedMessage(@NotNull String index2) {
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            return "Failed to rollover index [index=" + index2 + "]";
        }

        @NotNull
        public final String getFailedAliasUpdateMessage(@NotNull String index2, @NotNull String newIndex) {
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            Intrinsics.checkNotNullParameter((Object)newIndex, (String)"newIndex");
            return "New index created, but failed to update alias [index=" + index2 + ", newIndex=" + newIndex + "]";
        }

        @NotNull
        public final String getFailedDataStreamRolloverMessage(@NotNull String dataStream) {
            Intrinsics.checkNotNullParameter((Object)dataStream, (String)"dataStream");
            return "Failed to rollover data stream [data_stream=" + dataStream + "]";
        }

        @NotNull
        public final String getFailedNoValidAliasMessage(@NotNull String index2) {
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            return "Missing rollover_alias index setting [index=" + index2 + "]";
        }

        @NotNull
        public final String getFailedEvaluateMessage(@NotNull String index2) {
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            return "Failed to evaluate conditions for rollover [index=" + index2 + "]";
        }

        @NotNull
        public final String getPendingMessage(@NotNull String index2) {
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            return "Pending rollover of index [index=" + index2 + "]";
        }

        @NotNull
        public final String getSuccessMessage(@NotNull String index2) {
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            return "Successfully rolled over index [index=" + index2 + "]";
        }

        @NotNull
        public final String getSuccessDataStreamRolloverMessage(@NotNull String dataStream, @NotNull String index2) {
            Intrinsics.checkNotNullParameter((Object)dataStream, (String)"dataStream");
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            return "Successfully rolled over data stream [data_stream=" + dataStream + " index=" + index2 + "]";
        }

        @NotNull
        public final String getFailedPreCheckMessage(@NotNull String index2) {
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            return "Missing alias or not the write index when rollover [index=" + index2 + "]";
        }

        @NotNull
        public final String getSkipRolloverMessage(@NotNull String index2) {
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            return "Skipped rollover action for [index=" + index2 + "]";
        }

        @NotNull
        public final String getAlreadyRolledOverMessage(@NotNull String index2, @NotNull String alias) {
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            Intrinsics.checkNotNullParameter((Object)alias, (String)"alias");
            return "This index has already been rolled over using this alias, treating as a success [index=" + index2 + ", alias=" + alias + "]";
        }

        @NotNull
        public final String getSuccessCopyAliasMessage(@NotNull String index2, @NotNull String newIndex) {
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            Intrinsics.checkNotNullParameter((Object)newIndex, (String)"newIndex");
            return "Successfully rolled over and copied alias from [index=" + index2 + "] to [index=" + newIndex + "]";
        }

        @NotNull
        public final String getFailedCopyAliasMessage(@NotNull String index2, @NotNull String newIndex) {
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            Intrinsics.checkNotNullParameter((Object)newIndex, (String)"newIndex");
            return "Successfully rolled over but failed to copy alias from [index=" + index2 + "] to [index=" + newIndex + "]";
        }

        @NotNull
        public final String getCopyAliasNotAckMessage(@NotNull String index2, @NotNull String newIndex) {
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            Intrinsics.checkNotNullParameter((Object)newIndex, (String)"newIndex");
            return "Successfully rolled over but copy alias from [index=" + index2 + "] to [index=" + newIndex + "] is not acknowledged";
        }

        @NotNull
        public final String getCopyAliasIndexNotFoundMessage(@Nullable String newIndex) {
            return "Successfully rolled over but new index [index=" + newIndex + "] not found during copy alias";
        }

        @NotNull
        public final String getCopyAliasRolledOverIndexNotFoundMessage(@Nullable String index2) {
            return "Successfully rolled over [index=" + index2 + "] but ISM cannot find rolled over index from metadata to copy aliases to, please manually copy";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

