/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.pagination;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hibernate.dialect.pagination.OffsetFetchLimitHandler;

public class SQLServer2012LimitHandler
extends OffsetFetchLimitHandler {
    public static final SQLServer2012LimitHandler INSTANCE = new SQLServer2012LimitHandler();

    public SQLServer2012LimitHandler() {
        super(true);
    }

    @Override
    void begin(String sql, StringBuilder offsetFetch, boolean hasFirstRow, boolean hasMaxRows) {
        if (Keyword.ORDER_BY.rootOffset(sql) <= 0) {
            offsetFetch.append(" order by ");
            int from = Keyword.FROM.rootOffset(sql);
            if (from > 0) {
                offsetFetch.append("@@version");
            } else {
                offsetFetch.append("1");
            }
        }
        if (!hasFirstRow) {
            offsetFetch.append(" offset 0 rows");
        }
    }

    private static enum Keyword {
        SELECT("select(\\s+(distinct|all))?"),
        FROM("from"),
        ORDER_BY("order\\s+by"),
        AS("as"),
        WITH("with");

        Pattern pattern;

        private Keyword(String keyword) {
            this.pattern = Pattern.compile("^\\b" + keyword + "\\b", 2);
        }

        int rootOffset(String sql) {
            Matcher matcher = this.pattern.matcher(sql).useTransparentBounds(true);
            int depth = 0;
            boolean quoted = false;
            boolean doubleQuoted = false;
            int offset = 0;
            int end = sql.length();
            while (offset < end) {
                int nextQuote = sql.indexOf(39, offset);
                if (nextQuote < 0) {
                    nextQuote = end;
                }
                if (!quoted) {
                    block8: for (int index = offset; index < nextQuote; ++index) {
                        switch (sql.charAt(index)) {
                            case '(': {
                                ++depth;
                                continue block8;
                            }
                            case ')': {
                                --depth;
                                continue block8;
                            }
                            case '\"': {
                                doubleQuoted = !doubleQuoted;
                                continue block8;
                            }
                            case '[': {
                                doubleQuoted = true;
                                continue block8;
                            }
                            case ']': {
                                doubleQuoted = false;
                                continue block8;
                            }
                            default: {
                                if (depth != 0 || doubleQuoted) continue block8;
                                matcher.region(index, nextQuote);
                                if (!matcher.find()) continue block8;
                                return index;
                            }
                        }
                    }
                }
                quoted = !quoted;
                offset = nextQuote + 1;
            }
            return 0;
        }
    }
}

