/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal;

import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.TimerTask;
import java.util.TreeMap;
import jdk.jfr.Configuration;
import jdk.jfr.FlightRecorderListener;
import jdk.jfr.Recording;
import jdk.jfr.RecordingState;
import jdk.jfr.internal.ChunkInputStream;
import jdk.jfr.internal.ChunksChannel;
import jdk.jfr.internal.LogLevel;
import jdk.jfr.internal.LogTag;
import jdk.jfr.internal.Logger;
import jdk.jfr.internal.MetadataRepository;
import jdk.jfr.internal.OldObjectSample;
import jdk.jfr.internal.PlatformRecorder;
import jdk.jfr.internal.RepositoryChunk;
import jdk.jfr.internal.SecuritySupport;
import jdk.jfr.internal.Utils;
import jdk.jfr.internal.WriteableUserPath;

public final class PlatformRecording
implements AutoCloseable {
    private final PlatformRecorder recorder;
    private final long id;
    private Map<String, String> settings = new LinkedHashMap<String, String>();
    private Duration duration;
    private Duration maxAge;
    private long maxSize;
    private WriteableUserPath destination;
    private boolean toDisk = true;
    private String name;
    private boolean dumpOnExit;
    private SecuritySupport.SafePath dumpOnExitDirectory = new SecuritySupport.SafePath(".");
    private Instant stopTime;
    private Instant startTime;
    private RecordingState state = RecordingState.NEW;
    private long size;
    private final LinkedList<RepositoryChunk> chunks = new LinkedList();
    private volatile Recording recording;
    private TimerTask stopTask;
    private TimerTask startTask;
    private AccessControlContext noDestinationDumpOnExitAccessControlContext = AccessController.getContext();
    private boolean shuoldWriteActiveRecordingEvent = true;

    PlatformRecording(PlatformRecorder platformRecorder, long l) {
        this.id = l;
        this.recorder = platformRecorder;
        this.name = String.valueOf(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        RecordingState recordingState;
        RecordingState recordingState2;
        PlatformRecorder platformRecorder = this.recorder;
        synchronized (platformRecorder) {
            recordingState2 = this.getState();
            if (!Utils.isBefore(this.state, RecordingState.RUNNING)) {
                throw new IllegalStateException("Recording can only be started once.");
            }
            if (this.startTask != null) {
                this.startTask.cancel();
                this.startTask = null;
                this.startTime = null;
            }
            this.recorder.start(this);
            Logger.log(LogTag.JFR, LogLevel.INFO, () -> {
                String string;
                StringJoiner stringJoiner = new StringJoiner(", ");
                if (!this.toDisk) {
                    stringJoiner.add("disk=false");
                }
                if (this.maxAge != null) {
                    stringJoiner.add("maxage=" + Utils.formatTimespan(this.maxAge, ""));
                }
                if (this.maxSize != 0L) {
                    stringJoiner.add("maxsize=" + Utils.formatBytesCompact(this.maxSize));
                }
                if (this.dumpOnExit) {
                    stringJoiner.add("dumponexit=true");
                }
                if (this.duration != null) {
                    stringJoiner.add("duration=" + Utils.formatTimespan(this.duration, ""));
                }
                if (this.destination != null) {
                    stringJoiner.add("filename=" + this.destination.getRealPathText());
                }
                if ((string = stringJoiner.toString()).length() != 0) {
                    string = "{" + string + "}";
                }
                return "Started recording \"" + this.getName() + "\" (" + this.getId() + ") " + string;
            });
            recordingState = this.getState();
        }
        this.notifyIfStateChanged(recordingState2, recordingState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stop(String string) {
        RecordingState recordingState;
        RecordingState recordingState2;
        Object object = this.recorder;
        synchronized (object) {
            recordingState2 = this.getState();
            if (this.stopTask != null) {
                this.stopTask.cancel();
                this.stopTask = null;
            }
            this.recorder.stop(this);
            String string2 = string == null ? "" : ". Reason \"" + string + "\".";
            Logger.log(LogTag.JFR, LogLevel.INFO, "Stopped recording \"" + this.getName() + "\" (" + this.getId() + ")" + string2);
            this.stopTime = Instant.now();
            recordingState = this.getState();
        }
        object = this.getDestination();
        if (object != null) {
            try {
                this.dumpStopped((WriteableUserPath)object);
                Logger.log(LogTag.JFR, LogLevel.INFO, "Wrote recording \"" + this.getName() + "\" (" + this.getId() + ") to " + ((WriteableUserPath)object).getRealPathText());
                this.notifyIfStateChanged(recordingState, recordingState2);
                this.close();
            }
            catch (IOException iOException) {}
        } else {
            this.notifyIfStateChanged(recordingState, recordingState2);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleStart(Duration duration) {
        PlatformRecorder platformRecorder = this.recorder;
        synchronized (platformRecorder) {
            this.ensureOkForSchedule();
            this.startTime = Instant.now().plus(duration);
            LocalDateTime localDateTime = LocalDateTime.now().plus(duration);
            this.setState(RecordingState.DELAYED);
            this.startTask = this.createStartTask();
            this.recorder.getTimer().schedule(this.startTask, duration.toMillis());
            Logger.log(LogTag.JFR, LogLevel.INFO, "Scheduled recording \"" + this.getName() + "\" (" + this.getId() + ") to start at " + localDateTime);
        }
    }

    private void ensureOkForSchedule() {
        if (this.getState() != RecordingState.NEW) {
            throw new IllegalStateException("Only a new recoridng can be scheduled for start");
        }
    }

    private TimerTask createStartTask() {
        return new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                PlatformRecorder platformRecorder = PlatformRecording.this.recorder;
                synchronized (platformRecorder) {
                    if (PlatformRecording.this.getState() != RecordingState.DELAYED) {
                        return;
                    }
                    PlatformRecording.this.start();
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scheduleStart(Instant instant) {
        PlatformRecorder platformRecorder = this.recorder;
        synchronized (platformRecorder) {
            this.ensureOkForSchedule();
            this.startTime = instant;
            this.setState(RecordingState.DELAYED);
            this.startTask = this.createStartTask();
            this.recorder.getTimer().schedule(this.startTask, instant.toEpochMilli());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getSettings() {
        PlatformRecorder platformRecorder = this.recorder;
        synchronized (platformRecorder) {
            return this.settings;
        }
    }

    public long getSize() {
        return this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Instant getStopTime() {
        PlatformRecorder platformRecorder = this.recorder;
        synchronized (platformRecorder) {
            return this.stopTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Instant getStartTime() {
        PlatformRecorder platformRecorder = this.recorder;
        synchronized (platformRecorder) {
            return this.startTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getMaxSize() {
        PlatformRecorder platformRecorder = this.recorder;
        synchronized (platformRecorder) {
            return this.maxSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Duration getMaxAge() {
        PlatformRecorder platformRecorder = this.recorder;
        synchronized (platformRecorder) {
            return this.maxAge;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getName() {
        PlatformRecorder platformRecorder = this.recorder;
        synchronized (platformRecorder) {
            return this.name;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecordingState getState() {
        PlatformRecorder platformRecorder = this.recorder;
        synchronized (platformRecorder) {
            return this.state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        RecordingState recordingState;
        RecordingState recordingState2;
        PlatformRecorder platformRecorder = this.recorder;
        synchronized (platformRecorder) {
            recordingState2 = this.getState();
            if (RecordingState.CLOSED != this.getState()) {
                if (this.startTask != null) {
                    this.startTask.cancel();
                    this.startTask = null;
                }
                this.recorder.finish(this);
                for (RepositoryChunk repositoryChunk : this.chunks) {
                    this.removed(repositoryChunk);
                }
                this.chunks.clear();
                this.setState(RecordingState.CLOSED);
                Logger.log(LogTag.JFR, LogLevel.INFO, "Closed recording \"" + this.getName() + "\" (" + this.getId() + ")");
            }
            recordingState = this.getState();
        }
        this.notifyIfStateChanged(recordingState, recordingState2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PlatformRecording newSnapshotClone(String string, Boolean bl) throws IOException {
        if (!Thread.holdsLock(this.recorder)) {
            throw new InternalError("Caller must have recorder lock");
        }
        RecordingState recordingState = this.getState();
        if (recordingState == RecordingState.CLOSED) {
            throw new IOException("Recording \"" + this.name + "\" (id=" + this.id + ") has been closed, no contents to write");
        }
        if (recordingState == RecordingState.DELAYED || recordingState == RecordingState.NEW) {
            throw new IOException("Recording \"" + this.name + "\" (id=" + this.id + ") has not started, no contents to write");
        }
        if (recordingState == RecordingState.STOPPED) {
            PlatformRecording platformRecording = this.recorder.newTemporaryRecording();
            for (RepositoryChunk repositoryChunk : this.chunks) {
                platformRecording.add(repositoryChunk);
            }
            return platformRecording;
        }
        PlatformRecording platformRecording = this.recorder.newTemporaryRecording();
        platformRecording.setShouldWriteActiveRecordingEvent(false);
        platformRecording.setName(this.getName());
        platformRecording.setToDisk(true);
        if (!this.isToDisk()) {
            platformRecording.start();
        } else {
            for (RepositoryChunk repositoryChunk : this.chunks) {
                platformRecording.add(repositoryChunk);
            }
            platformRecording.setState(RecordingState.RUNNING);
            platformRecording.setStartTime(this.getStartTime());
        }
        if (bl == null) {
            platformRecording.setSettings(this.getSettings());
            platformRecording.stop(string);
        } else {
            MetadataRepository metadataRepository = MetadataRepository.getInstance();
            synchronized (metadataRepository) {
                platformRecording.setSettings(OldObjectSample.createSettingsForSnapshot(this, bl));
                platformRecording.stop(string);
            }
        }
        return platformRecording;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isToDisk() {
        PlatformRecorder platformRecorder = this.recorder;
        synchronized (platformRecorder) {
            return this.toDisk;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxSize(long l) {
        PlatformRecorder platformRecorder = this.recorder;
        synchronized (platformRecorder) {
            if (this.getState() == RecordingState.CLOSED) {
                throw new IllegalStateException("Can't set max age when recording is closed");
            }
            this.maxSize = l;
            this.trimToSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDestination(WriteableUserPath writeableUserPath) throws IOException {
        PlatformRecorder platformRecorder = this.recorder;
        synchronized (platformRecorder) {
            if (Utils.isState(this.getState(), RecordingState.STOPPED, RecordingState.CLOSED)) {
                throw new IllegalStateException("Destination can't be set on a recording that has been stopped/closed");
            }
            this.destination = writeableUserPath;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WriteableUserPath getDestination() {
        PlatformRecorder platformRecorder = this.recorder;
        synchronized (platformRecorder) {
            return this.destination;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setState(RecordingState recordingState) {
        PlatformRecorder platformRecorder = this.recorder;
        synchronized (platformRecorder) {
            this.state = recordingState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setStartTime(Instant instant) {
        PlatformRecorder platformRecorder = this.recorder;
        synchronized (platformRecorder) {
            this.startTime = instant;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setStopTime(Instant instant) {
        PlatformRecorder platformRecorder = this.recorder;
        synchronized (platformRecorder) {
            this.stopTime = instant;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getId() {
        PlatformRecorder platformRecorder = this.recorder;
        synchronized (platformRecorder) {
            return this.id;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setName(String string) {
        PlatformRecorder platformRecorder = this.recorder;
        synchronized (platformRecorder) {
            this.ensureNotClosed();
            this.name = string;
        }
    }

    private void ensureNotClosed() {
        if (this.getState() == RecordingState.CLOSED) {
            throw new IllegalStateException("Can't change name on a closed recording");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDumpOnExit(boolean bl) {
        PlatformRecorder platformRecorder = this.recorder;
        synchronized (platformRecorder) {
            this.dumpOnExit = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getDumpOnExit() {
        PlatformRecorder platformRecorder = this.recorder;
        synchronized (platformRecorder) {
            return this.dumpOnExit;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setToDisk(boolean bl) {
        PlatformRecorder platformRecorder = this.recorder;
        synchronized (platformRecorder) {
            if (!Utils.isState(this.getState(), RecordingState.NEW, RecordingState.DELAYED)) {
                throw new IllegalStateException("Recording option disk can't be changed after recording has started");
            }
            this.toDisk = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSetting(String string, String string2) {
        PlatformRecorder platformRecorder = this.recorder;
        synchronized (platformRecorder) {
            this.settings.put(string, string2);
            if (this.getState() == RecordingState.RUNNING) {
                this.recorder.updateSettings();
            }
        }
    }

    public void setSettings(Map<String, String> map) {
        this.setSettings(map, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSettings(Map<String, String> map, boolean bl) {
        Object object;
        if (Logger.shouldLog(LogTag.JFR_SETTING, LogLevel.INFO) && bl) {
            object = new TreeMap<String, String>(map);
            Logger.log(LogTag.JFR_SETTING, LogLevel.INFO, "New settings for recording \"" + this.getName() + "\" (" + this.getId() + ")");
            for (Map.Entry entry : ((TreeMap)object).entrySet()) {
                String string = (String)entry.getKey() + "=\"" + (String)entry.getValue() + "\"";
                Logger.log(LogTag.JFR_SETTING, LogLevel.INFO, string);
            }
        }
        object = this.recorder;
        synchronized (object) {
            this.settings = new LinkedHashMap<String, String>(map);
            if (this.getState() == RecordingState.RUNNING && bl) {
                this.recorder.updateSettings();
            }
        }
    }

    private void notifyIfStateChanged(RecordingState recordingState, RecordingState recordingState2) {
        if (recordingState2 == recordingState) {
            return;
        }
        for (FlightRecorderListener flightRecorderListener : PlatformRecorder.getListeners()) {
            try {
                flightRecorderListener.recordingStateChanged(this.getRecording());
            }
            catch (RuntimeException runtimeException) {
                Logger.log(LogTag.JFR, LogLevel.WARN, "Error notifying recorder listener:" + runtimeException.getMessage());
            }
        }
    }

    public void setRecording(Recording recording) {
        this.recording = recording;
    }

    public Recording getRecording() {
        return this.recording;
    }

    public String toString() {
        return this.getName() + " (id=" + this.getId() + ") " + (Object)((Object)this.getState());
    }

    public void setConfiguration(Configuration configuration) {
        this.setSettings(configuration.getSettings());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxAge(Duration duration) {
        PlatformRecorder platformRecorder = this.recorder;
        synchronized (platformRecorder) {
            if (this.getState() == RecordingState.CLOSED) {
                throw new IllegalStateException("Can't set max age when recording is closed");
            }
            this.maxAge = duration;
            if (duration != null) {
                this.trimToAge(Instant.now().minus(duration));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void appendChunk(RepositoryChunk repositoryChunk) {
        if (!repositoryChunk.isFinished()) {
            throw new Error("not finished chunk " + repositoryChunk.getStartTime());
        }
        PlatformRecorder platformRecorder = this.recorder;
        synchronized (platformRecorder) {
            if (!this.toDisk) {
                return;
            }
            if (this.maxAge != null) {
                this.trimToAge(repositoryChunk.getEndTime().minus(this.maxAge));
            }
            this.chunks.addLast(repositoryChunk);
            this.added(repositoryChunk);
            this.trimToSize();
        }
    }

    private void trimToSize() {
        if (this.maxSize == 0L) {
            return;
        }
        while (this.size > this.maxSize && this.chunks.size() > 1) {
            RepositoryChunk repositoryChunk = this.chunks.removeFirst();
            this.removed(repositoryChunk);
        }
    }

    private void trimToAge(Instant instant) {
        while (!this.chunks.isEmpty()) {
            RepositoryChunk repositoryChunk = this.chunks.peek();
            if (repositoryChunk.getEndTime().isAfter(instant)) {
                return;
            }
            this.chunks.removeFirst();
            this.removed(repositoryChunk);
        }
    }

    void add(RepositoryChunk repositoryChunk) {
        this.chunks.add(repositoryChunk);
        this.added(repositoryChunk);
    }

    private void added(RepositoryChunk repositoryChunk) {
        repositoryChunk.use();
        this.size += repositoryChunk.getSize();
        Logger.log(LogTag.JFR, LogLevel.DEBUG, () -> "Recording \"" + this.name + "\" (" + this.id + ") added chunk " + repositoryChunk.toString() + ", current size=" + this.size);
    }

    private void removed(RepositoryChunk repositoryChunk) {
        this.size -= repositoryChunk.getSize();
        Logger.log(LogTag.JFR, LogLevel.DEBUG, () -> "Recording \"" + this.name + "\" (" + this.id + ") removed chunk " + repositoryChunk.toString() + ", current size=" + this.size);
        repositoryChunk.release();
    }

    public List<RepositoryChunk> getChunks() {
        return this.chunks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream open(Instant instant, Instant instant2) throws IOException {
        PlatformRecorder platformRecorder = this.recorder;
        synchronized (platformRecorder) {
            if (this.getState() != RecordingState.STOPPED) {
                throw new IOException("Recording must be stopped before it can be read.");
            }
            ArrayList<RepositoryChunk> arrayList = new ArrayList<RepositoryChunk>();
            for (RepositoryChunk repositoryChunk : this.chunks) {
                if (!repositoryChunk.isFinished()) continue;
                Instant instant3 = repositoryChunk.getStartTime();
                Instant instant4 = repositoryChunk.getEndTime();
                if (instant != null && instant4.isBefore(instant) || instant2 != null && instant3.isAfter(instant2)) continue;
                arrayList.add(repositoryChunk);
            }
            if (arrayList.isEmpty()) {
                return null;
            }
            return new ChunkInputStream(arrayList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Duration getDuration() {
        PlatformRecorder platformRecorder = this.recorder;
        synchronized (platformRecorder) {
            return this.duration;
        }
    }

    void setInternalDuration(Duration duration) {
        this.duration = duration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDuration(Duration duration) {
        PlatformRecorder platformRecorder = this.recorder;
        synchronized (platformRecorder) {
            if (Utils.isState(this.getState(), RecordingState.STOPPED, RecordingState.CLOSED)) {
                throw new IllegalStateException("Duration can't be set after a recording has been stopped/closed");
            }
            this.setInternalDuration(duration);
            if (this.getState() != RecordingState.NEW) {
                this.updateTimer();
            }
        }
    }

    void updateTimer() {
        if (this.stopTask != null) {
            this.stopTask.cancel();
            this.stopTask = null;
        }
        if (this.getState() == RecordingState.CLOSED) {
            return;
        }
        if (this.duration != null) {
            this.stopTask = this.createStopTask();
            this.recorder.getTimer().schedule(this.stopTask, new Date(this.startTime.plus(this.duration).toEpochMilli()));
        }
    }

    TimerTask createStopTask() {
        return new TimerTask(){

            @Override
            public void run() {
                try {
                    PlatformRecording.this.stop("End of duration reached");
                }
                catch (Throwable throwable) {
                    Logger.log(LogTag.JFR, LogLevel.ERROR, "Could not stop recording.");
                }
            }
        };
    }

    public Recording newCopy(boolean bl) {
        return this.recorder.newCopy(this, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setStopTask(TimerTask timerTask) {
        PlatformRecorder platformRecorder = this.recorder;
        synchronized (platformRecorder) {
            this.stopTask = timerTask;
        }
    }

    void clearDestination() {
        this.destination = null;
    }

    public AccessControlContext getNoDestinationDumpOnExitAccessControlContext() {
        return this.noDestinationDumpOnExitAccessControlContext;
    }

    void setShouldWriteActiveRecordingEvent(boolean bl) {
        this.shuoldWriteActiveRecordingEvent = bl;
    }

    boolean shouldWriteMetadataEvent() {
        return this.shuoldWriteActiveRecordingEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(WriteableUserPath writeableUserPath) throws IOException {
        PlatformRecorder platformRecorder = this.recorder;
        synchronized (platformRecorder) {
            try (PlatformRecording platformRecording = this.newSnapshotClone("Dumped by user", null);){
                platformRecording.dumpStopped(writeableUserPath);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpStopped(WriteableUserPath writeableUserPath) throws IOException {
        PlatformRecorder platformRecorder = this.recorder;
        synchronized (platformRecorder) {
            writeableUserPath.doPriviligedIO(() -> {
                try (ChunksChannel chunksChannel = new ChunksChannel(this.chunks);
                     FileChannel fileChannel = FileChannel.open(writeableUserPath.getReal(), StandardOpenOption.WRITE, StandardOpenOption.APPEND);){
                    long l = chunksChannel.transferTo(fileChannel);
                    Logger.log(LogTag.JFR, LogLevel.INFO, "Transferred " + l + " bytes from the disk repository");
                    if (l != 0L) {
                        fileChannel.force(true);
                    }
                }
                return null;
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filter(Instant instant, Instant instant2, Long l) {
        PlatformRecorder platformRecorder = this.recorder;
        synchronized (platformRecorder) {
            List<RepositoryChunk> list = PlatformRecording.removeAfter(instant2, PlatformRecording.removeBefore(instant, new ArrayList<RepositoryChunk>(this.chunks)));
            if (l != null) {
                list = instant != null && instant2 == null ? PlatformRecording.reduceFromBeginning(l, list) : PlatformRecording.reduceFromEnd(l, list);
            }
            int n = 0;
            for (RepositoryChunk repositoryChunk : list) {
                n = (int)((long)n + repositoryChunk.getSize());
                repositoryChunk.use();
            }
            this.size = n;
            for (RepositoryChunk repositoryChunk : this.chunks) {
                repositoryChunk.release();
            }
            this.chunks.clear();
            this.chunks.addAll(list);
        }
    }

    private static List<RepositoryChunk> removeBefore(Instant instant, List<RepositoryChunk> list) {
        if (instant == null) {
            return list;
        }
        ArrayList<RepositoryChunk> arrayList = new ArrayList<RepositoryChunk>(list.size());
        for (RepositoryChunk repositoryChunk : list) {
            if (repositoryChunk.getEndTime().isBefore(instant)) continue;
            arrayList.add(repositoryChunk);
        }
        return arrayList;
    }

    private static List<RepositoryChunk> removeAfter(Instant instant, List<RepositoryChunk> list) {
        if (instant == null) {
            return list;
        }
        ArrayList<RepositoryChunk> arrayList = new ArrayList<RepositoryChunk>(list.size());
        for (RepositoryChunk repositoryChunk : list) {
            if (repositoryChunk.getStartTime().isAfter(instant)) continue;
            arrayList.add(repositoryChunk);
        }
        return arrayList;
    }

    private static List<RepositoryChunk> reduceFromBeginning(Long l, List<RepositoryChunk> list) {
        if (l == null || list.isEmpty()) {
            return list;
        }
        ArrayList<RepositoryChunk> arrayList = new ArrayList<RepositoryChunk>(list.size());
        long l2 = 0L;
        for (RepositoryChunk repositoryChunk : list) {
            if ((l2 += repositoryChunk.getSize()) > l) break;
            arrayList.add(repositoryChunk);
        }
        if (arrayList.isEmpty()) {
            arrayList.add(list.get(0));
        }
        return arrayList;
    }

    private static List<RepositoryChunk> reduceFromEnd(Long l, List<RepositoryChunk> list) {
        Collections.reverse(list);
        List<RepositoryChunk> list2 = PlatformRecording.reduceFromBeginning(l, list);
        Collections.reverse(list2);
        return list2;
    }

    public void setDumpOnExitDirectory(SecuritySupport.SafePath safePath) {
        this.dumpOnExitDirectory = safePath;
    }

    public SecuritySupport.SafePath getDumpOnExitDirectory() {
        return this.dumpOnExitDirectory;
    }
}

