/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.extensibility;

import groovy.lang.Closure;
import groovy.lang.MissingPropertyException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileSystemLocationProperty;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.internal.IConventionAware;
import org.gradle.api.internal.file.FileSystemLocationPropertyInternal;
import org.gradle.api.internal.provider.DefaultProvider;
import org.gradle.api.provider.HasMultipleValues;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.SupportsConvention;
import org.gradle.internal.Cast;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.deprecation.DocumentedFailure;
import org.gradle.internal.reflect.JavaPropertyReflectionUtil;
import org.jspecify.annotations.Nullable;

public class ConventionAwareHelper
implements ConventionMapping {
    private final IConventionAware _source;
    private final Set<String> _propertyNames;
    private final Set<String> _ineligiblePropertyNames;
    private final Map<String, MappedPropertyImpl> _mappings = new HashMap<String, MappedPropertyImpl>();

    public ConventionAwareHelper(IConventionAware source) {
        this._source = source;
        this._propertyNames = JavaPropertyReflectionUtil.propertyNames((Object)source);
        this._ineligiblePropertyNames = new HashSet<String>();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ConventionMapping.MappedProperty map(String propertyName, MappedPropertyImpl mapping) {
        if (!this._propertyNames.contains(propertyName)) {
            throw new InvalidUserDataException("You can't map a property that does not exist: propertyName=" + propertyName);
        }
        if (this._ineligiblePropertyNames.contains(propertyName)) {
            SupportsConvention target;
            Class<?> sourceType = this._source.getClass();
            Method getter = JavaPropertyReflectionUtil.findGetterMethod(sourceType, (String)propertyName);
            if (getter == null || !SupportsConvention.class.isAssignableFrom(getter.getReturnType())) throw ((DocumentedFailure.Builder)DocumentedFailure.builder().withSummary("Using internal convention mapping with a Provider backed property.").withUpgradeGuideSection(7, "convention_mapping")).build();
            try {
                target = (SupportsConvention)Cast.uncheckedNonnullCast((Object)getter.invoke((Object)this._source, new Object[0]));
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new IllegalStateException(String.format("Could not access property %s.%s", sourceType.getSimpleName(), propertyName), e);
            }
            if (this.mapConventionOn(target, mapping)) return mapping;
            throw new IllegalStateException(String.format("Unexpected convention-supporting type %s used in property %s.%s", getter.getReturnType().getName(), sourceType.getSimpleName(), propertyName));
        }
        this._mappings.put(propertyName, mapping);
        return mapping;
    }

    private boolean mapConventionOn(SupportsConvention target, MappedPropertyImpl mapping) {
        if (target instanceof FileSystemLocationProperty) {
            FileSystemLocationPropertyInternal asFileSystemLocationProperty = (FileSystemLocationPropertyInternal)Cast.uncheckedNonnullCast((Object)target);
            asFileSystemLocationProperty.conventionFromAnyFile(new DefaultProvider<Object>(() -> mapping.getValue()));
        } else if (target instanceof Property) {
            Property asProperty = (Property)Cast.uncheckedNonnullCast((Object)target);
            asProperty.convention(new DefaultProvider<Object>(() -> mapping.getValue()));
        } else if (target instanceof MapProperty) {
            MapProperty asMapProperty = (MapProperty)Cast.uncheckedNonnullCast((Object)target);
            DefaultProvider<Map> convention = new DefaultProvider<Map>(() -> (Map)Cast.uncheckedNonnullCast((Object)mapping.getValue()));
            asMapProperty.convention(convention);
        } else if (target instanceof HasMultipleValues) {
            HasMultipleValues asCollectionProperty = (HasMultipleValues)Cast.uncheckedNonnullCast((Object)target);
            asCollectionProperty.convention(new DefaultProvider<Iterable>(() -> (Iterable)Cast.uncheckedNonnullCast((Object)mapping.getValue())));
        } else if (target instanceof ConfigurableFileCollection) {
            ConfigurableFileCollection asFileCollection = (ConfigurableFileCollection)Cast.uncheckedNonnullCast((Object)target);
            asFileCollection.convention(new Object[]{() -> mapping.getValue()});
        } else {
            return false;
        }
        return true;
    }

    @Override
    public ConventionMapping.MappedProperty map(String propertyName, final Closure<?> value) {
        return this.map(propertyName, new MappedPropertyImpl(){

            @Override
            public Object doGetValue() {
                return value.call();
            }
        });
    }

    @Override
    public ConventionMapping.MappedProperty map(String propertyName, final Callable<?> value) {
        return this.map(propertyName, new MappedPropertyImpl(){

            @Override
            public Object doGetValue() {
                return UncheckedException.uncheckedCall((Callable)value);
            }
        });
    }

    public void propertyMissing(String name, Object value) {
        if (!(value instanceof Closure)) {
            throw new MissingPropertyException(name, this.getClass());
        }
        this.map(name, (Closure)Cast.uncheckedNonnullCast((Object)value));
    }

    @Override
    public void ineligible(String propertyName) {
        this._ineligiblePropertyNames.add(propertyName);
    }

    @Override
    public <T> T getConventionValue(T actualValue, String propertyName, boolean isExplicitValue) {
        if (isExplicitValue) {
            return actualValue;
        }
        Object returnValue = actualValue;
        if (this._mappings.containsKey(propertyName)) {
            boolean useMapping = true;
            if (actualValue instanceof Collection && !((Collection)actualValue).isEmpty()) {
                useMapping = false;
            } else if (actualValue instanceof Map && !((Map)actualValue).isEmpty()) {
                useMapping = false;
            }
            if (useMapping) {
                returnValue = Cast.uncheckedNonnullCast((Object)this._mappings.get(propertyName).getValue());
            }
        }
        return returnValue;
    }

    private static abstract class MappedPropertyImpl
    implements ConventionMapping.MappedProperty {
        private boolean haveValue;
        private boolean cache;
        private Object cachedValue;

        private MappedPropertyImpl() {
        }

        public @Nullable Object getValue() {
            if (!this.cache) {
                return this.doGetValue();
            }
            if (!this.haveValue) {
                this.cachedValue = this.doGetValue();
                this.haveValue = true;
            }
            return this.cachedValue;
        }

        @Override
        public void cache() {
            this.cache = true;
            this.cachedValue = null;
        }

        abstract @Nullable Object doGetValue();
    }
}

