﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/events/CloudWatchEvents_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace CloudWatchEvents {
namespace Model {

/**
 * <p>Additional query string parameter for the connection. You can include up to
 * 100 additional query string parameters per request. Each additional parameter
 * counts towards the event payload size, which cannot exceed 64 KB.</p><p><h3>See
 * Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/ConnectionQueryStringParameter">AWS
 * API Reference</a></p>
 */
class ConnectionQueryStringParameter {
 public:
  AWS_CLOUDWATCHEVENTS_API ConnectionQueryStringParameter() = default;
  AWS_CLOUDWATCHEVENTS_API ConnectionQueryStringParameter(Aws::Utils::Json::JsonView jsonValue);
  AWS_CLOUDWATCHEVENTS_API ConnectionQueryStringParameter& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_CLOUDWATCHEVENTS_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The key for a query string parameter.</p>
   */
  inline const Aws::String& GetKey() const { return m_key; }
  inline bool KeyHasBeenSet() const { return m_keyHasBeenSet; }
  template <typename KeyT = Aws::String>
  void SetKey(KeyT&& value) {
    m_keyHasBeenSet = true;
    m_key = std::forward<KeyT>(value);
  }
  template <typename KeyT = Aws::String>
  ConnectionQueryStringParameter& WithKey(KeyT&& value) {
    SetKey(std::forward<KeyT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The value associated with the key for the query string parameter.</p>
   */
  inline const Aws::String& GetValue() const { return m_value; }
  inline bool ValueHasBeenSet() const { return m_valueHasBeenSet; }
  template <typename ValueT = Aws::String>
  void SetValue(ValueT&& value) {
    m_valueHasBeenSet = true;
    m_value = std::forward<ValueT>(value);
  }
  template <typename ValueT = Aws::String>
  ConnectionQueryStringParameter& WithValue(ValueT&& value) {
    SetValue(std::forward<ValueT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Specifies whether the value is secret.</p>
   */
  inline bool GetIsValueSecret() const { return m_isValueSecret; }
  inline bool IsValueSecretHasBeenSet() const { return m_isValueSecretHasBeenSet; }
  inline void SetIsValueSecret(bool value) {
    m_isValueSecretHasBeenSet = true;
    m_isValueSecret = value;
  }
  inline ConnectionQueryStringParameter& WithIsValueSecret(bool value) {
    SetIsValueSecret(value);
    return *this;
  }
  ///@}
 private:
  Aws::String m_key;

  Aws::String m_value;

  bool m_isValueSecret{false};
  bool m_keyHasBeenSet = false;
  bool m_valueHasBeenSet = false;
  bool m_isValueSecretHasBeenSet = false;
};

}  // namespace Model
}  // namespace CloudWatchEvents
}  // namespace Aws
