/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.application;

import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.graalvm.visualvm.application.Application;
import org.graalvm.visualvm.core.datasource.DataSource;
import org.graalvm.visualvm.core.ui.actions.ActionUtils;
import org.graalvm.visualvm.core.ui.actions.MultiDataSourceAction;
import org.graalvm.visualvm.host.Host;
import org.graalvm.visualvm.host.RemoteHostsContainer;
import org.openide.util.NbBundle;

final class RemoveFinishedApplicationsAction
extends MultiDataSourceAction<Host> {
    private static RemoveFinishedApplicationsAction alwaysEnabled;
    private static RemoveFinishedApplicationsAction selectionAware;
    private final boolean tracksSelection;

    static synchronized RemoveFinishedApplicationsAction alwaysEnabled() {
        if (alwaysEnabled == null) {
            alwaysEnabled = new RemoveFinishedApplicationsAction(false);
        }
        return alwaysEnabled;
    }

    static synchronized RemoveFinishedApplicationsAction selectionAware() {
        if (selectionAware == null) {
            selectionAware = new RemoveFinishedApplicationsAction(true);
        }
        return selectionAware;
    }

    protected void actionPerformed(final Set<Host> hosts, ActionEvent actionEvent) {
        DataSource.EVENT_QUEUE.post(new Runnable(){

            @Override
            public void run() {
                if (RemoveFinishedApplicationsAction.this.tracksSelection) {
                    RemoveFinishedApplicationsAction.this.removeApplications(hosts);
                } else {
                    HashSet<Host> _hosts = new HashSet<Host>();
                    _hosts.add(Host.LOCALHOST);
                    _hosts.addAll(RemoteHostsContainer.sharedInstance().getRepository().getDataSources(Host.class));
                    RemoveFinishedApplicationsAction.this.removeApplications(_hosts);
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        RemoveFinishedApplicationsAction.this.updateState(ActionUtils.getSelectedDataSources((Class)RemoveFinishedApplicationsAction.this.getScope()));
                    }
                });
            }
        });
    }

    protected boolean isEnabled(Set<Host> hosts) {
        for (Host host : hosts) {
            Set applications = host.getRepository().getDataSources(Application.class);
            for (Application application : applications) {
                if (!RemoveFinishedApplicationsAction.isRemovable(application)) continue;
                return true;
            }
        }
        return false;
    }

    protected void updateState(Set<Host> hosts) {
        if (this.tracksSelection) {
            super.updateState(hosts);
        }
    }

    private void removeApplications(Set<Host> hosts) {
        for (Host host : hosts) {
            Set applications = host.getRepository().getDataSources(Application.class);
            for (Application application : applications) {
                if (!RemoveFinishedApplicationsAction.isRemovable(application)) continue;
                host.getRepository().removeDataSource((DataSource)application);
            }
        }
    }

    private static boolean isRemovable(Application application) {
        return application.getState() == 0 && application.supportsFinishedRemove();
    }

    private RemoveFinishedApplicationsAction(boolean tracksSelection) {
        super(Host.class);
        this.tracksSelection = tracksSelection;
        this.putValue("Name", NbBundle.getMessage(RemoveFinishedApplicationsAction.class, (String)"ACT_RemoveFinishedName"));
        this.putValue("ShortDescription", NbBundle.getMessage(RemoveFinishedApplicationsAction.class, (String)"ACT_RemoveFinishedDescr"));
    }
}

