/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.export;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.solr.handler.export.SortValue;

class SortDoc
implements Comparable<SortDoc> {
    protected int docId = -1;
    protected int ord = -1;
    protected int docBase = -1;
    private SortValue[] sortValues;

    public SortDoc(SortValue[] sortValues) {
        this.sortValues = sortValues;
    }

    public SortDoc() {
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SortDoc)) {
            return false;
        }
        return this.compareTo((SortDoc)obj) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.docId, this.ord, this.docBase);
    }

    public SortValue getSortValue(String field) {
        for (SortValue value : this.sortValues) {
            if (!value.getField().equals(field)) continue;
            return value;
        }
        return null;
    }

    public void setNextReader(LeafReaderContext context) throws IOException {
        this.ord = context.ord;
        this.docBase = context.docBase;
        for (SortValue value : this.sortValues) {
            value.setNextReader(context);
        }
    }

    public void reset() {
        this.docId = -1;
        this.docBase = -1;
        this.ord = -1;
        for (SortValue value : this.sortValues) {
            value.reset();
        }
    }

    public void setValues(int docId) throws IOException {
        this.docId = docId;
        for (SortValue sortValue : this.sortValues) {
            sortValue.setCurrentValue(docId);
        }
    }

    public void setGlobalValues(SortDoc previous) {
        SortValue[] previousValues = previous.sortValues;
        for (int i = 0; i < this.sortValues.length; ++i) {
            this.sortValues[i].toGlobalValue(previousValues[i]);
        }
    }

    public void setValues(SortDoc sortDoc) {
        this.docId = sortDoc.docId;
        this.ord = sortDoc.ord;
        this.docBase = sortDoc.docBase;
        SortValue[] vals = sortDoc.sortValues;
        for (int i = 0; i < vals.length; ++i) {
            this.sortValues[i].setCurrentValue(vals[i]);
        }
    }

    public SortDoc copy() {
        SortValue[] svs = new SortValue[this.sortValues.length];
        for (int i = 0; i < this.sortValues.length; ++i) {
            svs[i] = this.sortValues[i].copy();
        }
        return new SortDoc(svs);
    }

    public boolean lessThan(Object o) {
        if (this.docId == -1) {
            return true;
        }
        SortDoc sd = (SortDoc)o;
        SortValue[] sortValues1 = sd.sortValues;
        for (int i = 0; i < this.sortValues.length; ++i) {
            int comp = this.sortValues[i].compareTo(sortValues1[i]);
            if (comp < 0) {
                return true;
            }
            if (comp <= 0) continue;
            return false;
        }
        return this.docId + this.docBase > sd.docId + sd.docBase;
    }

    @Override
    public int compareTo(SortDoc sd) {
        for (int i = 0; i < this.sortValues.length; ++i) {
            int comp = this.sortValues[i].compareTo(sd.sortValues[i]);
            if (comp == 0) continue;
            return comp;
        }
        return sd.docId + sd.docBase - (this.docId + this.docBase);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.ord).append(':').append(this.docBase).append(':').append(this.docId).append("; ");
        for (int i = 0; i < this.sortValues.length; ++i) {
            builder.append("value").append(i).append(": ").append(this.sortValues[i]).append(", ");
        }
        return builder.toString();
    }
}

