/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.util;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IniFile {
    private Pattern SECTION_PATTERN = Pattern.compile("\\s*\\[([^]]*)\\]\\s*");
    private Pattern KEY_VAL_PATTERN = Pattern.compile("\\s*([^=]*)=(.*)");
    private Map<String, Map<String, String>> sections = new HashMap<String, Map<String, String>>();

    public IniFile(String path) throws IOException {
        this.load(path);
    }

    public void load(String path) throws IOException {
        try (BufferedReader br = new BufferedReader(new FileReader(path));){
            String line;
            String section = null;
            while ((line = br.readLine()) != null) {
                Matcher m = this.SECTION_PATTERN.matcher(line);
                if (m.matches()) {
                    section = m.group(1).trim();
                    continue;
                }
                if (section == null || !(m = this.KEY_VAL_PATTERN.matcher(line)).matches()) continue;
                String key = m.group(1).trim();
                String value = m.group(2).trim();
                Map<String, String> kv = this.sections.get(section);
                if (kv == null) {
                    kv = new HashMap<String, String>();
                    this.sections.put(section, kv);
                }
                kv.put(key, value);
            }
        }
    }

    public Map<String, String> getAllKeyVals(String section) {
        Map<String, String> kv = this.sections.get(section);
        return kv;
    }
}

