/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.runtime.exception;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.api.interop.ExceptionType;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;

@ExportLibrary(value=InteropLibrary.class)
public class PIncompleteSourceException
extends AbstractTruffleException {
    private static final long serialVersionUID = 4393080397807767467L;
    private transient Source source;
    private final int line;

    public PIncompleteSourceException(String message, Throwable cause, int line, Source source) {
        super(message, cause, -1, null);
        this.line = line;
        this.source = source;
    }

    public PIncompleteSourceException(String message, Throwable cause, int line) {
        this(message, cause, line, null);
    }

    public void setSource(Source source) {
        this.source = source;
    }

    @ExportMessage
    boolean isException() {
        return true;
    }

    @ExportMessage
    RuntimeException throwException() {
        throw this;
    }

    @ExportMessage
    ExceptionType getExceptionType() {
        return ExceptionType.PARSE_ERROR;
    }

    @ExportMessage
    boolean isExceptionIncompleteSource() {
        return true;
    }

    @ExportMessage
    boolean hasExceptionMessage() {
        return true;
    }

    @ExportMessage
    String getExceptionMessage() {
        return this.getMessage();
    }

    @ExportMessage
    boolean hasSourceLocation() {
        return true;
    }

    @ExportMessage(name="getSourceLocation")
    @CompilerDirectives.TruffleBoundary
    SourceSection getExceptionSourceLocation() {
        if (this.line > 0 && this.line < this.source.getLineCount()) {
            return this.source.createSection(this.line);
        }
        return this.source.createUnavailableSection();
    }
}

