/* tray.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from tray.vala, do not modify */

/*
 *  pamac-vala
 *
 *  Copyright (C) 2014-2023 Guillaume Benoit <guillaume@manjaro.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a get of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/* i18n*/

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <glib-object.h>
#include <pamac.h>
#include <libnotify/notify.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <locale.h>

#define GETTEXT_PACKAGE "pamac"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define PAMAC_TYPE_TRAY_ICON (pamac_tray_icon_get_type ())
#define PAMAC_TRAY_ICON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PAMAC_TYPE_TRAY_ICON, PamacTrayIcon))
#define PAMAC_TRAY_ICON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PAMAC_TYPE_TRAY_ICON, PamacTrayIconClass))
#define PAMAC_IS_TRAY_ICON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PAMAC_TYPE_TRAY_ICON))
#define PAMAC_IS_TRAY_ICON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PAMAC_TYPE_TRAY_ICON))
#define PAMAC_TRAY_ICON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PAMAC_TYPE_TRAY_ICON, PamacTrayIconClass))

typedef struct _PamacTrayIcon PamacTrayIcon;
typedef struct _PamacTrayIconClass PamacTrayIconClass;
typedef struct _PamacTrayIconPrivate PamacTrayIconPrivate;
enum  {
	PAMAC_TRAY_ICON_0_PROPERTY,
	PAMAC_TRAY_ICON_NUM_PROPERTIES
};
static GParamSpec* pamac_tray_icon_properties[PAMAC_TRAY_ICON_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _PamacTrayIcon {
	GtkApplication parent_instance;
	PamacTrayIconPrivate * priv;
	PamacUpdatesChecker* updates_checker;
};

struct _PamacTrayIconClass {
	GtkApplicationClass parent_class;
	void (*init_status_icon) (PamacTrayIcon* self);
	void (*set_tooltip) (PamacTrayIcon* self, const gchar* info);
	void (*set_icon) (PamacTrayIcon* self, const gchar* icon);
	void (*set_icon_visible) (PamacTrayIcon* self, gboolean visible);
};

struct _PamacTrayIconPrivate {
	gchar* update_icon_name;
	gchar* noupdate_icon_name;
	const gchar* update_info;
	const gchar* noupdate_info;
	NotifyNotification* notification;
	GtkIconTheme* icon_theme;
};

static gint PamacTrayIcon_private_offset;
static gpointer pamac_tray_icon_parent_class = NULL;

VALA_EXTERN GType pamac_tray_icon_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PamacTrayIcon, g_object_unref)
VALA_EXTERN void pamac_tray_icon_init_status_icon (PamacTrayIcon* self);
VALA_EXTERN void pamac_tray_icon_set_tooltip (PamacTrayIcon* self,
                                  const gchar* info);
VALA_EXTERN void pamac_tray_icon_set_icon (PamacTrayIcon* self,
                               const gchar* icon);
VALA_EXTERN void pamac_tray_icon_set_icon_visible (PamacTrayIcon* self,
                                       gboolean visible);
VALA_EXTERN PamacTrayIcon* pamac_tray_icon_construct (GType object_type);
static void __lambda4_ (PamacTrayIcon* self,
                 guint16 updates_nb);
static void pamac_tray_icon_close_notification (PamacTrayIcon* self);
static void pamac_tray_icon_show_or_update_notification (PamacTrayIcon* self,
                                                  guint updates_nb);
static void ___lambda4__pamac_updates_checker_updates_available (PamacUpdatesChecker* _sender,
                                                          guint16 updates_nb,
                                                          gpointer self);
static void pamac_tray_icon_real_init_status_icon (PamacTrayIcon* self);
VALA_EXTERN GtkMenu* pamac_tray_icon_create_menu (PamacTrayIcon* self);
static void pamac_tray_icon_execute_manager (PamacTrayIcon* self);
static void _pamac_tray_icon_execute_manager_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                              gpointer self);
static void _g_application_release_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                    gpointer self);
VALA_EXTERN void pamac_tray_icon_left_clicked (PamacTrayIcon* self);
static void pamac_tray_icon_execute_updater (PamacTrayIcon* self);
static void pamac_tray_icon_real_set_tooltip (PamacTrayIcon* self,
                                       const gchar* info);
static void pamac_tray_icon_real_set_icon (PamacTrayIcon* self,
                                    const gchar* icon);
static void pamac_tray_icon_real_set_icon_visible (PamacTrayIcon* self,
                                            gboolean visible);
static void pamac_tray_icon_update_notification (PamacTrayIcon* self,
                                          const gchar* info);
static void pamac_tray_icon_show_notification (PamacTrayIcon* self,
                                        const gchar* info);
static void _pamac_tray_icon_execute_updater_notify_action_callback (NotifyNotification* notification,
                                                              const gchar* action,
                                                              gpointer self);
static void pamac_tray_icon_launch_refresh_timeout (PamacTrayIcon* self);
static gboolean __lambda5_ (PamacTrayIcon* self);
static gboolean ___lambda5__gsource_func (gpointer self);
static void pamac_tray_icon_on_icon_theme_changed (PamacTrayIcon* self);
static void pamac_tray_icon_real_startup (GApplication* base);
static void _pamac_tray_icon_on_icon_theme_changed_gtk_icon_theme_changed (GtkIconTheme* _sender,
                                                                    gpointer self);
static gboolean __lambda6_ (PamacTrayIcon* self);
static gboolean ___lambda6__gsource_func (gpointer self);
static void pamac_tray_icon_real_activate (GApplication* base);
static void pamac_tray_icon_finalize (GObject * obj);
static GType pamac_tray_icon_get_type_once (void);

static inline gpointer
pamac_tray_icon_get_instance_private (PamacTrayIcon* self)
{
	return G_STRUCT_MEMBER_P (self, PamacTrayIcon_private_offset);
}

static void
__lambda4_ (PamacTrayIcon* self,
            guint16 updates_nb)
{
	if (((gint) updates_nb) == 0) {
		const gchar* _tmp0_;
		const gchar* _tmp1_;
		PamacUpdatesChecker* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp0_ = self->priv->noupdate_icon_name;
		pamac_tray_icon_set_icon (self, _tmp0_);
		_tmp1_ = self->priv->noupdate_info;
		pamac_tray_icon_set_tooltip (self, _tmp1_);
		_tmp2_ = self->updates_checker;
		_tmp3_ = pamac_updates_checker_get_no_update_hide_icon (_tmp2_);
		_tmp4_ = _tmp3_;
		pamac_tray_icon_set_icon_visible (self, !_tmp4_);
		pamac_tray_icon_close_notification (self);
	} else {
		PamacUpdatesChecker* _tmp5_;
		guint16 _tmp6_;
		guint16 _tmp7_;
		_tmp5_ = self->updates_checker;
		_tmp6_ = pamac_updates_checker_get_updates_nb (_tmp5_);
		_tmp7_ = _tmp6_;
		pamac_tray_icon_show_or_update_notification (self, (guint) _tmp7_);
	}
}

static void
___lambda4__pamac_updates_checker_updates_available (PamacUpdatesChecker* _sender,
                                                     guint16 updates_nb,
                                                     gpointer self)
{
	__lambda4_ ((PamacTrayIcon*) self, updates_nb);
}

PamacTrayIcon*
pamac_tray_icon_construct (GType object_type)
{
	PamacTrayIcon * self = NULL;
	PamacUpdatesChecker* _tmp0_;
	PamacUpdatesChecker* _tmp1_;
	self = (PamacTrayIcon*) g_object_new (object_type, NULL);
	g_application_set_application_id ((GApplication*) self, "org.manjaro.pamac.tray");
	g_application_set_flags ((GApplication*) self, G_APPLICATION_FLAGS_NONE);
	_tmp0_ = pamac_updates_checker_new ();
	_g_object_unref0 (self->updates_checker);
	self->updates_checker = _tmp0_;
	_tmp1_ = self->updates_checker;
	g_signal_connect_object (_tmp1_, "updates-available", (GCallback) ___lambda4__pamac_updates_checker_updates_available, self, 0);
	return self;
}

static void
pamac_tray_icon_real_init_status_icon (PamacTrayIcon* self)
{
	g_critical ("Type `%s' does not implement abstract method `pamac_tray_icon_init_status_icon'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
pamac_tray_icon_init_status_icon (PamacTrayIcon* self)
{
	PamacTrayIconClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = PAMAC_TRAY_ICON_GET_CLASS (self);
	if (_klass_->init_status_icon) {
		_klass_->init_status_icon (self);
	}
}

static void
_pamac_tray_icon_execute_manager_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                         gpointer self)
{
	pamac_tray_icon_execute_manager ((PamacTrayIcon*) self);
}

static void
_g_application_release_gtk_menu_item_activate (GtkMenuItem* _sender,
                                               gpointer self)
{
	g_application_release ((GApplication*) self);
}

GtkMenu*
pamac_tray_icon_create_menu (PamacTrayIcon* self)
{
	GtkMenu* menu = NULL;
	GtkMenu* _tmp0_;
	GtkMenuItem* item = NULL;
	GtkMenuItem* _tmp1_;
	GtkMenuItem* _tmp2_;
	GtkMenuItem* _tmp3_;
	GtkMenuItem* _tmp4_;
	GtkMenuItem* _tmp5_;
	GtkMenuItem* _tmp6_;
	GtkMenu* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = (GtkMenu*) gtk_menu_new ();
	g_object_ref_sink (_tmp0_);
	menu = _tmp0_;
	_tmp1_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_ ("Package Manager"));
	g_object_ref_sink (_tmp1_);
	item = _tmp1_;
	_tmp2_ = item;
	g_signal_connect_object (_tmp2_, "activate", (GCallback) _pamac_tray_icon_execute_manager_gtk_menu_item_activate, self, 0);
	_tmp3_ = item;
	gtk_menu_shell_append ((GtkMenuShell*) menu, _tmp3_);
	_tmp4_ = (GtkMenuItem*) gtk_menu_item_new_with_mnemonic (_ ("_Quit"));
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (item);
	item = _tmp4_;
	_tmp5_ = item;
	g_signal_connect_object (_tmp5_, "activate", (GCallback) _g_application_release_gtk_menu_item_activate, (GApplication*) self, 0);
	_tmp6_ = item;
	gtk_menu_shell_append ((GtkMenuShell*) menu, _tmp6_);
	gtk_widget_show_all ((GtkWidget*) menu);
	result = menu;
	_g_object_unref0 (item);
	return result;
}

void
pamac_tray_icon_left_clicked (PamacTrayIcon* self)
{
	PamacUpdatesChecker* _tmp0_;
	guint16 _tmp1_;
	guint16 _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->updates_checker;
	_tmp1_ = pamac_updates_checker_get_updates_nb (_tmp0_);
	_tmp2_ = _tmp1_;
	if (((gint) _tmp2_) > 0) {
		pamac_tray_icon_execute_updater (self);
	} else {
		pamac_tray_icon_execute_manager (self);
	}
}

static void
pamac_tray_icon_execute_updater (PamacTrayIcon* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		g_spawn_command_line_async ("pamac-manager --updates", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_SPAWN_ERROR) {
				goto __catch0_g_spawn_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_g_spawn_error:
	{
		GError* e = NULL;
		GError* _tmp0_;
		const gchar* _tmp1_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = e;
		_tmp1_ = _tmp0_->message;
		g_warning ("tray.vala:76: %s", _tmp1_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
pamac_tray_icon_execute_manager (PamacTrayIcon* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		g_spawn_command_line_async ("pamac-manager", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_SPAWN_ERROR) {
				goto __catch0_g_spawn_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_g_spawn_error:
	{
		GError* e = NULL;
		GError* _tmp0_;
		const gchar* _tmp1_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = e;
		_tmp1_ = _tmp0_->message;
		g_warning ("tray.vala:84: %s", _tmp1_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
pamac_tray_icon_real_set_tooltip (PamacTrayIcon* self,
                                  const gchar* info)
{
	g_critical ("Type `%s' does not implement abstract method `pamac_tray_icon_set_tooltip'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
pamac_tray_icon_set_tooltip (PamacTrayIcon* self,
                             const gchar* info)
{
	PamacTrayIconClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = PAMAC_TRAY_ICON_GET_CLASS (self);
	if (_klass_->set_tooltip) {
		_klass_->set_tooltip (self, info);
	}
}

static void
pamac_tray_icon_real_set_icon (PamacTrayIcon* self,
                               const gchar* icon)
{
	g_critical ("Type `%s' does not implement abstract method `pamac_tray_icon_set_icon'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
pamac_tray_icon_set_icon (PamacTrayIcon* self,
                          const gchar* icon)
{
	PamacTrayIconClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = PAMAC_TRAY_ICON_GET_CLASS (self);
	if (_klass_->set_icon) {
		_klass_->set_icon (self, icon);
	}
}

static void
pamac_tray_icon_real_set_icon_visible (PamacTrayIcon* self,
                                       gboolean visible)
{
	g_critical ("Type `%s' does not implement abstract method `pamac_tray_icon_set_icon_visible'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
pamac_tray_icon_set_icon_visible (PamacTrayIcon* self,
                                  gboolean visible)
{
	PamacTrayIconClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = PAMAC_TRAY_ICON_GET_CLASS (self);
	if (_klass_->set_icon_visible) {
		_klass_->set_icon_visible (self, visible);
	}
}

static void
pamac_tray_icon_show_or_update_notification (PamacTrayIcon* self,
                                             guint updates_nb)
{
	gchar* info = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup_printf (ngettext ("%u available update", "%u available updates", (gulong) updates_nb), updates_nb);
	info = _tmp0_;
	_tmp1_ = self->priv->update_icon_name;
	pamac_tray_icon_set_icon (self, _tmp1_);
	pamac_tray_icon_set_tooltip (self, info);
	pamac_tray_icon_set_icon_visible (self, TRUE);
	_tmp2_ = self->priv->update_info;
	pamac_tray_icon_update_notification (self, _tmp2_);
	_g_free0 (info);
}

static void
_pamac_tray_icon_execute_updater_notify_action_callback (NotifyNotification* notification,
                                                         const gchar* action,
                                                         gpointer self)
{
	pamac_tray_icon_execute_updater ((PamacTrayIcon*) self);
}

static void
pamac_tray_icon_show_notification (PamacTrayIcon* self,
                                   const gchar* info)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (info != NULL);
	{
		NotifyNotification* _tmp0_;
		NotifyNotification* _tmp1_;
		NotifyNotification* _tmp2_;
		NotifyNotification* _tmp3_;
		pamac_tray_icon_close_notification (self);
		_tmp0_ = notify_notification_new (_ ("Package Manager"), info, "system-software-install-symbolic");
		_g_object_unref0 (self->priv->notification);
		self->priv->notification = _tmp0_;
		_tmp1_ = self->priv->notification;
		notify_notification_set_timeout (_tmp1_, NOTIFY_EXPIRES_DEFAULT);
		_tmp2_ = self->priv->notification;
		notify_notification_add_action (_tmp2_, "default", _ ("Details"), _pamac_tray_icon_execute_updater_notify_action_callback, g_object_ref (self), g_object_unref);
		_tmp3_ = self->priv->notification;
		notify_notification_show (_tmp3_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("tray.vala:110: %s", _tmp5_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
pamac_tray_icon_update_notification (PamacTrayIcon* self,
                                     const gchar* info)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (info != NULL);
	{
		NotifyNotification* _tmp0_;
		_tmp0_ = self->priv->notification;
		if (_tmp0_ != NULL) {
			gboolean _tmp1_ = FALSE;
			NotifyNotification* _tmp2_;
			_tmp2_ = self->priv->notification;
			if (notify_notification_get_closed_reason (_tmp2_) == -1) {
				NotifyNotification* _tmp3_;
				gchar* _tmp4_;
				gchar* _tmp5_;
				gchar* _tmp6_;
				_tmp3_ = self->priv->notification;
				g_object_get (_tmp3_, "body", &_tmp4_, NULL);
				_tmp5_ = _tmp4_;
				_tmp6_ = _tmp5_;
				_tmp1_ = g_strcmp0 (_tmp6_, info) != 0;
				_g_free0 (_tmp6_);
			} else {
				_tmp1_ = FALSE;
			}
			if (_tmp1_) {
				NotifyNotification* _tmp7_;
				NotifyNotification* _tmp8_;
				_tmp7_ = self->priv->notification;
				notify_notification_update (_tmp7_, _ ("Package Manager"), info, "system-software-install-symbolic");
				_tmp8_ = self->priv->notification;
				notify_notification_show (_tmp8_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
			}
		} else {
			pamac_tray_icon_show_notification (self, info);
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp9_;
		const gchar* _tmp10_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp9_ = e;
		_tmp10_ = _tmp9_->message;
		g_warning ("tray.vala:125: %s", _tmp10_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
pamac_tray_icon_close_notification (PamacTrayIcon* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		gboolean _tmp0_ = FALSE;
		NotifyNotification* _tmp1_;
		_tmp1_ = self->priv->notification;
		if (_tmp1_ != NULL) {
			NotifyNotification* _tmp2_;
			_tmp2_ = self->priv->notification;
			_tmp0_ = notify_notification_get_closed_reason (_tmp2_) == -1;
		} else {
			_tmp0_ = FALSE;
		}
		if (_tmp0_) {
			NotifyNotification* _tmp3_;
			_tmp3_ = self->priv->notification;
			notify_notification_close (_tmp3_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_g_object_unref0 (self->priv->notification);
			self->priv->notification = NULL;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("tray.vala:136: %s", _tmp5_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static gboolean
__lambda5_ (PamacTrayIcon* self)
{
	PamacUpdatesChecker* _tmp0_;
	gboolean result;
	_tmp0_ = self->updates_checker;
	pamac_updates_checker_check_updates (_tmp0_);
	result = TRUE;
	return result;
}

static gboolean
___lambda5__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda5_ ((PamacTrayIcon*) self);
	return result;
}

static void
pamac_tray_icon_launch_refresh_timeout (PamacTrayIcon* self)
{
	g_return_if_fail (self != NULL);
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 3600, ___lambda5__gsource_func, g_object_ref (self), g_object_unref);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
pamac_tray_icon_on_icon_theme_changed (PamacTrayIcon* self)
{
	GtkIconTheme* _tmp0_;
	GtkIconTheme* _tmp1_;
	PamacUpdatesChecker* _tmp2_;
	guint16 _tmp3_;
	guint16 _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_icon_theme_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->icon_theme);
	self->priv->icon_theme = _tmp1_;
	_tmp2_ = self->updates_checker;
	_tmp3_ = pamac_updates_checker_get_updates_nb (_tmp2_);
	_tmp4_ = _tmp3_;
	if (((gint) _tmp4_) > 0) {
		const gchar* _tmp5_;
		_tmp5_ = self->priv->update_icon_name;
		pamac_tray_icon_set_icon (self, _tmp5_);
	} else {
		const gchar* _tmp6_;
		_tmp6_ = self->priv->noupdate_icon_name;
		pamac_tray_icon_set_icon (self, _tmp6_);
	}
}

static void
_pamac_tray_icon_on_icon_theme_changed_gtk_icon_theme_changed (GtkIconTheme* _sender,
                                                               gpointer self)
{
	pamac_tray_icon_on_icon_theme_changed ((PamacTrayIcon*) self);
}

static gboolean
__lambda6_ (PamacTrayIcon* self)
{
	PamacUpdatesChecker* _tmp0_;
	gboolean result;
	_tmp0_ = self->updates_checker;
	pamac_updates_checker_check_updates (_tmp0_);
	result = FALSE;
	return result;
}

static gboolean
___lambda6__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda6_ ((PamacTrayIcon*) self);
	return result;
}

static void
pamac_tray_icon_real_startup (GApplication* base)
{
	PamacTrayIcon * self;
	PamacUpdatesChecker* _tmp0_;
	guint64 _tmp1_;
	guint64 _tmp2_;
	GtkIconTheme* _tmp3_;
	GtkIconTheme* _tmp4_;
	GtkIconTheme* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	PamacUpdatesChecker* _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	self = (PamacTrayIcon*) base;
	textdomain ("pamac");
	setlocale (LC_ALL, "");
	G_APPLICATION_CLASS (pamac_tray_icon_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
	_tmp0_ = self->updates_checker;
	_tmp1_ = pamac_updates_checker_get_refresh_period (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == ((guint64) 0)) {
		g_message ("tray.vala:166: checking updates is not enabled, exiting");
		return;
	}
	_tmp3_ = gtk_icon_theme_get_default ();
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (self->priv->icon_theme);
	self->priv->icon_theme = _tmp4_;
	_tmp5_ = self->priv->icon_theme;
	g_signal_connect_object (_tmp5_, "changed", (GCallback) _pamac_tray_icon_on_icon_theme_changed_gtk_icon_theme_changed, self, 0);
	pamac_tray_icon_init_status_icon (self);
	_tmp6_ = self->priv->noupdate_icon_name;
	pamac_tray_icon_set_icon (self, _tmp6_);
	_tmp7_ = self->priv->noupdate_info;
	pamac_tray_icon_set_tooltip (self, _tmp7_);
	_tmp8_ = self->updates_checker;
	_tmp9_ = pamac_updates_checker_get_no_update_hide_icon (_tmp8_);
	_tmp10_ = _tmp9_;
	pamac_tray_icon_set_icon_visible (self, !_tmp10_);
	notify_init (_ ("Package Manager"));
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 30, ___lambda6__gsource_func, g_object_ref (self), g_object_unref);
	pamac_tray_icon_launch_refresh_timeout (self);
	g_application_hold ((GApplication*) self);
}

static void
pamac_tray_icon_real_activate (GApplication* base)
{
	PamacTrayIcon * self;
	self = (PamacTrayIcon*) base;
}

static void
pamac_tray_icon_class_init (PamacTrayIconClass * klass,
                            gpointer klass_data)
{
	pamac_tray_icon_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PamacTrayIcon_private_offset);
	((PamacTrayIconClass *) klass)->init_status_icon = (void (*) (PamacTrayIcon*)) pamac_tray_icon_real_init_status_icon;
	((PamacTrayIconClass *) klass)->set_tooltip = (void (*) (PamacTrayIcon*, const gchar*)) pamac_tray_icon_real_set_tooltip;
	((PamacTrayIconClass *) klass)->set_icon = (void (*) (PamacTrayIcon*, const gchar*)) pamac_tray_icon_real_set_icon;
	((PamacTrayIconClass *) klass)->set_icon_visible = (void (*) (PamacTrayIcon*, gboolean)) pamac_tray_icon_real_set_icon_visible;
	((GApplicationClass *) klass)->startup = (void (*) (GApplication*)) pamac_tray_icon_real_startup;
	((GApplicationClass *) klass)->activate = (void (*) (GApplication*)) pamac_tray_icon_real_activate;
	G_OBJECT_CLASS (klass)->finalize = pamac_tray_icon_finalize;
}

static void
pamac_tray_icon_instance_init (PamacTrayIcon * self,
                               gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	self->priv = pamac_tray_icon_get_instance_private (self);
	_tmp0_ = g_strdup ("pamac-tray-update");
	self->priv->update_icon_name = _tmp0_;
	_tmp1_ = g_strdup ("pamac-tray-no-update");
	self->priv->noupdate_icon_name = _tmp1_;
	self->priv->update_info = _ ("Updates Available");
	self->priv->noupdate_info = _ ("Your system is up to date");
}

static void
pamac_tray_icon_finalize (GObject * obj)
{
	PamacTrayIcon * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PAMAC_TYPE_TRAY_ICON, PamacTrayIcon);
	_g_free0 (self->priv->update_icon_name);
	_g_free0 (self->priv->noupdate_icon_name);
	_g_object_unref0 (self->priv->notification);
	_g_object_unref0 (self->priv->icon_theme);
	_g_object_unref0 (self->updates_checker);
	G_OBJECT_CLASS (pamac_tray_icon_parent_class)->finalize (obj);
}

static GType
pamac_tray_icon_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PamacTrayIconClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pamac_tray_icon_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PamacTrayIcon), 0, (GInstanceInitFunc) pamac_tray_icon_instance_init, NULL };
	GType pamac_tray_icon_type_id;
	pamac_tray_icon_type_id = g_type_register_static (gtk_application_get_type (), "PamacTrayIcon", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	PamacTrayIcon_private_offset = g_type_add_instance_private (pamac_tray_icon_type_id, sizeof (PamacTrayIconPrivate));
	return pamac_tray_icon_type_id;
}

GType
pamac_tray_icon_get_type (void)
{
	static volatile gsize pamac_tray_icon_type_id__once = 0;
	if (g_once_init_enter (&pamac_tray_icon_type_id__once)) {
		GType pamac_tray_icon_type_id;
		pamac_tray_icon_type_id = pamac_tray_icon_get_type_once ();
		g_once_init_leave (&pamac_tray_icon_type_id__once, pamac_tray_icon_type_id);
	}
	return pamac_tray_icon_type_id__once;
}

