/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.agreement;

import java.security.PublicKey;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.collection.CollectionSupport;
import org.opensaml.core.config.ConfigurationService;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.agreement.KeyAgreementException;
import org.opensaml.xmlsec.agreement.KeyAgreementProcessor;
import org.opensaml.xmlsec.agreement.KeyAgreementProcessorRegistry;
import org.opensaml.xmlsec.algorithm.AlgorithmSupport;
import org.opensaml.xmlsec.encryption.AgreementMethod;
import org.opensaml.xmlsec.encryption.EncryptedType;
import org.opensaml.xmlsec.encryption.EncryptionMethod;
import org.opensaml.xmlsec.encryption.KeySize;

public final class KeyAgreementSupport {
    @Nonnull
    public static final Set<String> KEY_ALGORITHMS = CollectionSupport.setOf("EC", "DH");

    private KeyAgreementSupport() {
    }

    @Nullable
    public static KeyAgreementProcessorRegistry getGlobalProcessorRegistry() {
        return ConfigurationService.get(KeyAgreementProcessorRegistry.class);
    }

    @Nonnull
    public static KeyAgreementProcessorRegistry ensureGlobalProcessorRegistry() {
        return ConfigurationService.ensure(KeyAgreementProcessorRegistry.class);
    }

    @Nonnull
    public static KeyAgreementProcessor getProcessor(@Nonnull String algorithm) throws KeyAgreementException {
        KeyAgreementProcessorRegistry registry = KeyAgreementSupport.getGlobalProcessorRegistry();
        if (registry == null) {
            throw new KeyAgreementException("Global KeyAgreementProcessorRegistry not configured");
        }
        KeyAgreementProcessor processor = registry.getProcessor(algorithm);
        if (processor == null) {
            throw new KeyAgreementException("No KeyAgreementProcessor registered for specified algorithm: " + algorithm);
        }
        return processor;
    }

    @Nullable
    public static Integer getExplicitKeySize(@Nonnull AgreementMethod agreementMethod) {
        XMLObject parent = agreementMethod.getParent();
        if (parent == null || parent.getParent() == null || !EncryptedType.class.isInstance(parent.getParent())) {
            return null;
        }
        EncryptedType et = (EncryptedType)EncryptedType.class.cast(parent.getParent());
        EncryptionMethod method = et.getEncryptionMethod();
        if (method == null) {
            return null;
        }
        KeySize size = method.getKeySize();
        return size != null ? size.getValue() : null;
    }

    public static void validateKeyAlgorithmAndSize(@Nonnull String algorithmURI, @Nullable Integer specifiedKeyLength) throws KeyAgreementException {
        Integer algoKeyLength = AlgorithmSupport.getKeyLength(algorithmURI);
        if (algoKeyLength == null && specifiedKeyLength == null) {
            throw new KeyAgreementException("Key length was not specified and key algorithm does not imply a length: " + algorithmURI);
        }
        if (algoKeyLength != null && specifiedKeyLength != null && !algoKeyLength.equals(specifiedKeyLength)) {
            throw new KeyAgreementException(String.format("Algorithm URI '%s' key length (%d) does not match specified (%d)", algorithmURI, algoKeyLength, specifiedKeyLength));
        }
    }

    public static boolean supportsKeyAgreement(@Nullable Credential credential) {
        if (credential == null) {
            return false;
        }
        PublicKey pk = credential.getPublicKey();
        return pk != null && KEY_ALGORITHMS.contains(pk.getAlgorithm());
    }
}

