/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.nodes.stats;

import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.nodes.stats.ShardSearchPipelineOperationStats;
import org.opensearch.client.opensearch.nodes.stats.ShardSearchPipelinePerPipelineStats;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class ShardSearchPipelineStats
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, ShardSearchPipelineStats> {
    @Nonnull
    private final Map<String, ShardSearchPipelinePerPipelineStats> pipelines;
    @Nullable
    private final ShardSearchPipelineOperationStats totalRequest;
    @Nullable
    private final ShardSearchPipelineOperationStats totalResponse;
    public static final JsonpDeserializer<ShardSearchPipelineStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ShardSearchPipelineStats::setupShardSearchPipelineStatsDeserializer);

    private ShardSearchPipelineStats(Builder builder) {
        this.pipelines = ApiTypeHelper.unmodifiable(builder.pipelines);
        this.totalRequest = builder.totalRequest;
        this.totalResponse = builder.totalResponse;
    }

    public static ShardSearchPipelineStats of(Function<Builder, ObjectBuilder<ShardSearchPipelineStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final Map<String, ShardSearchPipelinePerPipelineStats> pipelines() {
        return this.pipelines;
    }

    @Nullable
    public final ShardSearchPipelineOperationStats totalRequest() {
        return this.totalRequest;
    }

    @Nullable
    public final ShardSearchPipelineOperationStats totalResponse() {
        return this.totalResponse;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.pipelines)) {
            generator.writeKey("pipelines");
            generator.writeStartObject();
            for (Map.Entry<String, ShardSearchPipelinePerPipelineStats> item0 : this.pipelines.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.totalRequest != null) {
            generator.writeKey("total_request");
            this.totalRequest.serialize(generator, mapper);
        }
        if (this.totalResponse != null) {
            generator.writeKey("total_response");
            this.totalResponse.serialize(generator, mapper);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupShardSearchPipelineStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::pipelines, JsonpDeserializer.stringMapDeserializer(ShardSearchPipelinePerPipelineStats._DESERIALIZER), "pipelines");
        op.add(Builder::totalRequest, ShardSearchPipelineOperationStats._DESERIALIZER, "total_request");
        op.add(Builder::totalResponse, ShardSearchPipelineOperationStats._DESERIALIZER, "total_response");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.pipelines);
        result = 31 * result + Objects.hashCode(this.totalRequest);
        result = 31 * result + Objects.hashCode(this.totalResponse);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShardSearchPipelineStats other = (ShardSearchPipelineStats)o;
        return Objects.equals(this.pipelines, other.pipelines) && Objects.equals(this.totalRequest, other.totalRequest) && Objects.equals(this.totalResponse, other.totalResponse);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, ShardSearchPipelineStats> {
        @Nullable
        private Map<String, ShardSearchPipelinePerPipelineStats> pipelines;
        @Nullable
        private ShardSearchPipelineOperationStats totalRequest;
        @Nullable
        private ShardSearchPipelineOperationStats totalResponse;

        public Builder() {
        }

        private Builder(ShardSearchPipelineStats o) {
            this.pipelines = Builder._mapCopy(o.pipelines);
            this.totalRequest = o.totalRequest;
            this.totalResponse = o.totalResponse;
        }

        private Builder(Builder o) {
            this.pipelines = Builder._mapCopy(o.pipelines);
            this.totalRequest = o.totalRequest;
            this.totalResponse = o.totalResponse;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder pipelines(Map<String, ShardSearchPipelinePerPipelineStats> map) {
            this.pipelines = Builder._mapPutAll(this.pipelines, map);
            return this;
        }

        @Nonnull
        public final Builder pipelines(String key, ShardSearchPipelinePerPipelineStats value) {
            this.pipelines = Builder._mapPut(this.pipelines, key, value);
            return this;
        }

        @Nonnull
        public final Builder pipelines(String key, Function<ShardSearchPipelinePerPipelineStats.Builder, ObjectBuilder<ShardSearchPipelinePerPipelineStats>> fn) {
            return this.pipelines(key, fn.apply(new ShardSearchPipelinePerPipelineStats.Builder()).build());
        }

        @Nonnull
        public final Builder totalRequest(@Nullable ShardSearchPipelineOperationStats value) {
            this.totalRequest = value;
            return this;
        }

        @Nonnull
        public final Builder totalRequest(Function<ShardSearchPipelineOperationStats.Builder, ObjectBuilder<ShardSearchPipelineOperationStats>> fn) {
            return this.totalRequest(fn.apply(new ShardSearchPipelineOperationStats.Builder()).build());
        }

        @Nonnull
        public final Builder totalResponse(@Nullable ShardSearchPipelineOperationStats value) {
            this.totalResponse = value;
            return this;
        }

        @Nonnull
        public final Builder totalResponse(Function<ShardSearchPipelineOperationStats.Builder, ObjectBuilder<ShardSearchPipelineOperationStats>> fn) {
            return this.totalResponse(fn.apply(new ShardSearchPipelineOperationStats.Builder()).build());
        }

        @Override
        @Nonnull
        public ShardSearchPipelineStats build() {
            this._checkSingleUse();
            return new ShardSearchPipelineStats(this);
        }
    }
}

