/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.rest;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.ml.common.indexInsight.MLIndexInsightType;
import org.opensearch.ml.common.settings.MLFeatureEnabledSetting;
import org.opensearch.ml.common.transport.indexInsight.MLIndexInsightGetAction;
import org.opensearch.ml.common.transport.indexInsight.MLIndexInsightGetRequest;
import org.opensearch.ml.utils.RestActionUtils;
import org.opensearch.ml.utils.TenantAwareHelper;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.transport.client.node.NodeClient;

public class RestMLGetIndexInsightAction
extends BaseRestHandler {
    private static final String ML_GET_INDEX_INSIGHT_ACTION = "ml_get_index_insight_action";
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;

    public RestMLGetIndexInsightAction(MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    public String getName() {
        return ML_GET_INDEX_INSIGHT_ACTION;
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.GET, String.format(Locale.ROOT, "%s/insights/{%s}/{insight_type}", "/_plugins/_ml", "index_id")));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        MLIndexInsightGetRequest mlIndexInsightGetRequest = this.getRequest(restRequest);
        return channel -> client.execute((ActionType)MLIndexInsightGetAction.INSTANCE, (ActionRequest)mlIndexInsightGetRequest, (ActionListener)new RestToXContentListener(channel));
    }

    @VisibleForTesting
    MLIndexInsightGetRequest getRequest(RestRequest request) throws IOException {
        if (!this.mlFeatureEnabledSetting.isAgentFrameworkEnabled()) {
            throw new IllegalStateException("Agent Framework is currently disabled. To enable it, update the setting \"plugins.ml_commons.agent_framework_enabled\" to true.");
        }
        String tenantId = TenantAwareHelper.getTenantID(this.mlFeatureEnabledSetting.isMultiTenancyEnabled(), request);
        String indexName = RestActionUtils.getParameterId(request, "index_id");
        String insightType = request.param("insight_type");
        if (insightType == null) {
            insightType = MLIndexInsightType.STATISTICAL_DATA.name();
        }
        MLIndexInsightType type = MLIndexInsightType.fromString((String)insightType);
        return new MLIndexInsightGetRequest(indexName, type, tenantId);
    }
}

