/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.transform.resthandler;

import java.io.IOException;
import java.time.Instant;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.indexmanagement.transform.action.index.IndexTransformAction;
import org.opensearch.indexmanagement.transform.action.index.IndexTransformRequest;
import org.opensearch.indexmanagement.transform.action.index.IndexTransformResponse;
import org.opensearch.indexmanagement.transform.model.Transform;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.rest.action.RestResponseListener;
import org.opensearch.transport.client.node.NodeClient;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u0014"}, d2={"Lorg/opensearch/indexmanagement/transform/resthandler/RestIndexTransformAction;", "Lorg/opensearch/rest/BaseRestHandler;", "<init>", "()V", "routes", "", "Lorg/opensearch/rest/RestHandler$Route;", "getName", "", "prepareRequest", "Lorg/opensearch/rest/BaseRestHandler$RestChannelConsumer;", "request", "Lorg/opensearch/rest/RestRequest;", "client", "Lorg/opensearch/transport/client/node/NodeClient;", "indexTransformResponse", "Lorg/opensearch/rest/action/RestResponseListener;", "Lorg/opensearch/indexmanagement/transform/action/index/IndexTransformResponse;", "channel", "Lorg/opensearch/rest/RestChannel;", "opensearch-index-management"})
public final class RestIndexTransformAction
extends BaseRestHandler {
    @NotNull
    public List<RestHandler.Route> routes() {
        Object[] objectArray = new RestHandler.Route[]{new RestHandler.Route(RestRequest.Method.PUT, "/_plugins/_transform"), new RestHandler.Route(RestRequest.Method.PUT, "/_plugins/_transform/{transformID}")};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public String getName() {
        return "opendistro_index_transform_action";
    }

    @NotNull
    protected BaseRestHandler.RestChannelConsumer prepareRequest(@NotNull RestRequest request, @NotNull NodeClient client) throws IOException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        String id = request.param("transformID", "");
        if (Intrinsics.areEqual((Object)"", (Object)id)) {
            throw new IllegalArgumentException("Missing transform ID");
        }
        long seqNo = request.paramAsLong("if_seq_no", -2L);
        long primaryTerm = request.paramAsLong("if_primary_term", 0L);
        XContentParser xcp = request.contentParser();
        Intrinsics.checkNotNull((Object)xcp);
        Intrinsics.checkNotNull((Object)id);
        Transform transform2 = (Transform)OpenSearchExtensionsKt.parseWithType(xcp, id, seqNo, primaryTerm, (Function4)new Function4<XContentParser, String, Long, Long, Transform>((Object)Transform.Companion){

            public final Transform invoke(XContentParser p0, String p1, long p2, long p3) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                return ((Transform.Companion)this.receiver).parse(p0, p1, p2, p3);
            }
        });
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
        Transform transform3 = Transform.copy$default(transform2, null, 0L, 0L, 0L, null, null, instant, false, null, null, null, null, null, null, 0, null, null, false, null, 524223, null);
        WriteRequest.RefreshPolicy refreshPolicy = request.hasParam("refresh") ? WriteRequest.RefreshPolicy.parse((String)request.param("refresh")) : WriteRequest.RefreshPolicy.IMMEDIATE;
        Intrinsics.checkNotNull((Object)refreshPolicy);
        IndexTransformRequest indexTransformRequest = new IndexTransformRequest(transform3, refreshPolicy);
        return arg_0 -> RestIndexTransformAction.prepareRequest$lambda$0(client, indexTransformRequest, this, arg_0);
    }

    private final RestResponseListener<IndexTransformResponse> indexTransformResponse(RestChannel channel) {
        return (RestResponseListener)new RestResponseListener<IndexTransformResponse>(channel){
            final /* synthetic */ RestChannel $channel;
            {
                this.$channel = $channel;
                super($channel);
            }

            public RestResponse buildResponse(IndexTransformResponse response2) throws Exception {
                Intrinsics.checkNotNullParameter((Object)((Object)response2), (String)"response");
                RestStatus restStatus = response2.getStatus();
                XContentBuilder xContentBuilder = this.$channel.newBuilder();
                Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"newBuilder(...)");
                ToXContent.Params params = ToXContent.EMPTY_PARAMS;
                Intrinsics.checkNotNullExpressionValue((Object)params, (String)"EMPTY_PARAMS");
                BytesRestResponse restResponse = new BytesRestResponse(restStatus, response2.toXContent(xContentBuilder, params));
                if (response2.getStatus() == RestStatus.CREATED) {
                    String location = "/_plugins/_transform/" + response2.getId();
                    restResponse.addHeader("Location", location);
                }
                return (RestResponse)restResponse;
            }
        };
    }

    private static final void prepareRequest$lambda$0(NodeClient $client, IndexTransformRequest $indexTransformRequest, RestIndexTransformAction this$0, RestChannel channel) {
        ActionType actionType = IndexTransformAction.Companion.getINSTANCE();
        ActionRequest actionRequest = (ActionRequest)$indexTransformRequest;
        Intrinsics.checkNotNull((Object)channel);
        $client.execute(actionType, actionRequest, (ActionListener)this$0.indexTransformResponse(channel));
    }
}

