/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.KeyFormat;
import software.amazon.awssdk.services.ec2.model.KeyType;
import software.amazon.awssdk.services.ec2.model.TagSpecification;
import software.amazon.awssdk.services.ec2.model.TagSpecificationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateKeyPairRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, CreateKeyPairRequest> {
    private static final SdkField<String> KEY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyName").getter(CreateKeyPairRequest.getter(CreateKeyPairRequest::keyName)).setter(CreateKeyPairRequest.setter(Builder::keyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyName").unmarshallLocationName("KeyName").build()}).build();
    private static final SdkField<String> KEY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyType").getter(CreateKeyPairRequest.getter(CreateKeyPairRequest::keyTypeAsString)).setter(CreateKeyPairRequest.setter(Builder::keyType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyType").unmarshallLocationName("KeyType").build()}).build();
    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagSpecifications").getter(CreateKeyPairRequest.getter(CreateKeyPairRequest::tagSpecifications)).setter(CreateKeyPairRequest.setter(Builder::tagSpecifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification").unmarshallLocationName("TagSpecification").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TagSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> KEY_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyFormat").getter(CreateKeyPairRequest.getter(CreateKeyPairRequest::keyFormatAsString)).setter(CreateKeyPairRequest.setter(Builder::keyFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyFormat").unmarshallLocationName("KeyFormat").build()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(CreateKeyPairRequest.getter(CreateKeyPairRequest::dryRun)).setter(CreateKeyPairRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("dryRun").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_NAME_FIELD, KEY_TYPE_FIELD, TAG_SPECIFICATIONS_FIELD, KEY_FORMAT_FIELD, DRY_RUN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateKeyPairRequest.memberNameToFieldInitializer();
    private final String keyName;
    private final String keyType;
    private final List<TagSpecification> tagSpecifications;
    private final String keyFormat;
    private final Boolean dryRun;

    private CreateKeyPairRequest(BuilderImpl builder) {
        super(builder);
        this.keyName = builder.keyName;
        this.keyType = builder.keyType;
        this.tagSpecifications = builder.tagSpecifications;
        this.keyFormat = builder.keyFormat;
        this.dryRun = builder.dryRun;
    }

    public final String keyName() {
        return this.keyName;
    }

    public final KeyType keyType() {
        return KeyType.fromValue(this.keyType);
    }

    public final String keyTypeAsString() {
        return this.keyType;
    }

    public final boolean hasTagSpecifications() {
        return this.tagSpecifications != null && !(this.tagSpecifications instanceof SdkAutoConstructList);
    }

    public final List<TagSpecification> tagSpecifications() {
        return this.tagSpecifications;
    }

    public final KeyFormat keyFormat() {
        return KeyFormat.fromValue(this.keyFormat);
    }

    public final String keyFormatAsString() {
        return this.keyFormat;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.keyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagSpecifications() ? this.tagSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.keyFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateKeyPairRequest)) {
            return false;
        }
        CreateKeyPairRequest other = (CreateKeyPairRequest)((Object)obj);
        return Objects.equals(this.keyName(), other.keyName()) && Objects.equals(this.keyTypeAsString(), other.keyTypeAsString()) && this.hasTagSpecifications() == other.hasTagSpecifications() && Objects.equals(this.tagSpecifications(), other.tagSpecifications()) && Objects.equals(this.keyFormatAsString(), other.keyFormatAsString()) && Objects.equals(this.dryRun(), other.dryRun());
    }

    public final String toString() {
        return ToString.builder((String)"CreateKeyPairRequest").add("KeyName", (Object)this.keyName()).add("KeyType", (Object)this.keyTypeAsString()).add("TagSpecifications", this.hasTagSpecifications() ? this.tagSpecifications() : null).add("KeyFormat", (Object)this.keyFormatAsString()).add("DryRun", (Object)this.dryRun()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyName": {
                return Optional.ofNullable(clazz.cast(this.keyName()));
            }
            case "KeyType": {
                return Optional.ofNullable(clazz.cast(this.keyTypeAsString()));
            }
            case "TagSpecifications": {
                return Optional.ofNullable(clazz.cast(this.tagSpecifications()));
            }
            case "KeyFormat": {
                return Optional.ofNullable(clazz.cast(this.keyFormatAsString()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("KeyName", KEY_NAME_FIELD);
        map.put("KeyType", KEY_TYPE_FIELD);
        map.put("TagSpecification", TAG_SPECIFICATIONS_FIELD);
        map.put("KeyFormat", KEY_FORMAT_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateKeyPairRequest, T> g) {
        return obj -> g.apply((CreateKeyPairRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String keyName;
        private String keyType;
        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();
        private String keyFormat;
        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateKeyPairRequest model) {
            super(model);
            this.keyName(model.keyName);
            this.keyType(model.keyType);
            this.tagSpecifications(model.tagSpecifications);
            this.keyFormat(model.keyFormat);
            this.dryRun(model.dryRun);
        }

        public final String getKeyName() {
            return this.keyName;
        }

        public final void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        @Override
        public final Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public final String getKeyType() {
            return this.keyType;
        }

        public final void setKeyType(String keyType) {
            this.keyType = keyType;
        }

        @Override
        public final Builder keyType(String keyType) {
            this.keyType = keyType;
            return this;
        }

        @Override
        public final Builder keyType(KeyType keyType) {
            this.keyType(keyType == null ? null : keyType.toString());
            return this;
        }

        public final List<TagSpecification.Builder> getTagSpecifications() {
            List<TagSpecification.Builder> result = TagSpecificationListCopier.copyToBuilder(this.tagSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification ... tagSpecifications) {
            this.tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder> ... tagSpecifications) {
            this.tagSpecifications(Stream.of(tagSpecifications).map(c -> (TagSpecification)((TagSpecification.Builder)TagSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getKeyFormat() {
            return this.keyFormat;
        }

        public final void setKeyFormat(String keyFormat) {
            this.keyFormat = keyFormat;
        }

        @Override
        public final Builder keyFormat(String keyFormat) {
            this.keyFormat = keyFormat;
            return this;
        }

        @Override
        public final Builder keyFormat(KeyFormat keyFormat) {
            this.keyFormat(keyFormat == null ? null : keyFormat.toString());
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateKeyPairRequest build() {
            return new CreateKeyPairRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateKeyPairRequest> {
        public Builder keyName(String var1);

        public Builder keyType(String var1);

        public Builder keyType(KeyType var1);

        public Builder tagSpecifications(Collection<TagSpecification> var1);

        public Builder tagSpecifications(TagSpecification ... var1);

        public Builder tagSpecifications(Consumer<TagSpecification.Builder> ... var1);

        public Builder keyFormat(String var1);

        public Builder keyFormat(KeyFormat var1);

        public Builder dryRun(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

