"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "ObservabilityPluginSetup", {
  enumerable: true,
  get: function () {
    return _types.ObservabilityPluginSetup;
  }
});
Object.defineProperty(exports, "ObservabilityPluginStart", {
  enumerable: true,
  get: function () {
    return _types.ObservabilityPluginStart;
  }
});
exports.config = void 0;
exports.plugin = plugin;
var _configSchema = require("@osd/config-schema");
var _plugin = require("./plugin");
var _types = require("./types");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function plugin(initializerContext) {
  return new _plugin.ObservabilityPlugin(initializerContext);
}
const observabilityConfig = {
  schema: _configSchema.schema.object({
    query_assist: _configSchema.schema.object({
      enabled: _configSchema.schema.boolean({
        defaultValue: true
      })
    }),
    summarize: _configSchema.schema.object({
      enabled: _configSchema.schema.boolean({
        defaultValue: false
      })
    })
  })
};
const config = exports.config = {
  schema: observabilityConfig.schema,
  exposeToBrowser: {
    query_assist: true,
    summarize: true
  }
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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