"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Toolbar = void 0;
const react_1 = __importStar(require("react"));
const classnames_1 = __importDefault(require("classnames"));
const toolbar_item_1 = require("./toolbar-item");
const Icons_1 = require("./Icons");
const toolbarStates = {
    collapsed: "collapsed",
    expandedMin: "expandedMin",
    expandedMax: "expandedMax",
};
class Toolbar extends react_1.Component {
    constructor(props) {
        super(props);
        this.state = {
            toolbarState: toolbarStates.collapsed,
        };
    }
    render() {
        const { children, onToggleFileBrowser, isSidebarVisible } = this.props;
        const { toolbarState } = this.state;
        const isCollapsed = toolbarState === toolbarStates.collapsed;
        const className = classnames_1.default("toolbar", {
            expanded: toolbarState !== toolbarStates.collapsed,
        });
        return (react_1.default.createElement("div", { className: className },
            react_1.default.createElement("span", null,
                react_1.default.createElement(toolbar_item_1.ToolbarItem, { image: react_1.default.createElement(Icons_1.ExpandSidebar, { isSidebarVisible: isSidebarVisible }), buttonClassName: "toolbar-item-expand", text: "", showText: !isCollapsed, onClick: onToggleFileBrowser }),
                react_1.default.Children.map(children, (child) => react_1.default.cloneElement(child, {
                    showText: !isCollapsed,
                    showButton: !isCollapsed,
                }))),
            react_1.default.createElement(toolbar_item_1.ToolbarItem, { image: toolbarState === toolbarStates.collapsed ? react_1.default.createElement(Icons_1.Expand, null) : react_1.default.createElement(Icons_1.Collapse, null), text: "Commands", showText: !isCollapsed, onClick: () => {
                    this.setState((previous) => ({
                        toolbarState: previous.toolbarState === toolbarStates.collapsed
                            ? toolbarStates.expandedMax
                            : toolbarStates.collapsed,
                    }));
                } })));
    }
}
exports.Toolbar = Toolbar;
//# sourceMappingURL=toolbar.js.map