/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jgss.krb5;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.security.auth.kerberos.DelegationPermission;
import org.ietf.jgss.ChannelBinding;
import org.ietf.jgss.GSSException;
import sun.security.jgss.GSSToken;
import sun.security.jgss.krb5.CipherHelper;
import sun.security.jgss.krb5.Krb5Context;
import sun.security.jgss.krb5.Krb5Token;
import sun.security.krb5.Checksum;
import sun.security.krb5.Credentials;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.KrbCred;
import sun.security.krb5.KrbException;
import sun.security.krb5.PrincipalName;

abstract class InitialToken
extends Krb5Token {
    private static final int CHECKSUM_TYPE = 32771;
    private static final int CHECKSUM_LENGTH_SIZE = 4;
    private static final int CHECKSUM_BINDINGS_SIZE = 16;
    private static final int CHECKSUM_FLAGS_SIZE = 4;
    private static final int CHECKSUM_DELEG_OPT_SIZE = 2;
    private static final int CHECKSUM_DELEG_LGTH_SIZE = 2;
    private static final int CHECKSUM_DELEG_FLAG = 1;
    private static final int CHECKSUM_MUTUAL_FLAG = 2;
    private static final int CHECKSUM_REPLAY_FLAG = 4;
    private static final int CHECKSUM_SEQUENCE_FLAG = 8;
    private static final int CHECKSUM_CONF_FLAG = 16;
    private static final int CHECKSUM_INTEG_FLAG = 32;
    private final byte[] CHECKSUM_FIRST_BYTES = new byte[]{16, 0, 0, 0};
    private static final int CHANNEL_BINDING_AF_INET = 2;
    private static final int CHANNEL_BINDING_AF_INET6 = 24;
    private static final int CHANNEL_BINDING_AF_NULL_ADDR = 255;
    private static final int Inet4_ADDRSZ = 4;
    private static final int Inet6_ADDRSZ = 16;

    InitialToken() {
    }

    private int getAddrType(InetAddress inetAddress) {
        int n = 255;
        if (inetAddress instanceof Inet4Address) {
            n = 2;
        } else if (inetAddress instanceof Inet6Address) {
            n = 24;
        }
        return n;
    }

    private byte[] getAddrBytes(InetAddress inetAddress) throws GSSException {
        int n = this.getAddrType(inetAddress);
        byte[] byArray = inetAddress.getAddress();
        if (byArray != null) {
            switch (n) {
                case 2: {
                    if (byArray.length != 4) {
                        throw new GSSException(11, -1, "Incorrect AF-INET address length in ChannelBinding.");
                    }
                    return byArray;
                }
                case 24: {
                    if (byArray.length != 16) {
                        throw new GSSException(11, -1, "Incorrect AF-INET6 address length in ChannelBinding.");
                    }
                    return byArray;
                }
            }
            throw new GSSException(11, -1, "Cannot handle non AF-INET addresses in ChannelBinding.");
        }
        return null;
    }

    private byte[] computeChannelBinding(ChannelBinding channelBinding) throws GSSException {
        byte[] byArray;
        InetAddress inetAddress = channelBinding.getInitiatorAddress();
        InetAddress inetAddress2 = channelBinding.getAcceptorAddress();
        int n = 20;
        int n2 = this.getAddrType(inetAddress);
        int n3 = this.getAddrType(inetAddress2);
        byte[] byArray2 = null;
        if (inetAddress != null) {
            byArray2 = this.getAddrBytes(inetAddress);
            n += byArray2.length;
        }
        byte[] byArray3 = null;
        if (inetAddress2 != null) {
            byArray3 = this.getAddrBytes(inetAddress2);
            n += byArray3.length;
        }
        if ((byArray = channelBinding.getApplicationData()) != null) {
            n += byArray.length;
        }
        byte[] byArray4 = new byte[n];
        int n4 = 0;
        InitialToken.writeLittleEndian(n2, byArray4, n4);
        n4 += 4;
        if (byArray2 != null) {
            InitialToken.writeLittleEndian(byArray2.length, byArray4, n4);
            System.arraycopy(byArray2, 0, byArray4, n4 += 4, byArray2.length);
            n4 += byArray2.length;
        } else {
            n4 += 4;
        }
        InitialToken.writeLittleEndian(n3, byArray4, n4);
        n4 += 4;
        if (byArray3 != null) {
            InitialToken.writeLittleEndian(byArray3.length, byArray4, n4);
            System.arraycopy(byArray3, 0, byArray4, n4 += 4, byArray3.length);
            n4 += byArray3.length;
        } else {
            n4 += 4;
        }
        if (byArray != null) {
            InitialToken.writeLittleEndian(byArray.length, byArray4, n4);
            System.arraycopy(byArray, 0, byArray4, n4 += 4, byArray.length);
            n4 += byArray.length;
        } else {
            n4 += 4;
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            return messageDigest.digest(byArray4);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new GSSException(11, -1, "Could not get MD5 Message Digest - " + noSuchAlgorithmException.getMessage());
        }
    }

    public abstract byte[] encode() throws IOException;

    protected class OverloadedChecksum {
        private byte[] checksumBytes = null;
        private Credentials delegCreds = null;
        private int flags = 0;

        public OverloadedChecksum(Krb5Context krb5Context, Credentials credentials, Credentials credentials2) throws KrbException, IOException, GSSException {
            Object object;
            Object object2;
            byte[] byArray = null;
            int n = 0;
            int n2 = 24;
            if (!credentials.isForwardable()) {
                krb5Context.setCredDelegState(false);
                krb5Context.setDelegPolicyState(false);
            } else if (krb5Context.getCredDelegState()) {
                if (krb5Context.getDelegPolicyState() && !credentials2.checkDelegate()) {
                    krb5Context.setDelegPolicyState(false);
                }
            } else if (krb5Context.getDelegPolicyState()) {
                if (credentials2.checkDelegate()) {
                    krb5Context.setCredDelegState(true);
                } else {
                    krb5Context.setDelegPolicyState(false);
                }
            }
            if (krb5Context.getCredDelegState()) {
                object2 = null;
                object = krb5Context.getCipherHelper(credentials2.getSessionKey());
                object2 = this.useNullKey((CipherHelper)object) ? new KrbCred(credentials, credentials2, EncryptionKey.NULL_KEY) : new KrbCred(credentials, credentials2, credentials2.getSessionKey());
                byArray = ((KrbCred)object2).getMessage();
                n2 += 4 + byArray.length;
            }
            this.checksumBytes = new byte[n2];
            this.checksumBytes[n++] = InitialToken.this.CHECKSUM_FIRST_BYTES[0];
            this.checksumBytes[n++] = InitialToken.this.CHECKSUM_FIRST_BYTES[1];
            this.checksumBytes[n++] = InitialToken.this.CHECKSUM_FIRST_BYTES[2];
            this.checksumBytes[n++] = InitialToken.this.CHECKSUM_FIRST_BYTES[3];
            object2 = krb5Context.getChannelBinding();
            if (object2 != null) {
                object = InitialToken.this.computeChannelBinding(krb5Context.getChannelBinding());
                System.arraycopy(object, 0, this.checksumBytes, n, ((Object)object).length);
            }
            n += 16;
            if (krb5Context.getCredDelegState()) {
                this.flags |= 1;
            }
            if (krb5Context.getMutualAuthState()) {
                this.flags |= 2;
            }
            if (krb5Context.getReplayDetState()) {
                this.flags |= 4;
            }
            if (krb5Context.getSequenceDetState()) {
                this.flags |= 8;
            }
            if (krb5Context.getIntegState()) {
                this.flags |= 0x20;
            }
            if (krb5Context.getConfState()) {
                this.flags |= 0x10;
            }
            object = new byte[4];
            GSSToken.writeLittleEndian(this.flags, (byte[])object);
            this.checksumBytes[n++] = (byte)object[0];
            this.checksumBytes[n++] = (byte)object[1];
            this.checksumBytes[n++] = (byte)object[2];
            this.checksumBytes[n++] = (byte)object[3];
            if (krb5Context.getCredDelegState()) {
                PrincipalName principalName = credentials2.getServer();
                StringBuffer stringBuffer = new StringBuffer("\"");
                stringBuffer.append(principalName.getName()).append('\"');
                String string = principalName.getRealmAsString();
                stringBuffer.append(" \"krbtgt/").append(string).append('@');
                stringBuffer.append(string).append('\"');
                SecurityManager securityManager = System.getSecurityManager();
                if (securityManager != null) {
                    DelegationPermission delegationPermission = new DelegationPermission(stringBuffer.toString());
                    securityManager.checkPermission(delegationPermission);
                }
                this.checksumBytes[n++] = 1;
                this.checksumBytes[n++] = 0;
                if (byArray.length > 65535) {
                    throw new GSSException(11, -1, "Incorrect message length");
                }
                GSSToken.writeLittleEndian(byArray.length, (byte[])object);
                this.checksumBytes[n++] = (byte)object[0];
                this.checksumBytes[n++] = (byte)object[1];
                System.arraycopy(byArray, 0, this.checksumBytes, n, byArray.length);
            }
        }

        public OverloadedChecksum(Krb5Context krb5Context, Checksum checksum, EncryptionKey encryptionKey, EncryptionKey encryptionKey2) throws GSSException, KrbException, IOException {
            Object object;
            byte[] byArray;
            boolean bl = false;
            if (checksum == null) {
                GSSException gSSException = new GSSException(11, -1, "No cksum in AP_REQ's authenticator");
                gSSException.initCause(new KrbException(50));
                throw gSSException;
            }
            this.checksumBytes = checksum.getBytes();
            if (this.checksumBytes[0] != InitialToken.this.CHECKSUM_FIRST_BYTES[0] || this.checksumBytes[1] != InitialToken.this.CHECKSUM_FIRST_BYTES[1] || this.checksumBytes[2] != InitialToken.this.CHECKSUM_FIRST_BYTES[2] || this.checksumBytes[3] != InitialToken.this.CHECKSUM_FIRST_BYTES[3]) {
                throw new GSSException(11, -1, "Incorrect checksum");
            }
            ChannelBinding channelBinding = krb5Context.getChannelBinding();
            if (channelBinding != null) {
                byte[] byArray2 = new byte[16];
                System.arraycopy(this.checksumBytes, 4, byArray2, 0, 16);
                byArray = new byte[16];
                if (!Arrays.equals(byArray, byArray2)) {
                    object = InitialToken.this.computeChannelBinding(channelBinding);
                    if (!Arrays.equals(object, byArray2)) {
                        throw new GSSException(1, -1, "Bytes mismatch!");
                    }
                } else {
                    throw new GSSException(1, -1, "Token missing ChannelBinding!");
                }
            }
            this.flags = GSSToken.readLittleEndian(this.checksumBytes, 20, 4);
            if ((this.flags & 1) > 0) {
                int n = GSSToken.readLittleEndian(this.checksumBytes, 26, 2);
                byArray = new byte[n];
                System.arraycopy(this.checksumBytes, 28, byArray, 0, n);
                try {
                    object = new KrbCred(byArray, encryptionKey);
                }
                catch (KrbException krbException) {
                    if (encryptionKey2 != null) {
                        object = new KrbCred(byArray, encryptionKey2);
                    }
                    throw krbException;
                }
                this.delegCreds = object.getDelegatedCreds()[0];
            }
        }

        private boolean useNullKey(CipherHelper cipherHelper) {
            boolean bl = true;
            if (cipherHelper.getProto() == 1 || cipherHelper.isArcFour()) {
                bl = false;
            }
            return bl;
        }

        public Checksum getChecksum() throws KrbException {
            return new Checksum(this.checksumBytes, 32771);
        }

        public Credentials getDelegatedCreds() {
            return this.delegCreds;
        }

        public void setContextFlags(Krb5Context krb5Context) {
            if ((this.flags & 1) > 0) {
                krb5Context.setCredDelegState(true);
            }
            if ((this.flags & 2) == 0) {
                krb5Context.setMutualAuthState(false);
            }
            if ((this.flags & 4) == 0) {
                krb5Context.setReplayDetState(false);
            }
            if ((this.flags & 8) == 0) {
                krb5Context.setSequenceDetState(false);
            }
            if ((this.flags & 0x10) == 0) {
                krb5Context.setConfState(false);
            }
            if ((this.flags & 0x20) == 0) {
                krb5Context.setIntegState(false);
            }
        }
    }
}

