/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Produce a binary image where foreground is the regional maxima of the
input image.


Regional maxima are flat zones surrounded by pixels of lower value.

If the input image is constant, the entire image can be considered as
a maxima or not. The desired behavior can be selected with the SetFlatIsMaxima() method.


Gaetan Lehmann
 This class was contributed to the Insight Journal by author Gaetan
Lehmann. Biologie du Developpement et de la Reproduction, INRA de
Jouy-en-Josas, France. The paper can be found at https://doi.org/10.54294/hva3gz


See:
 ValuedRegionalMaximaImageFilter

 HConvexImageFilter

 RegionalMinimaImageFilter

 itk::simple::RegionalMaxima for the procedural interface

 itk::RegionalMaximaImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkRegionalMaximaImageFilter.h
*/
public class RegionalMaximaImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected RegionalMaximaImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.RegionalMaximaImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(RegionalMaximaImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(RegionalMaximaImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::RegionalMaximaImageFilter::~RegionalMaximaImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_RegionalMaximaImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::RegionalMaximaImageFilter::RegionalMaximaImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  RegionalMaximaImageFilter() {
    this(SimpleITKJNI.new_RegionalMaximaImageFilter(), true);
  }

  /**
Self&amp; itk::simple::RegionalMaximaImageFilter::SetBackgroundValue(double BackgroundValue)

Set/Get the value used as "background" in the output image. Defaults
to NumericTraits&lt;PixelType&gt;::NonpositiveMin() .

*/
public  void setBackgroundValue(double BackgroundValue) {
    SimpleITKJNI.RegionalMaximaImageFilter_setBackgroundValue(swigCPtr, this, BackgroundValue);
  }

  /**
double itk::simple::RegionalMaximaImageFilter::GetBackgroundValue() const

Set/Get the value used as "background" in the output image. Defaults
to NumericTraits&lt;PixelType&gt;::NonpositiveMin() .

*/
public  double getBackgroundValue() {
    return SimpleITKJNI.RegionalMaximaImageFilter_getBackgroundValue(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::RegionalMaximaImageFilter::SetForegroundValue(double ForegroundValue)

Set/Get the value in the output image to consider as "foreground".
Defaults to maximum value of PixelType.

*/
public  void setForegroundValue(double ForegroundValue) {
    SimpleITKJNI.RegionalMaximaImageFilter_setForegroundValue(swigCPtr, this, ForegroundValue);
  }

  /**
double itk::simple::RegionalMaximaImageFilter::GetForegroundValue() const

Set/Get the value in the output image to consider as "foreground".
Defaults to maximum value of PixelType.

*/
public  double getForegroundValue() {
    return SimpleITKJNI.RegionalMaximaImageFilter_getForegroundValue(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::RegionalMaximaImageFilter::SetFullyConnected(bool FullyConnected)

Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.

*/
public  void setFullyConnected(boolean FullyConnected) {
    SimpleITKJNI.RegionalMaximaImageFilter_setFullyConnected(swigCPtr, this, FullyConnected);
  }

  /**
Self&amp; itk::simple::RegionalMaximaImageFilter::FullyConnectedOn()

Set the value of FullyConnected to true or false respectfully.

*/
public  void fullyConnectedOn() {
    SimpleITKJNI.RegionalMaximaImageFilter_fullyConnectedOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::RegionalMaximaImageFilter::FullyConnectedOff()
*/
public  void fullyConnectedOff() {
    SimpleITKJNI.RegionalMaximaImageFilter_fullyConnectedOff(swigCPtr, this);
  }

  /**
bool itk::simple::RegionalMaximaImageFilter::GetFullyConnected() const

Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.

*/
public  boolean getFullyConnected() {
    return SimpleITKJNI.RegionalMaximaImageFilter_getFullyConnected(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::RegionalMaximaImageFilter::SetFlatIsMaxima(bool FlatIsMaxima)

Set/Get whether a flat image must be considered as a maxima or not.
Defaults to true.

*/
public  void setFlatIsMaxima(boolean FlatIsMaxima) {
    SimpleITKJNI.RegionalMaximaImageFilter_setFlatIsMaxima(swigCPtr, this, FlatIsMaxima);
  }

  /**
Self&amp; itk::simple::RegionalMaximaImageFilter::FlatIsMaximaOn()

Set the value of FlatIsMaxima to true or false respectfully.

*/
public  void flatIsMaximaOn() {
    SimpleITKJNI.RegionalMaximaImageFilter_flatIsMaximaOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::RegionalMaximaImageFilter::FlatIsMaximaOff()
*/
public  void flatIsMaximaOff() {
    SimpleITKJNI.RegionalMaximaImageFilter_flatIsMaximaOff(swigCPtr, this);
  }

  /**
bool itk::simple::RegionalMaximaImageFilter::GetFlatIsMaxima() const

Set/Get whether a flat image must be considered as a maxima or not.
Defaults to true.

*/
public  boolean getFlatIsMaxima() {
    return SimpleITKJNI.RegionalMaximaImageFilter_getFlatIsMaxima(swigCPtr, this);
  }

  /**
std::string itk::simple::RegionalMaximaImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.RegionalMaximaImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::RegionalMaximaImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.RegionalMaximaImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::RegionalMaximaImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.RegionalMaximaImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
