/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language.syntax.selector;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.MultiplatformKt;
import org.jetbrains.plugins.textmate.language.syntax.lexer.TextMateScope;
import org.jetbrains.plugins.textmate.language.syntax.selector.TextMateSelectorLexer;
import org.jetbrains.plugins.textmate.language.syntax.selector.TextMateSelectorToken;
import org.jetbrains.plugins.textmate.language.syntax.selector.TextMateWeigh;
import org.jetbrains.plugins.textmate.logging.TextMateLogger;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u0000 \u00162\u00020\u0001:\u0006\u0016\u0017\u0018\u0019\u001a\u001bB\u0011\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ\n\u0010\r\u001a\u0004\u0018\u00010\fH\u0002J\n\u0010\u000e\u001a\u0004\u0018\u00010\fH\u0002J\n\u0010\u000f\u001a\u0004\u0018\u00010\fH\u0002J\n\u0010\u0010\u001a\u0004\u0018\u00010\fH\u0002J\n\u0010\u0011\u001a\u0004\u0018\u00010\bH\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/plugins/textmate/language/syntax/selector/TextMateSelectorParser;", "", "myHighlightingSelector", "", "<init>", "(Ljava/lang/CharSequence;)V", "myTokens", "", "Lorg/jetbrains/plugins/textmate/language/syntax/selector/TextMateSelectorToken;", "myIndex", "", "parse", "Lorg/jetbrains/plugins/textmate/language/syntax/selector/TextMateSelectorParser$Node;", "parseSelectorList", "parseConjunction", "parseScopeSelector", "parseSelector", "getCurrentToken", "advance", "", "eof", "", "Companion", "Node", "Selector", "ScopeSelector", "SelectorList", "Conjunction", "intellij.textmate.core"})
public final class TextMateSelectorParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CharSequence myHighlightingSelector;
    @NotNull
    private final List<TextMateSelectorToken> myTokens;
    private int myIndex;
    @NotNull
    private static final TextMateLogger LOG = MultiplatformKt.getLogger(Reflection.getOrCreateKotlinClass(TextMateSelectorParser.class));
    private static final int NESTING_WEIGH_INITIAL = 100;
    private static final int BASE_WEIGH = 1000;

    public TextMateSelectorParser(@NotNull CharSequence myHighlightingSelector) {
        Intrinsics.checkNotNullParameter((Object)myHighlightingSelector, (String)"myHighlightingSelector");
        this.myHighlightingSelector = myHighlightingSelector;
        this.myTokens = TextMateSelectorLexer.INSTANCE.tokenize(this.myHighlightingSelector);
    }

    @Nullable
    public final Node parse() {
        Node result = this.parseSelectorList();
        if (!this.eof()) {
            LOG.error((Function0<String>)((Function0)() -> TextMateSelectorParser.parse$lambda$0(this)));
        }
        return result;
    }

    private final Node parseSelectorList() {
        List list;
        Node node = this.parseConjunction();
        if (node == null || !Intrinsics.areEqual((Object)this.getCurrentToken(), (Object)TextMateSelectorToken.Companion.getCOMMA())) {
            return node;
        }
        List $this$parseSelectorList_u24lambda_u241 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        $this$parseSelectorList_u24lambda_u241.add(node);
        while (Intrinsics.areEqual((Object)this.getCurrentToken(), (Object)TextMateSelectorToken.Companion.getCOMMA())) {
            this.advance();
            Node child = this.parseConjunction();
            if (child == null) break;
            $this$parseSelectorList_u24lambda_u241.add(child);
        }
        List list2 = CollectionsKt.build((List)list);
        return new SelectorList(list2);
    }

    private final Node parseConjunction() {
        List list;
        Node node = this.parseScopeSelector();
        if (node == null || !Intrinsics.areEqual((Object)this.getCurrentToken(), (Object)TextMateSelectorToken.Companion.getPIPE())) {
            return node;
        }
        List $this$parseConjunction_u24lambda_u242 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        $this$parseConjunction_u24lambda_u242.add(node);
        while (Intrinsics.areEqual((Object)this.getCurrentToken(), (Object)TextMateSelectorToken.Companion.getPIPE())) {
            this.advance();
            Node child = this.parseScopeSelector();
            if (child == null) break;
            $this$parseConjunction_u24lambda_u242.add(child);
        }
        List list2 = CollectionsKt.build((List)list);
        return new Conjunction(list2);
    }

    private final Node parseScopeSelector() {
        TextMateWeigh.Priority priority;
        TextMateSelectorToken token = this.getCurrentToken();
        if (token instanceof TextMateSelectorToken.PriorityToken) {
            this.advance();
            priority = ((TextMateSelectorToken.PriorityToken)token).getPriority();
        } else {
            priority = TextMateWeigh.Priority.NORMAL;
        }
        TextMateWeigh.Priority priority2 = priority;
        boolean startMatch = Intrinsics.areEqual((Object)this.getCurrentToken(), (Object)TextMateSelectorToken.Companion.getHAT());
        if (startMatch) {
            this.advance();
        }
        List children = new ArrayList();
        List exclusions = new ArrayList();
        Node next = this.parseSelector();
        while (next != null) {
            children.add(next);
            next = this.parseSelector();
        }
        while (Intrinsics.areEqual((Object)this.getCurrentToken(), (Object)TextMateSelectorToken.Companion.getMINUS())) {
            this.advance();
            Node exclusion = this.parseScopeSelector();
            if (exclusion == null) continue;
            exclusions.add(exclusion);
        }
        return !((Collection)children).isEmpty() || !((Collection)exclusions).isEmpty() ? (Node)new ScopeSelector(children, exclusions, startMatch, priority2) : null;
    }

    private final Node parseSelector() {
        Node node;
        TextMateSelectorToken token = this.getCurrentToken();
        if (Intrinsics.areEqual((Object)token, (Object)TextMateSelectorToken.Companion.getLPAREN())) {
            this.advance();
            Node result = this.parseSelectorList();
            if (Intrinsics.areEqual((Object)this.getCurrentToken(), (Object)TextMateSelectorToken.Companion.getRPAREN())) {
                this.advance();
            }
            return result;
        }
        if (token instanceof TextMateSelectorToken.SelectorToken) {
            this.advance();
            node = new Selector(((TextMateSelectorToken.SelectorToken)token).getText());
        } else {
            node = null;
        }
        return node;
    }

    private final TextMateSelectorToken getCurrentToken() {
        return this.myIndex < this.myTokens.size() ? this.myTokens.get(this.myIndex) : null;
    }

    private final void advance() {
        int n = this.myIndex;
        this.myIndex = n + 1;
    }

    private final boolean eof() {
        return this.myIndex >= this.myTokens.size();
    }

    private static final String parse$lambda$0(TextMateSelectorParser this$0) {
        return "Cannot parse highlighting selector: " + this$0.myHighlightingSelector;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/plugins/textmate/language/syntax/selector/TextMateSelectorParser$Companion;", "", "<init>", "()V", "LOG", "Lorg/jetbrains/plugins/textmate/logging/TextMateLogger;", "NESTING_WEIGH_INITIAL", "", "BASE_WEIGH", "intellij.textmate.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/textmate/language/syntax/selector/TextMateSelectorParser$Conjunction;", "Lorg/jetbrains/plugins/textmate/language/syntax/selector/TextMateSelectorParser$Node;", "children", "", "<init>", "(Ljava/util/List;)V", "weigh", "Lorg/jetbrains/plugins/textmate/language/syntax/selector/TextMateWeigh;", "scope", "Lorg/jetbrains/plugins/textmate/language/syntax/lexer/TextMateScope;", "intellij.textmate.core"})
    @SourceDebugExtension(value={"SMAP\nTextMateSelectorParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextMateSelectorParser.kt\norg/jetbrains/plugins/textmate/language/syntax/selector/TextMateSelectorParser$Conjunction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,219:1\n1563#2:220\n1634#2,3:221\n295#2,2:224\n*S KotlinDebug\n*F\n+ 1 TextMateSelectorParser.kt\norg/jetbrains/plugins/textmate/language/syntax/selector/TextMateSelectorParser$Conjunction\n*L\n215#1:220\n215#1:221,3\n215#1:224,2\n*E\n"})
    private static final class Conjunction
    implements Node {
        @NotNull
        private final List<Node> children;

        public Conjunction(@NotNull List<? extends Node> children) {
            Intrinsics.checkNotNullParameter(children, (String)"children");
            this.children = children;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public TextMateWeigh weigh(@NotNull TextMateScope scope) {
            TextMateWeigh textMateWeigh;
            Object v0;
            block3: {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
                Iterable $this$map$iv = this.children;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Node node = (Node)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.weigh(scope));
                }
                Iterable $this$firstOrNull$iv = (List)destination$iv$iv;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    TextMateWeigh it = (TextMateWeigh)element$iv;
                    boolean bl = false;
                    if (!(it.getWeigh() > 0)) continue;
                    v0 = element$iv;
                    break block3;
                }
                v0 = null;
            }
            if ((textMateWeigh = (TextMateWeigh)v0) == null) {
                textMateWeigh = TextMateWeigh.Companion.getZERO();
            }
            return textMateWeigh;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0006\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/plugins/textmate/language/syntax/selector/TextMateSelectorParser$Node;", "", "weigh", "Lorg/jetbrains/plugins/textmate/language/syntax/selector/TextMateWeigh;", "scope", "Lorg/jetbrains/plugins/textmate/language/syntax/lexer/TextMateScope;", "intellij.textmate.core"})
    public static interface Node {
        @NotNull
        public TextMateWeigh weigh(@NotNull TextMateScope var1);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B3\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/plugins/textmate/language/syntax/selector/TextMateSelectorParser$ScopeSelector;", "Lorg/jetbrains/plugins/textmate/language/syntax/selector/TextMateSelectorParser$Node;", "children", "", "exclusions", "startMatch", "", "priority", "Lorg/jetbrains/plugins/textmate/language/syntax/selector/TextMateWeigh$Priority;", "<init>", "(Ljava/util/List;Ljava/util/List;ZLorg/jetbrains/plugins/textmate/language/syntax/selector/TextMateWeigh$Priority;)V", "weigh", "Lorg/jetbrains/plugins/textmate/language/syntax/selector/TextMateWeigh;", "scope", "Lorg/jetbrains/plugins/textmate/language/syntax/lexer/TextMateScope;", "intellij.textmate.core"})
    private static final class ScopeSelector
    implements Node {
        @NotNull
        private final List<Node> children;
        @NotNull
        private final List<Node> exclusions;
        private final boolean startMatch;
        @NotNull
        private final TextMateWeigh.Priority priority;

        public ScopeSelector(@NotNull List<? extends Node> children, @NotNull List<? extends Node> exclusions, boolean startMatch, @NotNull TextMateWeigh.Priority priority) {
            Intrinsics.checkNotNullParameter(children, (String)"children");
            Intrinsics.checkNotNullParameter(exclusions, (String)"exclusions");
            Intrinsics.checkNotNullParameter((Object)((Object)priority), (String)"priority");
            this.children = children;
            this.exclusions = exclusions;
            this.startMatch = startMatch;
            this.priority = priority;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public TextMateWeigh weigh(@NotNull TextMateScope scope) {
            void var3_6;
            Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
            for (Node node : this.exclusions) {
                if (node.weigh(scope).getWeigh() <= 0) continue;
                return TextMateWeigh.Companion.getZERO();
            }
            if (scope.getLevel() > 100) {
                return TextMateWeigh.Companion.getZERO();
            }
            ArrayDeque highlightingSelectors = new ArrayDeque();
            for (Node child : this.children) {
                highlightingSelectors.addLast((Object)child);
            }
            if (highlightingSelectors.isEmpty()) {
                highlightingSelectors.addLast((Object)new Selector(""));
            }
            TextMateScope textMateScope = scope;
            Node currentHighlightingSelector = (Node)highlightingSelectors.last();
            int nestingWeigh = 100;
            int result = 0;
            while (!highlightingSelectors.isEmpty() && var3_6 != null) {
                TextMateWeigh weigh;
                TextMateWeigh textMateWeigh = weigh = currentHighlightingSelector instanceof Selector ? ((Selector)currentHighlightingSelector).weigh((TextMateScope)var3_6) : currentHighlightingSelector.weigh(scope);
                if (weigh.getWeigh() > 0) {
                    result += weigh.getWeigh() * nestingWeigh;
                    highlightingSelectors.removeLast();
                    if (!highlightingSelectors.isEmpty()) {
                        currentHighlightingSelector = (Node)highlightingSelectors.last();
                    }
                }
                --nestingWeigh;
                TextMateScope textMateScope2 = var3_6.getParent();
            }
            if (!highlightingSelectors.isEmpty()) {
                return TextMateWeigh.Companion.getZERO();
            }
            return new TextMateWeigh(!this.startMatch || var3_6 == null || var3_6.isEmpty() ? result : 0, this.priority);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/textmate/language/syntax/selector/TextMateSelectorParser$Selector;", "Lorg/jetbrains/plugins/textmate/language/syntax/selector/TextMateSelectorParser$Node;", "selector", "", "<init>", "(Ljava/lang/String;)V", "weigh", "Lorg/jetbrains/plugins/textmate/language/syntax/selector/TextMateWeigh;", "scope", "Lorg/jetbrains/plugins/textmate/language/syntax/lexer/TextMateScope;", "intellij.textmate.core"})
    @SourceDebugExtension(value={"SMAP\nTextMateSelectorParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextMateSelectorParser.kt\norg/jetbrains/plugins/textmate/language/syntax/selector/TextMateSelectorParser$Selector\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,219:1\n1104#2,3:220\n*S KotlinDebug\n*F\n+ 1 TextMateSelectorParser.kt\norg/jetbrains/plugins/textmate/language/syntax/selector/TextMateSelectorParser$Selector\n*L\n142#1:220,3\n*E\n"})
    private static final class Selector
    implements Node {
        @NotNull
        private final String selector;

        public Selector(@NotNull String selector) {
            Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
            this.selector = selector;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public TextMateWeigh weigh(@NotNull TextMateScope scope) {
            Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
            CharSequence scopeName = scope.getScopeName();
            if (scopeName != null && (((CharSequence)this.selector).length() == 0 || StringsKt.startsWith$default((CharSequence)scopeName, (CharSequence)(this.selector + "."), (boolean)false, (int)2, null) || StringsKt.contentEquals((CharSequence)scopeName, (CharSequence)this.selector))) {
                void $this$count$iv;
                CharSequence charSequence = this.selector;
                int n = 1000 - scope.getDotsCount();
                boolean $i$f$count = false;
                int count$iv = 0;
                for (int i = 0; i < $this$count$iv.length(); ++i) {
                    char element$iv;
                    char it = element$iv = $this$count$iv.charAt(i);
                    boolean bl = false;
                    if (!(it == '.')) continue;
                    ++count$iv;
                }
                int n2 = count$iv;
                TextMateWeigh.Priority priority = TextMateWeigh.Priority.NORMAL;
                int n3 = n + n2;
                return new TextMateWeigh(n3, priority);
            }
            return TextMateWeigh.Companion.getZERO();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/textmate/language/syntax/selector/TextMateSelectorParser$SelectorList;", "Lorg/jetbrains/plugins/textmate/language/syntax/selector/TextMateSelectorParser$Node;", "children", "", "<init>", "(Ljava/util/List;)V", "weigh", "Lorg/jetbrains/plugins/textmate/language/syntax/selector/TextMateWeigh;", "scope", "Lorg/jetbrains/plugins/textmate/language/syntax/lexer/TextMateScope;", "intellij.textmate.core"})
    @SourceDebugExtension(value={"SMAP\nTextMateSelectorParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextMateSelectorParser.kt\norg/jetbrains/plugins/textmate/language/syntax/selector/TextMateSelectorParser$SelectorList\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,219:1\n1#2:220\n*E\n"})
    private static final class SelectorList
    implements Node {
        @NotNull
        private final List<Node> children;

        public SelectorList(@NotNull List<? extends Node> children) {
            Intrinsics.checkNotNullParameter(children, (String)"children");
            this.children = children;
        }

        @Override
        @NotNull
        public TextMateWeigh weigh(@NotNull TextMateScope scope) {
            TextMateWeigh textMateWeigh;
            Comparable comparable;
            Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
            Iterator iterator = ((Iterable)this.children).iterator();
            if (!iterator.hasNext()) {
                comparable = null;
            } else {
                Node it = (Node)iterator.next();
                boolean bl = false;
                Comparable comparable2 = it.weigh(scope);
                while (iterator.hasNext()) {
                    Node it2 = (Node)iterator.next();
                    $i$a$-maxOfOrNull-TextMateSelectorParser$SelectorList$weigh$1 = false;
                    Comparable comparable3 = it2.weigh(scope);
                    if (comparable2.compareTo(comparable3) >= 0) continue;
                    comparable2 = comparable3;
                }
                comparable = comparable2;
            }
            if ((textMateWeigh = (TextMateWeigh)comparable) == null) {
                textMateWeigh = TextMateWeigh.Companion.getZERO();
            }
            return textMateWeigh;
        }
    }
}

