/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.jetbrains.performancePlugin.commands.AbstractFileCommand;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/performancePlugin/commands/AddFileCommand;", "Lcom/jetbrains/performancePlugin/commands/AbstractFileCommand;", "text", "", "line", "", "<init>", "(Ljava/lang/String;I)V", "execute", "", "callback", "Lcom/intellij/openapi/util/ActionCallback;", "context", "Lcom/intellij/openapi/ui/playback/PlaybackContext;", "Companion", "intellij.performanceTesting"})
@SourceDebugExtension(value={"SMAP\nAddFileCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AddFileCommand.kt\ncom/jetbrains/performancePlugin/commands/AddFileCommand\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,60:1\n14#2:61\n*S KotlinDebug\n*F\n+ 1 AddFileCommand.kt\ncom/jetbrains/performancePlugin/commands/AddFileCommand\n*L\n57#1:61\n*E\n"})
public final class AddFileCommand
extends AbstractFileCommand {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;
    @NotNull
    public static final String PREFIX = "%addFile";

    public AddFileCommand(@NotNull String text, int line) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        super(text, line, 0, 4, null);
    }

    @Override
    protected void execute(@NotNull ActionCallback callback2, @NotNull PlaybackContext context) throws Exception {
        Intrinsics.checkNotNullParameter((Object)callback2, (String)"callback");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ArrayList input = this.extractCommandList(PREFIX, ",");
        Intrinsics.checkNotNull((Object)input);
        if (!this.isCommandParametersRight(input)) {
            callback2.reject("Command %addFile should have 2 non empty parameters (1 - path to directory, 2 - file name) with delimiter ','.");
            return;
        }
        String[] stringArray = new String[]{input.get(1)};
        if (VirtualFileManager.getInstance().findFileByNioPath(Paths.get((String)input.get(0), stringArray)) != null) {
            stringArray = new String[]{input.get(1)};
            callback2.reject("File by " + Paths.get((String)input.get(0), stringArray) + " path from parameters already exists.");
            return;
        }
        LOG.info("Add file " + input.get(1) + " " + input.get(0));
        Path path = Paths.get((String)input.get(0), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        super.execute(path, callback2, (Function1<? super VirtualFile, ? extends Object>)((Function1)arg_0 -> AddFileCommand.execute$lambda$0(input, arg_0)));
    }

    private static final Object execute$lambda$0(ArrayList $input, VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        VirtualFile virtualFile2 = virtualFile.createChildData(null, (String)$input.get(1));
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"createChildData(...)");
        return virtualFile2;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(AddFileCommand.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/jetbrains/performancePlugin/commands/AddFileCommand$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "PREFIX", "", "Lorg/jetbrains/annotations/NonNls;", "intellij.performanceTesting"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

