/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Random;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class CommandLineWrapperUtil {
    public static final String CLASSPATH_JAR_FILE_NAME_PREFIX = "classpath";

    @NotNull
    public static File createClasspathJarFile(@NotNull Manifest manifest, @NotNull List<String> pathList) throws IOException {
        if (manifest == null) {
            CommandLineWrapperUtil.$$$reportNull$$$0(0);
        }
        if (pathList == null) {
            CommandLineWrapperUtil.$$$reportNull$$$0(1);
        }
        File file = FileUtil.createTempFile(CLASSPATH_JAR_FILE_NAME_PREFIX + Math.abs(new Random().nextInt(Integer.MAX_VALUE)), ".jar", true);
        CommandLineWrapperUtil.fillClasspathJarFile(manifest, pathList, false, file);
        File file2 = file;
        if (file2 == null) {
            CommandLineWrapperUtil.$$$reportNull$$$0(2);
        }
        return file2;
    }

    public static void fillClasspathJarFile(Manifest manifest, List<String> pathList, boolean notEscape, @NotNull File outputJar) throws IOException {
        if (outputJar == null) {
            CommandLineWrapperUtil.$$$reportNull$$$0(3);
        }
        StringBuilder classPath = new StringBuilder();
        for (String path : pathList) {
            if (classPath.length() > 0) {
                classPath.append(' ');
            }
            File classpathElement = new File(path);
            String url = (notEscape ? classpathElement.toURL() : classpathElement.toURI().toURL()).toString();
            classPath.append(url);
        }
        CommandLineWrapperUtil.fillClasspathJarFile(manifest, classPath.toString(), outputJar);
    }

    public static void fillClasspathJarFile(Manifest manifest, String classPath, @NotNull File outputJar) throws IOException {
        if (outputJar == null) {
            CommandLineWrapperUtil.$$$reportNull$$$0(4);
        }
        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        manifest.getMainAttributes().put(Attributes.Name.CLASS_PATH, classPath);
        new JarOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(outputJar)), manifest).close();
    }

    @NotNull
    public static File createArgumentFile(@NotNull List<String> args, @NotNull Charset cs) throws IOException {
        if (args == null) {
            CommandLineWrapperUtil.$$$reportNull$$$0(5);
        }
        if (cs == null) {
            CommandLineWrapperUtil.$$$reportNull$$$0(6);
        }
        File argFile = FileUtil.createTempFile("idea_arg_file" + new Random().nextInt(Integer.MAX_VALUE), null, true);
        CommandLineWrapperUtil.writeArgumentsFile(argFile, args, cs);
        File file = argFile;
        if (file == null) {
            CommandLineWrapperUtil.$$$reportNull$$$0(7);
        }
        return file;
    }

    public static void writeArgumentsFile(@NotNull File argFile, @NotNull List<String> args, @NotNull Charset cs) throws IOException {
        if (argFile == null) {
            CommandLineWrapperUtil.$$$reportNull$$$0(8);
        }
        if (args == null) {
            CommandLineWrapperUtil.$$$reportNull$$$0(9);
        }
        if (cs == null) {
            CommandLineWrapperUtil.$$$reportNull$$$0(10);
        }
        CommandLineWrapperUtil.writeArgumentsFile(argFile, args, System.lineSeparator(), cs);
    }

    public static void writeArgumentsFile(@NotNull File argFile, @NotNull List<String> args, String lineSeparator, @NotNull Charset cs) throws IOException {
        if (argFile == null) {
            CommandLineWrapperUtil.$$$reportNull$$$0(11);
        }
        if (args == null) {
            CommandLineWrapperUtil.$$$reportNull$$$0(12);
        }
        if (cs == null) {
            CommandLineWrapperUtil.$$$reportNull$$$0(13);
        }
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(argFile), cs));){
            for (String arg : args) {
                writer.write(CommandLineWrapperUtil.quoteArg(arg));
                writer.write(lineSeparator);
            }
        }
    }

    public static String quoteArg(String arg) {
        String specials = " #'\"\n\r\t\f";
        if (!StringUtil.containsAnyChar(arg, specials)) {
            return arg;
        }
        @NonNls StringBuilder sb = new StringBuilder(arg.length() * 2);
        for (int i = 0; i < arg.length(); ++i) {
            char c = arg.charAt(i);
            if (c == ' ' || c == '#' || c == '\'') {
                sb.append('\"').append(c).append('\"');
                continue;
            }
            if (c == '\"') {
                sb.append("\"\\\"\"");
                continue;
            }
            if (c == '\n') {
                sb.append("\"\\n\"");
                continue;
            }
            if (c == '\r') {
                sb.append("\"\\r\"");
                continue;
            }
            if (c == '\t') {
                sb.append("\"\\t\"");
                continue;
            }
            if (c == '\f') {
                sb.append("\"\\f\"");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    @NotNull
    public static File createWrapperFile(@NotNull List<String> classpath, @NotNull Charset cs) throws IOException {
        if (classpath == null) {
            CommandLineWrapperUtil.$$$reportNull$$$0(14);
        }
        if (cs == null) {
            CommandLineWrapperUtil.$$$reportNull$$$0(15);
        }
        File file = FileUtil.createTempFile(CLASSPATH_JAR_FILE_NAME_PREFIX + new Random().nextInt(Integer.MAX_VALUE), null, true);
        CommandLineWrapperUtil.writeWrapperFile(file, classpath, System.lineSeparator(), cs);
        File file2 = file;
        if (file2 == null) {
            CommandLineWrapperUtil.$$$reportNull$$$0(16);
        }
        return file2;
    }

    public static void writeWrapperFile(@NotNull File wrapperFile, @NotNull List<String> classpath, @NotNull String lineSeparator, @NotNull Charset cs) throws IOException {
        if (wrapperFile == null) {
            CommandLineWrapperUtil.$$$reportNull$$$0(17);
        }
        if (classpath == null) {
            CommandLineWrapperUtil.$$$reportNull$$$0(18);
        }
        if (lineSeparator == null) {
            CommandLineWrapperUtil.$$$reportNull$$$0(19);
        }
        if (cs == null) {
            CommandLineWrapperUtil.$$$reportNull$$$0(20);
        }
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(wrapperFile), cs));){
            for (String path : classpath) {
                writer.write(path);
                writer.write(lineSeparator);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 7: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 7: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manifest";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathList";
                break;
            }
            case 2: 
            case 7: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/CommandLineWrapperUtil";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputJar";
                break;
            }
            case 5: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 6: 
            case 10: 
            case 13: 
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cs";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argFile";
                break;
            }
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = CLASSPATH_JAR_FILE_NAME_PREFIX;
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrapperFile";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineSeparator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/CommandLineWrapperUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createClasspathJarFile";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createArgumentFile";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createWrapperFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createClasspathJarFile";
                break;
            }
            case 2: 
            case 7: 
            case 16: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "fillClasspathJarFile";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createArgumentFile";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "writeArgumentsFile";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createWrapperFile";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "writeWrapperFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 7: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

