/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.test;

import com.intellij.analysis.JvmAnalysisBundle;
import com.intellij.codeInsight.TestFrameworks;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHolderUtilKt;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.siyeh.ig.psiutils.MethodMatcher;
import com.siyeh.ig.psiutils.TestUtils;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UObjectLiteralExpression;
import org.jetbrains.uast.UResolvable;
import org.jetbrains.uast.UResolvableKt;
import org.jetbrains.uast.visitor.AbstractUastNonRecursiveVisitor;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0012B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\rH\u0002J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/codeInspection/test/TestMethodWithoutAssertionVisitor;", "Lorg/jetbrains/uast/visitor/AbstractUastNonRecursiveVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "methodMatcher", "Lcom/siyeh/ig/psiutils/MethodMatcher;", "assertKeywordIsAssertion", "", "ignoreIfExceptionThrown", "<init>", "(Lcom/intellij/codeInspection/ProblemsHolder;Lcom/siyeh/ig/psiutils/MethodMatcher;ZZ)V", "visitMethod", "node", "Lorg/jetbrains/uast/UMethod;", "lastStatementIsCallToMethodWithAssertion", "method", "containsAssertion", "element", "ContainsAssertionVisitor", "intellij.jvm.analysis.impl"})
@SourceDebugExtension(value={"SMAP\nTestMethodWithoutAssertionInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TestMethodWithoutAssertionInspection.kt\ncom/intellij/codeInspection/test/TestMethodWithoutAssertionVisitor\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 UResolvable.kt\norg/jetbrains/uast/UResolvableKt\n*L\n1#1,134:1\n19#2:135\n19#2:136\n43#3:137\n*S KotlinDebug\n*F\n+ 1 TestMethodWithoutAssertionInspection.kt\ncom/intellij/codeInspection/test/TestMethodWithoutAssertionVisitor\n*L\n100#1:135\n103#1:136\n104#1:137\n*E\n"})
final class TestMethodWithoutAssertionVisitor
extends AbstractUastNonRecursiveVisitor {
    @NotNull
    private final ProblemsHolder holder;
    @NotNull
    private final MethodMatcher methodMatcher;
    private final boolean assertKeywordIsAssertion;
    private final boolean ignoreIfExceptionThrown;

    public TestMethodWithoutAssertionVisitor(@NotNull ProblemsHolder holder, @NotNull MethodMatcher methodMatcher, boolean assertKeywordIsAssertion, boolean ignoreIfExceptionThrown) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)methodMatcher, (String)"methodMatcher");
        this.holder = holder;
        this.methodMatcher = methodMatcher;
        this.assertKeywordIsAssertion = assertKeywordIsAssertion;
        this.ignoreIfExceptionThrown = ignoreIfExceptionThrown;
    }

    public boolean visitMethod(@NotNull UMethod node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        PsiMethod javaMethod = node.getJavaPsi();
        if (!TestFrameworks.getInstance().isTestMethod(javaMethod)) {
            return true;
        }
        if (TestUtils.hasExpectedExceptionAnnotation((PsiMethod)javaMethod)) {
            return true;
        }
        if (this.ignoreIfExceptionThrown) {
            PsiJavaCodeReferenceElement[] psiJavaCodeReferenceElementArray = javaMethod.getThrowsList().getReferenceElements();
            Intrinsics.checkNotNullExpressionValue((Object)psiJavaCodeReferenceElementArray, (String)"getReferenceElements(...)");
            if (!(((Object[])psiJavaCodeReferenceElementArray).length == 0)) {
                return true;
            }
        }
        if (this.containsAssertion(node)) {
            return true;
        }
        if (this.lastStatementIsCallToMethodWithAssertion(node)) {
            return true;
        }
        String message = JvmAnalysisBundle.message("jvm.inspections.test.method.without.assertion.problem.descriptor", new Object[0]);
        UDeclaration uDeclaration = (UDeclaration)node;
        Intrinsics.checkNotNull((Object)message);
        ProblemHolderUtilKt.registerUProblem$default((ProblemsHolder)this.holder, (UDeclaration)uDeclaration, (String)message, (LocalQuickFix[])new LocalQuickFix[0], null, (int)8, null);
        return true;
    }

    private final boolean lastStatementIsCallToMethodWithAssertion(UMethod method) {
        UExpression lastExpression;
        Object object;
        if (method.getUastBody() instanceof UBlockExpression) {
            Object object2;
            UExpression $this$asSafely$iv = method.getUastBody();
            boolean $i$f$asSafely = false;
            UExpression uExpression = $this$asSafely$iv;
            if (!(uExpression instanceof UBlockExpression)) {
                uExpression = null;
            }
            object = (object2 = (UBlockExpression)uExpression) != null && (object2 = object2.getExpressions()) != null ? (UExpression)CollectionsKt.lastOrNull((List)object2) : null;
        } else {
            object = method.getUastBody();
        }
        if (object == null) {
            return false;
        }
        UExpression $this$asSafely$iv = lastExpression = object;
        boolean $i$f$asSafely = false;
        UExpression uExpression = $this$asSafely$iv;
        if (!(uExpression instanceof UCallExpression)) {
            uExpression = null;
        }
        UCallExpression uCallExpression = (UCallExpression)uExpression;
        if (uCallExpression == null) {
            return false;
        }
        UCallExpression callExpression = uCallExpression;
        UResolvable $this$resolveToUElementOfType$iv = (UResolvable)callExpression;
        boolean $i$f$resolveToUElementOfType = false;
        UElement uElement = UResolvableKt.resolveToUElement((UResolvable)$this$resolveToUElementOfType$iv);
        if (!(uElement instanceof UMethod)) {
            uElement = null;
        }
        UMethod uMethod = (UMethod)((UElement)((UMethod)uElement));
        if (uMethod == null) {
            return false;
        }
        UMethod targetMethod = uMethod;
        return this.containsAssertion(targetMethod);
    }

    private final boolean containsAssertion(UMethod element) {
        ContainsAssertionVisitor visitor2;
        block0: {
            visitor2 = new ContainsAssertionVisitor();
            UExpression uExpression = element.getUastBody();
            if (uExpression == null) break block0;
            uExpression.accept((UastVisitor)visitor2);
        }
        return visitor2.getContainsAssertion();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0010H\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u0011"}, d2={"Lcom/intellij/codeInspection/test/TestMethodWithoutAssertionVisitor$ContainsAssertionVisitor;", "Lorg/jetbrains/uast/visitor/AbstractUastVisitor;", "<init>", "(Lcom/intellij/codeInspection/test/TestMethodWithoutAssertionVisitor;)V", "containsAssertion", "", "getContainsAssertion", "()Z", "setContainsAssertion", "(Z)V", "visitElement", "node", "Lorg/jetbrains/uast/UElement;", "visitObjectLiteralExpression", "Lorg/jetbrains/uast/UObjectLiteralExpression;", "visitCallExpression", "Lorg/jetbrains/uast/UCallExpression;", "intellij.jvm.analysis.impl"})
    private final class ContainsAssertionVisitor
    extends AbstractUastVisitor {
        private boolean containsAssertion;

        public final boolean getContainsAssertion() {
            return this.containsAssertion;
        }

        public final void setContainsAssertion(boolean bl) {
            this.containsAssertion = bl;
        }

        public boolean visitElement(@NotNull UElement node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            if (this.containsAssertion) {
                return true;
            }
            return node.getSourcePsi() instanceof PsiCompiledElement;
        }

        public boolean visitObjectLiteralExpression(@NotNull UObjectLiteralExpression node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            return this.visitCallExpression((UCallExpression)node);
        }

        public boolean visitCallExpression(@NotNull UCallExpression node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            if (this.containsAssertion) {
                return true;
            }
            if (TestMethodWithoutAssertionVisitor.this.assertKeywordIsAssertion && node.getMethodIdentifier() == null && Intrinsics.areEqual((Object)node.getMethodName(), (Object)"assert") || TestMethodWithoutAssertionVisitor.this.methodMatcher.matches(node.resolve())) {
                this.containsAssertion = true;
                return true;
            }
            return false;
        }
    }
}

