/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.starters;

import com.intellij.ide.starters.StarterModuleImporter;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.project.MavenProjectsManager;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u001e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u0013H\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/idea/maven/starters/MavenStarterModuleImporter;", "Lcom/intellij/ide/starters/StarterModuleImporter;", "<init>", "()V", "id", "", "getId", "()Ljava/lang/String;", "title", "getTitle", "runAfterSetup", "", "module", "Lcom/intellij/openapi/module/Module;", "collectPomXml", "", "directoryFrom", "Lcom/intellij/openapi/vfs/VirtualFile;", "collectionInto", "", "intellij.maven"})
public final class MavenStarterModuleImporter
implements StarterModuleImporter {
    @NotNull
    private final String id;
    @NotNull
    private final String title;

    public MavenStarterModuleImporter() {
        this.id = "maven";
        this.title = "Maven";
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public String getTitle() {
        return this.title;
    }

    public boolean runAfterSetup(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        List pomXMLs = new ArrayList();
        for (VirtualFile contentRoot : ModuleRootManager.getInstance((Module)module).getContentRoots()) {
            Intrinsics.checkNotNull((Object)contentRoot);
            this.collectPomXml(contentRoot, pomXMLs);
            if (!((Collection)pomXMLs).isEmpty()) break;
        }
        if (pomXMLs.isEmpty()) {
            for (VirtualFile contentRoot : ModuleRootManager.getInstance((Module)module).getContentRoots()) {
                Iterator iterator = ArrayIteratorKt.iterator((Object[])contentRoot.getChildren());
                while (iterator.hasNext()) {
                    VirtualFile child = (VirtualFile)iterator.next();
                    if (!child.isDirectory()) continue;
                    Intrinsics.checkNotNull((Object)child);
                    this.collectPomXml(child, pomXMLs);
                }
            }
        }
        if (pomXMLs.isEmpty()) {
            return true;
        }
        MavenProjectsManager mavenProjectsManager = MavenProjectsManager.getInstance(project2);
        mavenProjectsManager.addManagedFiles(pomXMLs);
        return false;
    }

    private final void collectPomXml(VirtualFile directoryFrom, Collection<VirtualFile> collectionInto) {
        VirtualFile child = directoryFrom.findChild("pom.xml");
        if (child != null) {
            collectionInto.add(child);
        }
    }
}

