/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.collaboration.api.httpclient;

import com.intellij.collaboration.api.HttpApiHelperKt;
import com.intellij.collaboration.api.HttpStatusErrorException;
import com.intellij.collaboration.api.httpclient.InflatedStreamReadingBodyHandler;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0013H\u0002JE\u0010\u0017\u001a\u0002H\u0018\"\u0004\b\u0000\u0010\u00182\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0012\u001a\u00020\u00132\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u0002H\u00180\u001e\u00a2\u0006\u0002\u0010\u001fJ<\u0010 \u001a\b\u0012\u0004\u0012\u0002H\u00180!\"\u0004\b\u0000\u0010\u00182\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u001a2\u0018\u0010\"\u001a\u0014\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u0002H\u00180#J\u000e\u0010$\u001a\u00020\u00052\u0006\u0010%\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/intellij/collaboration/api/httpclient/HttpClientUtil;", "", "<init>", "()V", "ACCEPT_ENCODING_HEADER", "", "CONTENT_ENCODING_HEADER", "CONTENT_ENCODING_GZIP", "CONTENT_TYPE_HEADER", "CONTENT_TYPE_JSON", "USER_AGENT_HEADER", "checkStatusCodeWithLogging", "", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "requestName", "statusCode", "", "bodyStream", "Ljava/io/InputStream;", "responseReaderWithLogging", "Ljava/io/Reader;", "stream", "readSuccessResponseWithLogging", "T", "request", "Ljava/net/http/HttpRequest;", "responseInfo", "Ljava/net/http/HttpResponse$ResponseInfo;", "reader", "Lkotlin/Function1;", "(Lcom/intellij/openapi/diagnostic/Logger;Ljava/net/http/HttpRequest;Ljava/net/http/HttpResponse$ResponseInfo;Ljava/io/InputStream;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "inflateAndReadWithErrorHandlingAndLogging", "Ljava/net/http/HttpResponse$BodyHandler;", "mapToResult", "Lkotlin/Function2;", "getUserAgentValue", "agentName", "intellij.platform.collaborationTools"})
@SourceDebugExtension(value={"SMAP\nHttpClientUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpClientUtil.kt\ncom/intellij/collaboration/api/httpclient/HttpClientUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,178:1\n1#2:179\n*E\n"})
public final class HttpClientUtil {
    @NotNull
    public static final HttpClientUtil INSTANCE = new HttpClientUtil();
    @NotNull
    public static final String ACCEPT_ENCODING_HEADER = "Accept-Encoding";
    @NotNull
    public static final String CONTENT_ENCODING_HEADER = "Content-Encoding";
    @NotNull
    public static final String CONTENT_ENCODING_GZIP = "gzip";
    @NotNull
    public static final String CONTENT_TYPE_HEADER = "Content-Type";
    @NotNull
    public static final String CONTENT_TYPE_JSON = "application/json";
    @NotNull
    public static final String USER_AGENT_HEADER = "User-Agent";

    private HttpClientUtil() {
    }

    public final void checkStatusCodeWithLogging(@NotNull Logger logger, @NotNull String requestName, int statusCode, @NotNull InputStream bodyStream) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)requestName, (String)"requestName");
        Intrinsics.checkNotNullParameter((Object)bodyStream, (String)"bodyStream");
        logger.debug(requestName + " : Status code " + statusCode);
        if (statusCode >= 400) {
            InputStream inputStream = bodyStream;
            Charset charset = Charsets.UTF_8;
            String errorBody = TextStreamsKt.readText((Reader)new InputStreamReader(inputStream, charset));
            if (logger.isTraceEnabled()) {
                logger.trace(requestName + " : Response body: " + errorBody);
            }
            throw new HttpStatusErrorException(requestName, statusCode, errorBody);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Reader responseReaderWithLogging(Logger logger, String requestName, InputStream stream) {
        if (logger.isTraceEnabled()) {
            String string;
            Closeable closeable = stream;
            Object object = Charsets.UTF_8;
            closeable = new InputStreamReader((InputStream)closeable, (Charset)object);
            object = null;
            try {
                InputStreamReader it = (InputStreamReader)closeable;
                boolean bl = false;
                string = TextStreamsKt.readText((Reader)it);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
            }
            String body = string;
            logger.trace(requestName + " : Response body: " + body);
            return new StringReader(body);
        }
        InputStream inputStream = stream;
        Charset charset = Charsets.UTF_8;
        return new InputStreamReader(inputStream, charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T readSuccessResponseWithLogging(@NotNull Logger logger, @NotNull HttpRequest request, @NotNull HttpResponse.ResponseInfo responseInfo, @NotNull InputStream bodyStream, @NotNull Function1<? super Reader, ? extends T> reader) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)responseInfo, (String)"responseInfo");
        Intrinsics.checkNotNullParameter((Object)bodyStream, (String)"bodyStream");
        Intrinsics.checkNotNullParameter(reader, (String)"reader");
        this.checkStatusCodeWithLogging(logger, HttpApiHelperKt.logName(request), responseInfo.statusCode(), bodyStream);
        Closeable closeable = this.responseReaderWithLogging(logger, HttpApiHelperKt.logName(request), bodyStream);
        Throwable throwable = null;
        try {
            object = reader.invoke((Object)closeable);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return (T)object;
    }

    @NotNull
    public final <T> HttpResponse.BodyHandler<T> inflateAndReadWithErrorHandlingAndLogging(@NotNull Logger logger, @NotNull HttpRequest request, @NotNull Function2<? super Reader, ? super HttpResponse.ResponseInfo, ? extends T> mapToResult) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(mapToResult, (String)"mapToResult");
        return new InflatedStreamReadingBodyHandler((arg_0, arg_1) -> HttpClientUtil.inflateAndReadWithErrorHandlingAndLogging$lambda$2(logger, request, mapToResult, arg_0, arg_1));
    }

    @NotNull
    public final String getUserAgentValue(@NotNull String agentName) {
        String string;
        Intrinsics.checkNotNullParameter((Object)agentName, (String)"agentName");
        String string2 = ApplicationNamesInfo.getInstance().getFullProductName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getFullProductName(...)");
        String ideName = StringsKt.replace$default((String)string2, (char)' ', (char)'-', (boolean)false, (int)4, null);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            string = "test";
        } else {
            String string3 = ApplicationInfo.getInstance().getBuild().asStringWithoutProductCode();
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"asStringWithoutProductCode(...)");
        }
        String ideBuild = string;
        String java = "JRE " + SystemInfo.JAVA_RUNTIME_VERSION;
        String os = SystemInfo.OS_NAME + " " + SystemInfo.OS_VERSION;
        String arch = SystemInfo.OS_ARCH;
        return agentName + " " + ideName + "/" + ideBuild + " (" + java + "; " + os + "; " + arch + ")";
    }

    private static final Object inflateAndReadWithErrorHandlingAndLogging$lambda$2$lambda$1(Function2 $mapToResult, HttpResponse.ResponseInfo $responseInfo, Reader reader) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        return $mapToResult.invoke((Object)reader, (Object)$responseInfo);
    }

    private static final Object inflateAndReadWithErrorHandlingAndLogging$lambda$2(Logger $logger, HttpRequest $request, Function2 $mapToResult, HttpResponse.ResponseInfo responseInfo, InputStream bodyStream) {
        Intrinsics.checkNotNullParameter((Object)responseInfo, (String)"responseInfo");
        Intrinsics.checkNotNullParameter((Object)bodyStream, (String)"bodyStream");
        return INSTANCE.readSuccessResponseWithLogging($logger, $request, responseInfo, bodyStream, arg_0 -> HttpClientUtil.inflateAndReadWithErrorHandlingAndLogging$lambda$2$lambda$1($mapToResult, responseInfo, arg_0));
    }
}

