/*
 * Decompiled with CFR 0.152.
 */
package help.validator.location;

import help.CustomTOCView;
import help.HelpBuildUtils;
import help.PathKey;
import help.TOCItemProvider;
import help.validator.location.GeneratedDirectoryHelpModuleLocation;
import help.validator.location.HelpModuleLocation;
import help.validator.model.AnchorDefinition;
import help.validator.model.GhidraTOCFile;
import help.validator.model.HREF;
import help.validator.model.HelpFile;
import help.validator.model.HelpTopic;
import help.validator.model.IMG;
import help.validator.model.TOCItem;
import help.validator.model.TOCItemDefinition;
import help.validator.model.TOCItemExternal;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.help.HelpSet;
import javax.help.Map;
import javax.help.TOCView;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class HelpModuleCollection
implements TOCItemProvider {
    private Collection<HelpModuleLocation> helpLocations;
    private HelpModuleLocation inputHelp;
    private List<HelpSet> externalHelpSets;
    private Map<PathKey, HelpFile> pathToHelpFileMap;

    public static HelpModuleCollection fromHelpDirectory(File dir) {
        return new HelpModuleCollection(HelpModuleCollection.toHelpLocations(Collections.singleton(dir)));
    }

    public static HelpModuleCollection fromFiles(Collection<File> files) {
        return new HelpModuleCollection(HelpModuleCollection.toHelpLocations(files));
    }

    public static HelpModuleCollection fromHelpLocations(Collection<HelpModuleLocation> locations) {
        return new HelpModuleCollection(locations);
    }

    private static Set<HelpModuleLocation> toHelpLocations(Collection<File> files) {
        HashSet<HelpModuleLocation> set = new HashSet<HelpModuleLocation>();
        for (File file : files) {
            set.add(HelpBuildUtils.toLocation(file));
        }
        return set;
    }

    private HelpModuleCollection(Collection<HelpModuleLocation> locations) {
        this.helpLocations = locations.stream().filter(l -> l != null).collect(Collectors.toCollection(LinkedHashSet::new));
        this.loadTOCs();
        this.loadHelpSets();
        if (this.inputHelp == null && this.externalHelpSets.size() == 0) {
            throw new IllegalArgumentException("Required TOC file does not exist.  You must create a TOC_Source.xml file, even if it is an empty template, or provide a pre-built TOC.  Help directories: " + locations.toString());
        }
    }

    public void addGeneratedHelpLocation(File file) {
        GeneratedDirectoryHelpModuleLocation location = new GeneratedDirectoryHelpModuleLocation(file);
        this.helpLocations.add(location);
        HelpSet helpSet = location.getHelpSet();
        if (helpSet != null) {
            this.externalHelpSets.add(helpSet);
        }
    }

    public GhidraTOCFile getSourceTOCFile() {
        return this.inputHelp.getSourceTOCFile();
    }

    private void loadTOCs() {
        for (HelpModuleLocation location : this.helpLocations) {
            if (!location.isHelpInputSource()) continue;
            if (this.inputHelp != null) {
                throw new IllegalArgumentException("Cannot have more than one source input help module.  Found a second input module: " + String.valueOf(location));
            }
            this.inputHelp = location;
        }
    }

    private void loadHelpSets() {
        this.externalHelpSets = new ArrayList<HelpSet>();
        for (HelpModuleLocation location : this.helpLocations) {
            this.doAddHelpSet(location);
        }
    }

    private void doAddHelpSet(HelpModuleLocation location) {
        if (location.isHelpInputSource()) {
            return;
        }
        HelpSet helpSet = location.getHelpSet();
        this.externalHelpSets.add(helpSet);
    }

    public boolean containsHelpFiles() {
        for (HelpModuleLocation location : this.helpLocations) {
            if (!location.containsHelp()) continue;
            return true;
        }
        return false;
    }

    public Collection<Path> getHelpRoots() {
        ArrayList<Path> result = new ArrayList<Path>();
        for (HelpModuleLocation location : this.helpLocations) {
            result.add(location.getHelpLocation());
        }
        return result;
    }

    public Map<HelpFile, Map<String, List<AnchorDefinition>>> getDuplicateAnchorsByFile() {
        HashMap<HelpFile, Map<String, List<AnchorDefinition>>> result = new HashMap<HelpFile, Map<String, List<AnchorDefinition>>>();
        for (HelpModuleLocation location : this.helpLocations) {
            Map<HelpFile, Map<String, List<AnchorDefinition>>> anchors = location.getDuplicateAnchorsByFile();
            result.putAll(anchors);
        }
        return result;
    }

    public Map<HelpTopic, List<AnchorDefinition>> getDuplicateAnchorsByTopic() {
        HashMap<HelpTopic, List<AnchorDefinition>> result = new HashMap<HelpTopic, List<AnchorDefinition>>();
        for (HelpModuleLocation location : this.helpLocations) {
            Map<HelpTopic, List<AnchorDefinition>> anchors = location.getDuplicateAnchorsByTopic();
            result.putAll(anchors);
        }
        return result;
    }

    public Collection<HREF> getAllHREFs() {
        ArrayList<HREF> result = new ArrayList<HREF>();
        for (HelpModuleLocation location : this.helpLocations) {
            result.addAll(location.getAllHREFs());
        }
        return result;
    }

    public Collection<IMG> getAllIMGs() {
        ArrayList<IMG> result = new ArrayList<IMG>();
        for (HelpModuleLocation location : this.helpLocations) {
            result.addAll(location.getAllIMGs());
        }
        return result;
    }

    public Collection<AnchorDefinition> getAllAnchorDefinitions() {
        ArrayList<AnchorDefinition> result = new ArrayList<AnchorDefinition>();
        for (HelpModuleLocation location : this.helpLocations) {
            Collection<AnchorDefinition> anchors = location.getAllAnchorDefinitions();
            result.addAll(anchors);
        }
        return result;
    }

    public AnchorDefinition getAnchorDefinition(Path target) {
        Map<PathKey, HelpFile> map = this.getPathHelpFileMap();
        HelpFile helpFile = map.get(new PathKey(target));
        if (helpFile == null) {
            return null;
        }
        AnchorDefinition definition = helpFile.getAnchorDefinition(target);
        return definition;
    }

    public HelpFile getHelpFile(Path helpPath) {
        if (helpPath == null) {
            return null;
        }
        Map<PathKey, HelpFile> map = this.getPathHelpFileMap();
        return map.get(new PathKey(helpPath));
    }

    private Map<PathKey, HelpFile> getPathHelpFileMap() {
        if (this.pathToHelpFileMap == null) {
            this.pathToHelpFileMap = new HashMap<PathKey, HelpFile>();
            for (HelpModuleLocation location : this.helpLocations) {
                Collection<HelpFile> helpFiles = location.getHelpFiles();
                for (HelpFile helpFile : helpFiles) {
                    PathKey entry = new PathKey(helpFile.getRelativePath());
                    this.pathToHelpFileMap.put(entry, helpFile);
                }
            }
        }
        return this.pathToHelpFileMap;
    }

    @Override
    public Map<String, TOCItemDefinition> getTocDefinitionsByID() {
        HashMap<String, TOCItemDefinition> map = new HashMap<String, TOCItemDefinition>();
        GhidraTOCFile TOC = this.inputHelp.getSourceTOCFile();
        map.putAll(TOC.getTOCDefinitionByIDMapping());
        return map;
    }

    @Override
    public Map<String, TOCItemExternal> getExternalTocItemsById() {
        HashMap<String, TOCItemExternal> map = new HashMap<String, TOCItemExternal>();
        if (this.externalHelpSets.isEmpty()) {
            return map;
        }
        for (HelpSet helpSet : this.externalHelpSets) {
            TOCView view = (TOCView)helpSet.getNavigatorView("TOC");
            DefaultMutableTreeNode node = view.getDataAsTree();
            URL url = helpSet.getHelpSetURL();
            try {
                URL dataURL = new URL(url, (String)view.getParameters().get("data"));
                Path path = Paths.get(dataURL.toURI());
                this.addPrebuiltItem(node, path, map);
            }
            catch (MalformedURLException | URISyntaxException e) {
                throw new RuntimeException("Internal error", e);
            }
        }
        return map;
    }

    private void addPrebuiltItem(DefaultMutableTreeNode tn, Path tocPath, Map<String, TOCItemExternal> mapByDisplay) {
        Object userObject = tn.getUserObject();
        CustomTOCView.CustomTreeItemDecorator item = (CustomTOCView.CustomTreeItemDecorator)((Object)userObject);
        if (item != null) {
            CustomTOCView.CustomTreeItemDecorator dec;
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)tn.getParent();
            TOCItemExternal parentItem = null;
            if (parent != null && (dec = (CustomTOCView.CustomTreeItemDecorator)((Object)parent.getUserObject())) != null) {
                parentItem = mapByDisplay.get(dec.getTocID());
            }
            Map.ID targetID = item.getID();
            String displayText = item.getDisplayText();
            String tocId = item.getTocID();
            String target = targetID == null ? null : targetID.getIDString();
            TOCItemExternal external = new TOCItemExternal(parentItem, tocPath, tocId, displayText, target, item.getName(), -1);
            mapByDisplay.put(tocId, external);
        }
        Enumeration<TreeNode> children = tn.children();
        while (children.hasMoreElements()) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)children.nextElement();
            this.addPrebuiltItem(child, tocPath, mapByDisplay);
        }
    }

    public Collection<TOCItem> getInputTOCItems() {
        ArrayList<TOCItem> items = new ArrayList<TOCItem>();
        GhidraTOCFile TOC = this.inputHelp.getSourceTOCFile();
        items.addAll(TOC.getAllTOCItems());
        return items;
    }

    public Collection<HREF> getTOC_HREFs() {
        ArrayList<HREF> definitions = new ArrayList<HREF>();
        GhidraTOCFile TOC = this.inputHelp.getSourceTOCFile();
        definitions.addAll(this.getTOC_HREFs(TOC));
        return definitions;
    }

    private Collection<HREF> getTOC_HREFs(GhidraTOCFile file) {
        Collection<TOCItemDefinition> definitions = file.getTOCDefinitions();
        HashSet<HREF> hrefs = new HashSet<HREF>();
        for (TOCItemDefinition definition : definitions) {
            if (definition.getTargetAttribute() == null) continue;
            try {
                hrefs.add(new HREF(this.inputHelp, file.getFile(), definition.getTargetAttribute(), definition.getLineNumber()));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Malformed reference: ", e);
            }
        }
        return hrefs;
    }

    public String toString() {
        return this.helpLocations.toString();
    }
}

