/*
 * Decompiled with CFR 0.152.
 */
package generic.depends;

import generic.depends.err.ServiceConstructionException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;

class DependentServiceConstructor<T> {
    final Class<T> cls;
    final Method method;

    DependentServiceConstructor(Class<T> cls, Method method) {
        if (!cls.isAssignableFrom(method.getReturnType())) {
            throw new IllegalArgumentException("Constructor method must return type assignable to the class");
        }
        this.cls = cls;
        this.method = method;
    }

    T construct(Object obj, Map<Class<?>, Object> dependencies) throws ServiceConstructionException {
        ArrayList<Object> params = new ArrayList<Object>(this.method.getParameterCount());
        for (Class<?> pType : this.method.getParameterTypes()) {
            Object p = dependencies.get(pType);
            assert (p != null);
            params.add(p);
        }
        try {
            return (T)this.method.invoke(obj, params.toArray());
        }
        catch (InvocationTargetException e) {
            throw new ServiceConstructionException("Error constructing dependent service via " + String.valueOf(this.method), e.getCause());
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new AssertionError((Object)e);
        }
    }
}

