/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.client.tracermi;

import ghidra.app.plugin.core.debug.client.tracermi.MemoryMapper;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.LanguageID;
import ghidra.program.model.lang.LanguageNotFoundException;
import ghidra.program.model.lang.LanguageService;
import ghidra.program.util.DefaultLanguageService;

public class DefaultMemoryMapper
implements MemoryMapper {
    private final AddressFactory factory;

    public DefaultMemoryMapper(LanguageID id) {
        LanguageService langServ = DefaultLanguageService.getLanguageService();
        try {
            Language lang = langServ.getLanguage(id);
            this.factory = lang.getAddressFactory();
        }
        catch (LanguageNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Address map(Address address) {
        return address;
    }

    @Override
    public Address mapBack(Address address) {
        return address;
    }

    @Override
    public Address genAddr(String space, long offset) {
        return this.factory.getAddressSpace(space).getAddress(offset);
    }
}

