/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pyghidra.property;

import ghidra.pyghidra.property.BooleanJavaProperty;
import ghidra.pyghidra.property.ByteJavaProperty;
import ghidra.pyghidra.property.CharacterJavaProperty;
import ghidra.pyghidra.property.DoubleJavaProperty;
import ghidra.pyghidra.property.FloatJavaProperty;
import ghidra.pyghidra.property.IntegerJavaProperty;
import ghidra.pyghidra.property.JavaProperty;
import ghidra.pyghidra.property.LongJavaProperty;
import ghidra.pyghidra.property.ObjectJavaProperty;
import ghidra.pyghidra.property.ShortJavaProperty;
import java.lang.invoke.MethodHandle;

class JavaPropertyFactory {
    private JavaPropertyFactory() {
    }

    static JavaProperty<?> getProperty(String field, MethodHandle getter, MethodHandle setter) {
        Class<?> cls;
        Class<?> clazz = cls = getter != null ? getter.type().returnType() : setter.type().lastParameterType();
        if (!cls.isPrimitive()) {
            return new ObjectJavaProperty(field, getter, setter);
        }
        if (cls == Boolean.TYPE) {
            return new BooleanJavaProperty(field, getter, setter);
        }
        if (cls == Byte.TYPE) {
            return new ByteJavaProperty(field, getter, setter);
        }
        if (cls == Character.TYPE) {
            return new CharacterJavaProperty(field, getter, setter);
        }
        if (cls == Double.TYPE) {
            return new DoubleJavaProperty(field, getter, setter);
        }
        if (cls == Float.TYPE) {
            return new FloatJavaProperty(field, getter, setter);
        }
        if (cls == Integer.TYPE) {
            return new IntegerJavaProperty(field, getter, setter);
        }
        if (cls == Long.TYPE) {
            return new LongJavaProperty(field, getter, setter);
        }
        if (cls == Short.TYPE) {
            return new ShortJavaProperty(field, getter, setter);
        }
        return new ObjectJavaProperty(field, getter, setter);
    }
}

