/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.base.memsearch.bytesequence;

import ghidra.features.base.memsearch.bytesequence.ByteSequence;
import ghidra.features.base.memsearch.bytesource.AddressableByteSource;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;

public class AddressableByteSequence
implements ByteSequence {
    private final AddressableByteSource byteSource;
    private final byte[] bytes;
    private final int capacity;
    private Address startAddress;
    private int length;

    public AddressableByteSequence(AddressableByteSource byteSource, int capacity) {
        this.byteSource = byteSource;
        this.capacity = capacity;
        this.length = 0;
        this.bytes = new byte[capacity];
    }

    public void clear() {
        this.startAddress = null;
        this.length = 0;
    }

    public void setRange(AddressRange range) {
        try {
            this.setRange(range.getMinAddress(), range.getBigLength().intValueExact());
        }
        catch (ArithmeticException e) {
            throw new IllegalArgumentException("Length exceeds capacity");
        }
    }

    public Address getAddress(int index) {
        if (index < 0 || index >= this.length) {
            throw new IndexOutOfBoundsException();
        }
        if (index == 0) {
            return this.startAddress;
        }
        return this.startAddress.add((long)index);
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public byte getByte(int index) {
        if (index < 0 || index >= this.length) {
            throw new IndexOutOfBoundsException();
        }
        return this.bytes[index];
    }

    @Override
    public byte[] getBytes(int index, int size) {
        if (index < 0 || index + size > this.length) {
            throw new IndexOutOfBoundsException();
        }
        byte[] results = new byte[size];
        System.arraycopy(this.bytes, index, results, 0, size);
        return results;
    }

    @Override
    public boolean hasAvailableBytes(int index, int length) {
        return index >= 0 && index + length <= this.getLength();
    }

    private void setRange(Address start, int length) {
        if (length > this.capacity) {
            throw new IllegalArgumentException("Length exceeds capacity");
        }
        this.startAddress = start;
        this.length = length;
        this.byteSource.getBytes(start, this.bytes, length);
    }
}

