/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.datatype.microsoft;

import ghidra.app.util.datatype.microsoft.GuidUtil;
import ghidra.util.Conv;
import ghidra.util.DataConverter;
import ghidra.util.Msg;
import ghidra.util.NumericUtilities;

public class NewGuid {
    public static int size = 16;
    private long[] data = new long[4];
    private byte[] allBytes = new byte[size];
    private String version;
    private String name;
    private GuidUtil.GuidType type;

    public NewGuid(DataConverter conv, String GUID2, String delim, GuidUtil.GuidType type, boolean hasVersion) {
        int vpos;
        this.type = type;
        String strippedGUID = GUID2.replaceAll(delim, "");
        strippedGUID = strippedGUID.substring(0, strippedGUID.indexOf(" "));
        if (strippedGUID.length() != size * 2) {
            Msg.error((Object)this, (Object)("ERROR PARSING GUID: " + GUID2));
        }
        this.data[0] = 0xFFFFFFFFL & NumericUtilities.parseHexLong((String)strippedGUID.substring(0, 8));
        Object str = strippedGUID.substring(8, 16);
        str = ((String)str).substring(4, 8) + ((String)str).substring(0, 4);
        this.data[1] = 0xFFFFFFFFL & NumericUtilities.parseHexLong((String)str);
        str = strippedGUID.substring(16, 24);
        str = ((String)str).substring(6, 8) + ((String)str).substring(4, 6) + ((String)str).substring(2, 4) + ((String)str).substring(0, 2);
        this.data[2] = 0xFFFFFFFFL & NumericUtilities.parseHexLong((String)str);
        str = strippedGUID.substring(24, 32);
        str = ((String)str).substring(6, 8) + ((String)str).substring(4, 6) + ((String)str).substring(2, 4) + ((String)str).substring(0, 2);
        this.data[3] = 0xFFFFFFFFL & NumericUtilities.parseHexLong((String)str);
        for (int i = 0; i < this.data.length; ++i) {
            conv.getBytes((int)this.data[i], this.allBytes, i * 4);
        }
        String left = GUID2.substring(36);
        if (hasVersion && (vpos = left.indexOf("v")) > 0) {
            int sppos = (left = left.substring(vpos)).indexOf(" ");
            this.version = sppos > 0 ? left.substring(0, sppos) : left.substring(0);
            left = left.substring(this.version.length());
        }
        this.name = left.substring(left.indexOf(" ") + 1);
    }

    public NewGuid(DataConverter conv, byte[] bytes, int offset) {
        if (bytes.length < offset + this.data.length * 4) {
            return;
        }
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = 0xFFFFFFFFL & (long)conv.getInt(bytes, offset + i * 4);
            conv.getBytes((int)this.data[i], this.allBytes, i * 4);
        }
    }

    public String toString(String delim, boolean useName) {
        int i;
        if (this.name != null && useName) {
            return this.name;
        }
        String retVal = this.type.toString() + delim;
        retVal = retVal + Conv.toHexString((int)((int)this.data[0])) + delim;
        retVal = retVal + Conv.toHexString((short)((short)this.data[1])) + delim;
        retVal = retVal + Conv.toHexString((short)((short)(this.data[1] >> 16))) + delim;
        for (i = 0; i < 4; ++i) {
            retVal = retVal + Conv.toHexString((byte)((byte)(this.data[2] >> i * 8)));
            if (i != 1) continue;
            retVal = retVal + delim;
        }
        for (i = 0; i < 4; ++i) {
            retVal = retVal + Conv.toHexString((byte)((byte)(this.data[3] >> i * 8)));
        }
        return retVal;
    }

    public boolean isOK() {
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i] == 0L && this.data[i] == 0xFFFFFFFFL) continue;
            return true;
        }
        return false;
    }

    public static boolean isOKForGUID(byte[] bytes, int offset) {
        if (bytes.length < offset + size) {
            return false;
        }
        if (bytes[offset + 7] == 0 && bytes[offset + 8] == -64 && bytes[offset + 15] == 70) {
            return true;
        }
        if (bytes[offset + 7] >= 16 && bytes[offset + 7] <= 18 && (bytes[offset + 8] & 0xFFFFFFC0) == -128) {
            return true;
        }
        return (bytes[offset + 7] & 0xFFFFFFF0) == 64 && (bytes[offset + 8] & 0xFFFFFFC0) == -128;
    }

    public static boolean isZeroGUID(byte[] bytes, int offset) {
        if (bytes.length < offset + size) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            if (bytes[offset + i] == 0) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object test) {
        if (!(test instanceof NewGuid)) {
            return false;
        }
        byte[] testBytes = ((NewGuid)test).getBytes();
        for (int i = 0; i < this.allBytes.length; ++i) {
            if (this.allBytes[i] == testBytes[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return (int)(this.data[0] ^ this.data[1] ^ this.data[2] ^ this.data[3]);
    }

    public byte[] getBytes() {
        return this.allBytes;
    }

    public String getName() {
        return this.toString("-", true);
    }

    public String getVersion() {
        return this.version;
    }

    public GuidUtil.GuidType getType() {
        return this.type;
    }
}

