/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.commands.dyld;

import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.EnumDataType;

public enum BindOpcode {
    BIND_OPCODE_DONE(0),
    BIND_OPCODE_SET_DYLIB_ORDINAL_IMM(16),
    BIND_OPCODE_SET_DYLIB_ORDINAL_ULEB(32),
    BIND_OPCODE_SET_DYLIB_SPECIAL_IMM(48),
    BIND_OPCODE_SET_SYMBOL_TRAILING_FLAGS_IMM(64),
    BIND_OPCODE_SET_TYPE_IMM(80),
    BIND_OPCODE_SET_ADDEND_SLEB(96),
    BIND_OPCODE_SET_SEGMENT_AND_OFFSET_ULEB(112),
    BIND_OPCODE_ADD_ADDR_ULEB(128),
    BIND_OPCODE_DO_BIND(144),
    BIND_OPCODE_DO_BIND_ADD_ADDR_ULEB(160),
    BIND_OPCODE_DO_BIND_ADD_ADDR_IMM_SCALED(176),
    BIND_OPCODE_DO_BIND_ULEB_TIMES_SKIPPING_ULEB(192),
    BIND_OPCODE_THREADED(208);

    private int opcode;

    private BindOpcode(int opcode) {
        this.opcode = opcode;
    }

    public int getOpcode() {
        return this.opcode;
    }

    public static DataType toDataType() {
        EnumDataType enumDataType = new EnumDataType("bind_opcode", 1);
        enumDataType.setCategoryPath(new CategoryPath("/MachO"));
        for (BindOpcode bindOpcode : BindOpcode.values()) {
            enumDataType.add(bindOpcode.toString(), (long)bindOpcode.getOpcode());
        }
        return enumDataType;
    }

    public static BindOpcode forOpcode(int opcode) {
        for (BindOpcode bindOpcode : BindOpcode.values()) {
            if (bindOpcode.getOpcode() != opcode) continue;
            return bindOpcode;
        }
        return null;
    }
}

